/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.JMSDestinationInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MetadataNameConstraint;
import com.sas.services.information.metadata.OMRAbstractQueueManager;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.util.Names;
import com.sas.services.util.UpgradeInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRJMSDestination
extends Metadata
implements UpgradeInterface,
JMSDestinationInterface {
    private List m_props;
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRJMSDestination() throws RemoteException {
        super(OMRJMSDestination.class);
    }

    public OMRJMSDestination(Transformation transformation) throws RemoteException {
        super(transformation, OMRJMSDestination.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRJMSDestination(TransformationImpl transformation) throws RemoteException {
        super(transformation, OMRJMSDestination.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRJMSDestination(TransformationImpl_Stub transformation) throws RemoteException {
        super(transformation, OMRJMSDestination.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRJMSDestination(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Transformation transformation = (Transformation)omirepository.createMetadata(name, "Transformation");
                transformation.setPublicType("JMSDestination");
                transformation.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                transformation.setTransformRole("JMSDestination");
                this._repositoryObject = transformation;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    transformation.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
    }

    public OMRJMSDestination(RepositoryInterface repository, String jmsDestName, String jmsDestDescription, ServerComponentInterface jmsQueueManager) throws ServiceException, RemoteException {
        super(OMRJMSDestination.class);
        if (repository == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.repository.ex.txt"));
        }
        if (jmsDestName == null || jmsDestName.trim().length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.name.ex.txt"));
        }
        if (jmsQueueManager == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.serverComponent.ex.txt"));
        }
        if (!"JMSDestination".equals(jmsQueueManager.getClassIdentifier())) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRJMSDestination.serverComponentNotQueueManager.ex.fmt.txt", (Object)jmsQueueManager.getName()));
        }
        ServerComponent serverComponent = (ServerComponent)jmsQueueManager.getRepositoryEntity();
        Transformation transformation = null;
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repository;
            transformation = (Transformation)omirepository.createMetadata(jmsDestName, "Transformation");
            transformation.setPublicType("MessageQueue");
            transformation.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            transformation.setTransformRole("JMSDestination");
            transformation.setDesc(jmsDestDescription);
            AssociationList depComponents = transformation.getDeployedComponents();
            if (!depComponents.contains(serverComponent)) {
                depComponents.add(serverComponent);
            }
            this._repositoryObject = transformation;
            this._repositoryFlag = 2;
            this.setRepository(repository);
        }
        catch (MdException e) {
            if (transformation != null) {
                transformation.delete();
            }
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"OMRJMSDestination.create.ex.fmt.txt", (Object)jmsDestName));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "JMSDestination";
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this._repository.refreshEntity(this);
        Transformation transformation = this.getTransformation();
        try {
            AssociationList depComponents = transformation.getDeployedComponents(true);
            Iterator iter = depComponents.iterator();
            DeployedComponent deployedComponent = null;
            while (iter.hasNext()) {
                deployedComponent = (DeployedComponent)iter.next();
                ((MdObjectStore)deployedComponent.getObjectStore()).refreshObjectFromServer((CMetadata)deployedComponent, false, true);
            }
        }
        catch (MdException mex) {
            this.logThrowable(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRJMSDestination", mex);
        }
    }

    private Transformation getTransformation() {
        return (Transformation)this._repositoryObject;
    }

    @Override
    public ServerComponentInterface getQueueManager() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Transformation transformation = this.getTransformation();
        try {
            AssociationList dcList = transformation.getDeployedComponents();
            if (dcList.size() > 0) {
                DeployedComponent dc = (DeployedComponent)dcList.get(0);
                ServerComponentInterface sci = (ServerComponentInterface)this._repository.factoryProcess(dc);
                return sci;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    @Override
    public void setQueueManager(ServerComponentInterface server) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!"JMSDestination".equals(server.getClassIdentifier())) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"OMRJMSDestination.serverComponentNotQueueManager.ex.fmt.txt", (Object)server.getName()));
        }
        Transformation transformation = this.getTransformation();
        try {
            AssociationList dcList = transformation.getDeployedComponents();
            dcList.clear();
            if (dcList.size() > 0) {
                DeployedComponent dc = (DeployedComponent)server.getRepositoryEntity();
                dcList.add(dc);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this._repositoryObject != null && this._repositoryObject instanceof Transformation) {
            if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), CURRENT_VERSION)) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            Transformation jmsDest = this.getTransformation();
            while (!Names.validateOMRObjectName(jmsDest.getName(), false)) {
                String value;
                String name = null;
                if (jmsDest.getName().length() > 60) {
                    name = jmsDest.getName().substring(0, 60);
                } else if (Character.isSpaceChar(jmsDest.getName().charAt(0)) || Character.isSpaceChar(jmsDest.getName().charAt(jmsDest.getName().length() - 1))) {
                    name = jmsDest.getName().trim();
                } else if (jmsDest.getName().contains("\\")) {
                    value = "\\";
                    name = jmsDest.getName().substring(jmsDest.getName().indexOf("\\") + value.length());
                } else if (jmsDest.getName().contains("/")) {
                    value = "/";
                    name = jmsDest.getName().substring(jmsDest.getName().indexOf("/") + value.length());
                }
                if (name == null) continue;
                jmsDest.setName(name);
            }
            if (jmsDest.getUsageVersion() < CURRENT_VERSION.encode()) {
                jmsDest.setUsageVersion(CURRENT_VERSION.encode());
            }
            JMSDestinationNameConstraint constraint = null;
            FolderInterface fi = this.getParent();
            if (fi == null) {
                Metadata qMan = null;
                Transformation queueObject = this.getTransformation();
                try {
                    if (queueObject.getDeployedComponents() != null && queueObject.getDeployedComponents().size() != 0) {
                        ServerComponent sc = (ServerComponent)((Transformation)this._repositoryObject).getDeployedComponents().get(0);
                        if (sc.getUsageVersion() < CURRENT_VERSION.encode()) {
                            sc.setUsageVersion(CURRENT_VERSION.encode());
                        }
                        if (sc.getPublicType().length() == 0) {
                            sc.setPublicType("MessageQueue.JMS");
                        }
                        qMan = (OMRAbstractQueueManager)this._repository.factoryProcess(sc);
                    }
                }
                catch (MdException e) {
                    throw new ServiceException(e, e.getMessage());
                }
                if (null == qMan) {
                    this.logMessage(Level.WARN, "When the JMS destination " + this.getName() + " was being upgraded, no queue manager was found.  This JMS destination will be placed in the Message Queues folder.");
                    fi = this.GetMessageQueueFolder();
                } else {
                    FolderInterface ourFolder;
                    String ourReposID;
                    String qManReposID;
                    fi = qMan.getParent();
                    if (null == fi) {
                        ((OMRAbstractQueueManager)qMan).upgradeFromPreviousVersion();
                        fi = qMan.getParent();
                    }
                    if (!(qManReposID = qMan.getReposId().substring(0, 8)).equals(ourReposID = this.getReposId().substring(0, 8)) && null == (fi = (ourFolder = this.GetMessageQueueFolder()).getSubfolder(qMan.getName()))) {
                        fi = ourFolder.makeSubfolder(qMan.getName());
                        fi.update();
                    }
                }
                if (null == fi) {
                    throw new ServiceException(RB.getStringResource("OMRJMSDestination.noFolder.ex.txt"));
                }
                constraint = new JMSDestinationNameConstraint(this, (OMRAbstractQueueManager)qMan);
            }
            this.validateNameAndFolder(fi, constraint);
            this.update();
        }
    }

    private FolderInterface getRootFolder() throws RemoteException, ServiceException {
        boolean isFoundation = this._repository.getServer().getFoundationRepository().getUniqueId().equals(this._repository.getUniqueId());
        FolderInterface fi = isFoundation ? this._repository.getServer().getRootFolder() : (FolderInterface)this._repository.getRootFolders().get(0);
        return fi;
    }

    private FolderInterface GetMessageQueueFolder() throws ServiceException, RemoteException {
        FolderInterface folder;
        FolderInterface root = this.getRootFolder();
        FolderInterface parent = root.getSubfolder("Shared Data");
        if (null == parent) {
            parent = root.makeSubfolder("Shared Data");
            parent.update();
        }
        if (null == (folder = parent.getSubfolder("Message Queues"))) {
            folder = root.makeSubfolder("Message Queues");
            folder.update();
        }
        return folder;
    }

    @Override
    public String getJNDIJMSDestinationName() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Property nameProp = this.getJMSDestinationProperty("jmsDestName");
        if (nameProp != null) {
            return nameProp.getDefaultValue();
        }
        return null;
    }

    @Override
    public void setJNDIJMSDestinationName(String name) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        this.setJMSDestinationProperty("jmsDestName", "JMSDestination.Property.DestinationName.Name.xmlKey.txt", name);
    }

    @Override
    public boolean getJMSDestinationIsTopic() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        Property prop = this.getJMSDestinationProperty("jmsDestIsTopic");
        return prop != null && (prop.getDefaultValue().equals("1") || prop.getDefaultValue().equalsIgnoreCase("true") || prop.getDefaultValue().equalsIgnoreCase("yes"));
    }

    @Override
    public void setJMSDestinationIsTopic(boolean isTopic) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        String boolVal = isTopic ? "1" : "0";
        this.setJMSDestinationProperty("jmsDestIsTopic", "JMSDestination.Property.DestinationIsTopic.Name.xmlKey.txt", boolVal);
    }

    private List getJMSDestinationProperties(boolean toServer) throws RemoteException, MdException {
        if (this.m_props == null || toServer) {
            this.m_props = this.getTransformation().getProperties();
        }
        return this.m_props;
    }

    private Property getJMSDestinationProperty(String name) throws RemoteException, ServiceException {
        try {
            List props = this.getJMSDestinationProperties(false);
            for (int i = 0; i < props.size(); ++i) {
                Property prop = (Property)props.get(i);
                if (!prop.getPropertyName().equalsIgnoreCase(name)) continue;
                return prop;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    private void setJMSDestinationProperty(String name, String newPropName, String value) throws RemoteException, ServiceException {
        try {
            Property prop = this.getJMSDestinationProperty(name);
            if (prop == null) {
                Transformation jmsDest = this.getTransformation();
                prop = (Property)((OMIRepositoryInterface)this._repository).createMetadata(newPropName, "Property");
                prop.setPropertyName(name);
                jmsDest.getProperties().add((Object)prop);
            }
            prop.setDefaultValue(value);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @SASScope
    private class JMSDestinationNameConstraint
    implements MetadataNameConstraint {
        private OMRJMSDestination m_jmsDest;
        private OMRAbstractQueueManager m_jmsMan;

        JMSDestinationNameConstraint(OMRJMSDestination jmsDest, OMRAbstractQueueManager jmsMan) {
            this.m_jmsDest = jmsDest;
            this.m_jmsMan = jmsMan;
        }

        @Override
        public boolean isNameValid(MetadataInterface object, String name) throws ServiceException, RemoteException {
            boolean isUnique = true;
            String query = this.m_jmsMan != null ? "<XMLSelect search=\"*[@PublicType=:'JMSDestination' and @Name='" + name + "'][DeployedComponents/ServerComponent[@Name='" + this.m_jmsDest.getName() + "']]\"/>" : "<XMLSelect search=\"*[@PublicType=:'JMSDestination' and @Name='" + name + "']\"/>";
            Filter filter = new Filter();
            filter.setType("Transformation");
            filter.setOMRFlags(16384);
            filter.setExplicitSearchString("omi", query);
            int count = ((MetadataServerInterface)this.m_jmsDest.getRepository().getServer()).getCountNoSecurity(filter, null);
            if (count > 0) {
                List jmsDests = ((MetadataServerInterface)this.m_jmsDest.getRepository().getServer()).search(filter);
                boolean skip = false;
                for (int i = 0; i < jmsDests.size() && !skip; ++i) {
                    if (!((OMRJMSDestination)jmsDests.get(i)).getReposId().equals(this.m_jmsDest.getReposId())) continue;
                    skip = true;
                }
                if (!skip) {
                    isUnique = false;
                }
            }
            return isUnique;
        }
    }
}

