/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.MachineImpl;
import com.sas.metadata.remote.impl.MachineImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.HostInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.util.UsageVersion;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;

public class OMRHost
extends Metadata
implements HostInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRHost() throws RemoteException {
        this(OMRHost.class);
    }

    protected OMRHost(Class theClass) throws RemoteException {
        super(theClass);
    }

    public OMRHost(Machine host) throws RemoteException {
        this(host, Machine.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRHost(Machine host, Class theClass) throws RemoteException {
        super(host, theClass);
    }

    public OMRHost(MachineImpl host) throws RemoteException {
        this(host, Machine.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRHost(MachineImpl host, Class theClass) throws RemoteException {
        super(host, theClass);
    }

    public OMRHost(MachineImpl_Stub host) throws RemoteException {
        this(host, Machine.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRHost(MachineImpl_Stub host, Class theClass) throws RemoteException {
        super(host, theClass);
    }

    public OMRHost(RepositoryInterface repository, String name) throws RemoteException {
        super(OMRHost.class);
        if (repository == null || name == null) {
            throw new IllegalArgumentException();
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repository;
            Machine host = (Machine)omirepository.createMetadata(name, "Machine");
            host.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = host;
            this._repositoryFlag = 2;
            this.setRepository(repository);
        }
        catch (Throwable t) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRHost", t);
        }
    }

    @Override
    public List<?> getDeployedComponents() throws RemoteException, ServiceException {
        Machine host = (Machine)this.getRepositoryEntity();
        ArrayList<MetadataInterface> components = null;
        try {
            AssociationList deployedComponents = host.getDeployedComponents();
            if (deployedComponents != null) {
                components = new ArrayList<MetadataInterface>(deployedComponents.size());
                for (Object root : deployedComponents) {
                    components.add(this._repository.factoryProcess(root));
                }
            }
        }
        catch (MdException mdException) {
            // empty catch block
        }
        return components;
    }

    @Override
    public InetAddress getHost() throws RemoteException, ServiceException {
        return null;
    }

    @Override
    public String getHostName() throws RemoteException, ServiceException {
        return this.getName();
    }

    @Override
    public void setHostName(String hostName) throws RemoteException, ServiceException {
        this.setName(hostName);
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = false;
        try {
            if (object instanceof OMRHost) {
                equals = this.getHostName().equalsIgnoreCase(((OMRHost)object).getHostName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashcode = -1;
        try {
            hashcode = this.getHostName().hashCode();
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return hashcode;
    }
}

