/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ApplicationInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GaoIdentity;
import com.sas.services.information.metadata.GridApplicationInterface;
import com.sas.services.information.metadata.GridServerInterface;
import com.sas.services.information.metadata.OMRGridApplication;
import com.sas.services.information.metadata.OMRLogicalServer;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

@SASScope
public class OMRGridServer
extends OMRServerComponent
implements GridServerInterface {
    public static final String GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME = "Grid.Application.Client.Mapping";
    public static final String GRIDSERVER_USER_MAPPING_PROPERTY_NAME = "Grid.Application.User.Mapping";
    public static final String GRIDSERVER_REQUIRED_PROPERTY_NAME = "Grid.Required";
    public static final String PROVIDERMODULEPROPERTY = "Server.Grid.Module.Name.xmlKey.txt";
    public static final String PROVIDERMODULEPROPERTYNAME = "ModuleName";
    public static final String GRIDOPTIONPROPERTY = "Server.PropertyGroup.AdditionalOptions.Name.xmlKey.txt";
    public static final String GRIDOPTIONPROPERTYNAME = "OptionString";
    public static final String SASOPTIONSPROPERTY = "Server.Grid.SAS.Options.xmlKey.txt";
    public static final String SASOPTIONSPROPERTYNAME = "SASOptions";
    public static final String REQUIREDRESOURCESPROPERTY = "Server.Grid.Resources.xmlKey.txt";
    public static final String REQUIREDRESOURCESPROPERTYNAME = "RequiredResource";
    public static final String GRIDCOMMANDPROPERTY = "Server.Grid.SASCommand.Name.xmlKey.txt";
    public static final String GRIDCOMMANDPROPERTYNAME = "SASCMD";
    public static final String GRIDWORKLOADPROPERTY = "Server.Grid.Workload.Name.xmlKey.txt";
    public static final String GRIDWORKLOADPROPERTYNAME = "WorkLoad";
    public static final String GRIDMODULENAMEPROPERTY = "Server.Grid.Module.Name.xmlKey.txt";
    public static final String GRIDMODULENAMEPROPERTYNAME = "ModuleName";
    public static final String GRIDREQUIREDRESOURCESPROPERTY = "noAppSvrRes";
    public static final String GRIDREQUIREDRESOURCESNAME = "Server.Grid.CheckBox.Name.xmlKey.txt";
    public static final String GRIDGOSPUBLICTYPE = "GridOptionsSet";
    public static final String CLASSID_APPSERVER = "SAS Application Server";
    public static final String CLASSID_GRIDSERVER = "D7E796B4-654C-4ab3-B690-657EE79309FB";
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(2, 0);

    public OMRGridServer() throws RemoteException {
    }

    public OMRGridServer(ServerComponent o) throws RemoteException {
        this(o, OMRGridServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGridServer(ServerComponentImpl o) throws RemoteException {
        this(o, OMRGridServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGridServer(ServerComponentImpl_Stub o) throws RemoteException {
        this(o, OMRGridServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRGridServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException, ServiceException {
        super(OMRGridServer.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        ServerComponentImpl gridServer = null;
        try {
            gridServer = (ServerComponentImpl)omirepository.createMetadata(name, "ServerComponent");
            this._repositoryObject = gridServer;
            gridServer.setPublicType("Server.Grid");
            gridServer.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                parent.addItem(this);
            }
        }
        catch (ServiceException e) {
            if (gridServer != null) {
                gridServer.delete();
            }
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    protected OMRGridServer(Class<?> theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRGridServer(ServerComponent o, Class<?> theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRGridServer(ServerComponentImpl o, Class<?> theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRGridServer(ServerComponentImpl_Stub o, Class<?> theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRGridServer(RepositoryInterface repos, String name, FolderInterface parent, Class<?> theClass) throws RemoteException {
        super(repos, name, parent, theClass);
    }

    @Override
    public String getType() throws RemoteException {
        return "Server.Grid";
    }

    @Override
    public List<PropertySet> getPropertySetNames() throws ServiceException, RemoteException, MdException {
        ArrayList<PropertySet> propertySetList = new ArrayList<PropertySet>();
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList list = server.getPropertySets();
        for (PropertySet s : list) {
            if (!s.getPropertySetName().equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME)) continue;
            propertySetList.add(s);
        }
        return propertySetList;
    }

    @Override
    public PropertySet getPropertySet(String applicationName) throws ServiceException, RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList list = server.getPropertySets();
        for (PropertySet s : list) {
            if (!s.getPropertySetName().equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME) || !s.getName().equals(applicationName)) continue;
            return s;
        }
        return null;
    }

    @Override
    public void setPropertySetName(String applicationName) throws RemoteException, ServiceException {
        try {
            ServerComponent server = (ServerComponent)this._repositoryObject;
            AssociationList list = server.getPropertySets();
            for (PropertySet s : list) {
                if (!s.getPropertySetName().equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME) || !s.getName().equalsIgnoreCase(applicationName)) continue;
                s.setName(applicationName);
                s.updateMetadataAll();
                return;
            }
            MdObjectStore store = (MdObjectStore)server.getObjectStore();
            MdFactory factory = store.getFactory();
            PropertySet newPropertySet = (PropertySet)factory.createComplexMetadataObject(store, null, GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME, "PropertySet", server.getRepositoryID());
            newPropertySet.setName(applicationName);
            newPropertySet.setPropertySetName(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME);
            server.getPropertySets().add((Object)newPropertySet);
            server.updateMetadataAll();
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public String getGridRequiredProperty(String applicationName) throws ServiceException, RemoteException, MdException {
        PropertySet ps = this.getPropertySet(applicationName);
        if (ps != null) {
            AssociationList list = ps.getProperties();
            for (Property p : list) {
                if (!p.getPropertyName().equalsIgnoreCase(GRIDSERVER_REQUIRED_PROPERTY_NAME)) continue;
                return p.getDefaultValue();
            }
        }
        return null;
    }

    @Override
    public void setGridRequiredProperty(String applicationName, String gridRequired) throws ServiceException, RemoteException {
        try {
            PropertySet ps = this.getPropertySet(applicationName);
            AssociationList list = ps.getProperties();
            for (Property p : list) {
                if (!p.getPropertyName().equalsIgnoreCase(GRIDSERVER_REQUIRED_PROPERTY_NAME)) continue;
                p.setName(gridRequired);
                p.updateMetadataAll();
                return;
            }
            MdObjectStore store = (MdObjectStore)ps.getObjectStore();
            MdFactory factory = store.getFactory();
            Property newProperty = (Property)factory.createComplexMetadataObject(store, null, GRIDSERVER_REQUIRED_PROPERTY_NAME, "Property", ps.getRepositoryID());
            newProperty.setPropertyName(GRIDSERVER_REQUIRED_PROPERTY_NAME);
            newProperty.setDefaultValue(gridRequired);
            ps.getProperties().add((Object)newProperty);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List<String> getUserMappings(String propertySetName) throws ServiceException, RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList list = server.getPropertySets();
        ArrayList<String> newUserList = new ArrayList<String>();
        for (PropertySet s : list) {
            if (!s.getPropertySetName().equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME) || !s.getName().equalsIgnoreCase(propertySetName)) continue;
            AssociationList userList = s.getSetProperties();
            for (Property identity : userList) {
                newUserList.add(identity.getName());
            }
        }
        return newUserList;
    }

    @Override
    public List<GaoIdentity> getUserGaos(String applicationName) throws ServiceException, RemoteException, MdException {
        ArrayList<GaoIdentity> userGao = new ArrayList<GaoIdentity>();
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList list = server.getPropertySets();
        for (PropertySet s : list) {
            String propertySetName = s.getPropertySetName();
            String name = s.getName();
            if (!propertySetName.equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME) || !name.equalsIgnoreCase(applicationName)) continue;
            AssociationList propList = s.getSetProperties();
            for (Property property : propList) {
                CMetadata transformObject;
                if (property == null || property.getSourceTransformations().size() == 0 || (transformObject = (CMetadata)property.getSourceTransformations().get(0)) == null) continue;
                GaoIdentity g = new GaoIdentity(transformObject.getName(), applicationName, property.getName());
                userGao.add(g);
            }
        }
        return userGao;
    }

    @Override
    public void setUserMappings(String propertySetName, List<String> identityList, GridApplicationInterface gao) throws ServiceException, RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList list = server.getPropertySets();
        for (PropertySet s : list) {
            if (!s.getPropertySetName().equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME) || !s.getName().equalsIgnoreCase(propertySetName)) continue;
            AssociationList propList = s.getSetProperties();
            MdObjectStore store = (MdObjectStore)s.getObjectStore();
            MdFactory factory = store.getFactory();
            for (String identityName : identityList) {
                CMetadata transformation;
                int index = this.isNewProperty(identityName, propList);
                if (index < 0) {
                    Property newProperty = (Property)factory.createComplexMetadataObject(store, null, GRIDSERVER_USER_MAPPING_PROPERTY_NAME, "Property", s.getRepositoryID());
                    newProperty.setPropertyName(GRIDSERVER_USER_MAPPING_PROPERTY_NAME);
                    newProperty.setName(identityName);
                    transformation = (CMetadata)gao.getRepositoryEntity();
                    newProperty.getSourceTransformations().add(0, (Object)transformation);
                    propList.add((Object)newProperty);
                } else {
                    String gaoName;
                    Property property = (Property)propList.get(index);
                    if (property.getSourceTransformations().size() != 0 && !(gaoName = property.getSourceTransformations().get(0).toString()).equalsIgnoreCase(gao.getName())) {
                        property.getSourceTransformations().remove(0);
                        CMetadata transformation2 = (CMetadata)gao.getRepositoryEntity();
                        property.getSourceTransformations().add(0, (Object)transformation2);
                        property.updateMetadataAll();
                    }
                    transformation = (CMetadata)gao.getRepositoryEntity();
                    property.getSourceTransformations().add(0, (Object)transformation);
                    property.updateMetadataAll();
                }
                s.updateMetadataAll();
            }
            return;
        }
        this.setPropertySetName(propertySetName);
        this.setUserMappings(propertySetName, identityList, gao);
    }

    private int isNewProperty(String identityName, AssociationList propList) throws RemoteException {
        for (int index = 0; index < propList.size(); ++index) {
            Property property = (Property)propList.get(index);
            if (!property.getName().equalsIgnoreCase(identityName)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public List<String> getRequiredResources() throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = this.getPropertyValue(server, REQUIREDRESOURCESPROPERTY);
        return this.parseStringIntoList(propertyValue);
    }

    @Override
    public void setRequiredResources(List<String> requiredResource) throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String value = this.makePropertyValue(requiredResource);
        this.setPropertyValue(server, REQUIREDRESOURCESPROPERTY, REQUIREDRESOURCESPROPERTYNAME, value);
    }

    @Override
    public String getProvider() throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = server.getProductName();
        return propertyValue;
    }

    @Override
    public void setProvider(String provider) throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        server.setProductName(provider);
    }

    @Override
    public String getGridCommand() throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = this.getPropertyValue(server, GRIDCOMMANDPROPERTY);
        return propertyValue;
    }

    @Override
    public void setGridCommand(String gridCommand) throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        this.setPropertyValue(server, GRIDCOMMANDPROPERTY, GRIDCOMMANDPROPERTYNAME, gridCommand);
    }

    @Override
    public List<String> getSASOptions() throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = this.getPropertyValue(server, SASOPTIONSPROPERTY);
        return this.parseStringIntoList(propertyValue);
    }

    @Override
    public void setSASOptions(List<String> requiredResource) throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String value = this.makePropertyValue(requiredResource);
        this.setPropertyValue(server, SASOPTIONSPROPERTY, SASOPTIONSPROPERTYNAME, value);
    }

    @Override
    public List<String> getGridOptions() throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = this.getPropertyValue(server, GRIDOPTIONPROPERTY);
        return this.parseStringIntoList(propertyValue);
    }

    @Override
    public void setGridOptions(List<String> requiredResource) throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String value = this.makePropertyValue(requiredResource);
        this.setPropertyValue(server, GRIDOPTIONPROPERTY, GRIDOPTIONPROPERTYNAME, value);
    }

    @Override
    public List<String> getGridWorkLoad() throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = this.getPropertyValue(server, GRIDWORKLOADPROPERTY);
        return this.parseStringIntoList(propertyValue);
    }

    @Override
    public void setGridWorkLoad(List<String> workload) throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String value = this.makePropertyValue(workload);
        this.setPropertyValue(server, GRIDWORKLOADPROPERTY, GRIDWORKLOADPROPERTYNAME, value);
    }

    public Double getGridServerUsageVersion() throws RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        double version = server.getUsageVersion();
        return version;
    }

    private String getPropertyValue(ServerComponent server, String propertyName) throws ServiceException, RemoteException {
        try {
            AssociationList properties = server.getProperties();
            for (Property p : properties) {
                if (!propertyName.equals(p.getName())) continue;
                return p.getDefaultValue();
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    private void setPropertyValue(ServerComponent server, String nameOfProperty, String propertyName, String propertyValue) throws ServiceException, RemoteException {
        try {
            AssociationList properties = server.getProperties();
            for (Property p : properties) {
                if (!p.getName().equals(nameOfProperty)) continue;
                p.setDefaultValue(propertyValue);
                return;
            }
            MdObjectStore store = (MdObjectStore)server.getObjectStore();
            MdFactory factory = store.getFactory();
            Property newProperty = (Property)factory.createComplexMetadataObject(store, null, nameOfProperty, "Property", server.getRepositoryID());
            newProperty.setPropertyName(propertyName);
            newProperty.setDefaultValue(propertyValue);
            properties.add((Object)newProperty);
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public AssociationList getServerProperties() throws ServiceException, RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList properties = server.getProperties();
        return properties;
    }

    @Override
    public void setUsageVersion(double versionNumber) throws RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        server.setUsageVersion(versionNumber);
    }

    @Override
    public void setPublicType(String publicType) throws RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        server.setPublicType(publicType);
    }

    @Override
    public void deleteUserMapping(String appName, String gaoName, List<String> identityList) throws RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList list = server.getPropertySets();
        for (PropertySet s : list) {
            if (!s.getPropertySetName().equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME) || !s.getName().equalsIgnoreCase(appName)) continue;
            AssociationList propList = s.getSetProperties();
            for (int index = propList.size() - 1; index >= 0; --index) {
                String _gaoName;
                Property property = (Property)propList.get(index);
                int i = identityList.indexOf(property.getName());
                if (i < 0 || property.getSourceTransformations().size() == 0 || !(_gaoName = property.getSourceTransformations().get(0).toString()).equalsIgnoreCase(gaoName)) continue;
                CMetadata transformationObject = (CMetadata)property.getSourceTransformations().get(0);
                property.removeElementFromChangeList(transformationObject);
                property.delete();
            }
            return;
        }
        server.updateMetadataAll();
    }

    private List<String> parseStringIntoList(String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(propertyValue, " ");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            result.add(nextToken);
        }
        return result;
    }

    private String makePropertyValue(List<String> valueList) {
        if (valueList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String nextValue : valueList) {
            if (!isFirst) {
                sb.append(" ");
            }
            sb.append(nextValue);
            isFirst = false;
        }
        return sb.toString();
    }

    @Override
    public void setGridModuleName(String moduleName) throws ServiceException, RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        this.setPropertyValue(server, "Server.Grid.Module.Name.xmlKey.txt", "ModuleName", moduleName);
    }

    @Override
    public String getGridModuleName() throws ServiceException, RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = this.getPropertyValue(server, "Server.Grid.Module.Name.xmlKey.txt");
        return propertyValue;
    }

    @Override
    public String getRequiredResource() throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        String propertyValue = this.getPropertyValue(server, GRIDREQUIREDRESOURCESNAME);
        return propertyValue;
    }

    @Override
    public void setRequiredResource(String value) throws ServiceException, RemoteException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        this.setPropertyValue(server, GRIDREQUIREDRESOURCESNAME, GRIDREQUIREDRESOURCESPROPERTY, value);
    }

    @Override
    public List<OMRGridApplication> getExistingGridOptionsSetList(ServerInterface authServer) throws ServiceException, RemoteException, MdException {
        ArrayList<OMRGridApplication> gaoList = new ArrayList<OMRGridApplication>();
        FilterComponent fc2 = new FilterComponent("PublicType", 0, GRIDGOSPUBLICTYPE);
        Filter filter = new Filter();
        filter.setFilterComponent(fc2);
        filter.setType("Transformation");
        List serverList = authServer.search(filter);
        for (OMRGridApplication gao : serverList) {
            gaoList.add(gao);
        }
        return gaoList;
    }

    @Override
    public List<OMRGridApplication> getExistingGridOptionsSetList(ServerInterface authServer, ApplicationInterface app) throws ServiceException, RemoteException, MdException {
        FolderInterface parentFolder;
        ArrayList<OMRGridApplication> gaoList = new ArrayList<OMRGridApplication>();
        String applicationName = "";
        FolderInterface folder = app.getParent();
        if (folder != null && (parentFolder = folder.getParent()) != null) {
            applicationName = parentFolder.getName();
        }
        List<OMRGridApplication> totalGaoList = this.getExistingGridOptionsSetList(authServer);
        List<GaoIdentity> gaoIdentityList = this.getUserGaos(applicationName);
        for (OMRGridApplication gao : totalGaoList) {
            if (!this.isGaoWanted(gaoIdentityList, gao)) continue;
            gaoList.add(gao);
        }
        return gaoList;
    }

    @Override
    public List<OMRGridApplication> getExistingGOSListForApp(ServerInterface authServer, String applicationName) throws ServiceException, RemoteException, MdException {
        ArrayList<OMRGridApplication> gaoList = new ArrayList<OMRGridApplication>();
        List<OMRGridApplication> totalGaoList = this.getExistingGridOptionsSetList(authServer);
        List<GaoIdentity> gaoIdentityList = this.getUserGaos(applicationName);
        for (OMRGridApplication gao : totalGaoList) {
            if (!this.isGaoWanted(gaoIdentityList, gao)) continue;
            gaoList.add(gao);
        }
        return gaoList;
    }

    private boolean isGaoWanted(List<GaoIdentity> gaoList, OMRGridApplication gao) {
        for (GaoIdentity g : gaoList) {
            if (!g.getName().equalsIgnoreCase(gao.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public GridApplicationInterface getGridOptionsSet(String gridAppId, String gridAppName, ServerInterface authServer) throws ServiceException, RemoteException {
        GridApplicationInterface gridApp = null;
        FilterComponent fc2 = new FilterComponent("PublicType", 0, GRIDGOSPUBLICTYPE);
        Filter filter = new Filter();
        filter.setFilterComponent(fc2);
        filter.setType("Transformation");
        List serverList = authServer.search(filter);
        if (serverList.size() == 0) {
            return null;
        }
        for (GridApplicationInterface gao : serverList) {
            if (!gao.getIdentifier().equalsIgnoreCase(gridAppId)) continue;
            return gao;
        }
        for (GridApplicationInterface gao : serverList) {
            if (!gao.getName().equalsIgnoreCase(gridAppName)) continue;
            return gao;
        }
        return gridApp;
    }

    @Override
    public List<String> getUserMappings(String propertySetName, String gaoName) throws ServiceException, RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        AssociationList list = server.getPropertySets();
        ArrayList<String> newUserList = new ArrayList<String>();
        for (PropertySet s : list) {
            if (!s.getPropertySetName().equalsIgnoreCase(GRIDSERVER_GRIDAPP_MAPPING_PROPERTY_NAME) || !s.getName().equalsIgnoreCase(propertySetName)) continue;
            AssociationList userList = s.getSetProperties();
            for (Property identity : userList) {
                if (identity.getSourceTransformations() == null || identity.getSourceTransformations().size() == 0) continue;
                String oldGaoName = "";
                Object o = identity.getSourceTransformations().get(0);
                if (o == null || !gaoName.equalsIgnoreCase(oldGaoName = identity.getSourceTransformations().get(0).toString())) continue;
                newUserList.add(identity.getName());
            }
        }
        return newUserList;
    }

    @Override
    public void removePropertySetFromServer(PropertySet ps) throws RemoteException, MdException {
        ServerComponent server = (ServerComponent)this._repositoryObject;
        server.getPropertySets().remove((Object)ps);
    }

    public static ServerComponent getGridServer(ServerInterface server, String wsLogicalName) throws ServiceException, RemoteException, MdException {
        LogicalServer ls = null;
        ServerContext appServer = null;
        ServerComponent gridServer = null;
        Filter filter = new Filter();
        filter.setType("LogicalServer");
        filter.setName(wsLogicalName);
        List serverList = server.search(filter);
        if (serverList.size() > 0) {
            OMRLogicalServer omrLs = (OMRLogicalServer)serverList.get(0);
            ls = (LogicalServer)omrLs.getRepositoryEntity();
        }
        appServer = (ServerContext)ls.getUsedByComponents().get(0);
        AssociationList usingComponents = appServer.getUsingComponents();
        for (LogicalServer logicalServer : usingComponents) {
            if (logicalServer == null || !logicalServer.getClassIdentifier().equalsIgnoreCase(CLASSID_GRIDSERVER) || logicalServer.getUsingComponents() == null) continue;
            gridServer = (ServerComponent)logicalServer.getUsingComponents().get(0);
            break;
        }
        return gridServer;
    }

    public static OMRGridServer getOMRGridServer(ServerInterface server, ServerComponent sc) throws RemoteException, ServiceException {
        if (server != null) {
            String infoSvcsKey = sc.getId() + "/" + sc.getCMetadataType();
            return (OMRGridServer)server.fetch(infoSvcsKey, true);
        }
        return null;
    }
}

