/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ITEventSubscriber;
import com.sas.metadata.remote.ITSubscriber;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.impl.ITEventSubscriberImpl;
import com.sas.metadata.remote.impl.ITEventSubscriberImpl_Stub;
import com.sas.metadata.remote.impl.ITSubscriberImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.EventSubscriberFilter;
import com.sas.services.information.metadata.EventSubscriberInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.OMRSubscriber;
import com.sas.services.information.metadata.RB;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;

@SASScope
public class OMREventSubscriber
extends OMRSubscriber
implements EventSubscriberInterface {
    private static final long serialVersionUID = 2637769405451972945L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMREventSubscriber() throws RemoteException {
        super(OMREventSubscriber.class);
    }

    public OMREventSubscriber(ITEventSubscriber o) throws RemoteException {
        super((ITSubscriber)o, OMREventSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMREventSubscriber(ITEventSubscriberImpl o) throws RemoteException {
        super((ITSubscriberImpl)o, OMREventSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMREventSubscriber(ITEventSubscriberImpl_Stub o) throws RemoteException {
        super((ITSubscriber)o, OMREventSubscriber.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMREventSubscriber(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block21: {
            super(OMREventSubscriber.class);
            if (repos == null || name == null || parent == null) {
                throw new IllegalArgumentException();
            }
            ITEventSubscriber subscriber = null;
            ServiceException exception = null;
            boolean isOK = false;
            try {
                subscriber = (ITEventSubscriber)((OMIRepositoryInterface)repos).createMetadata(name, "ITEventSubscriber");
                subscriber.setPublicType("EventSubscriber");
                subscriber.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = subscriber;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                parent.addItem(this);
                isOK = true;
            }
            catch (ServiceException e) {
                exception = e;
                return exception;
            }
            finally {
                if (isOK) break block21;
                try {
                    if (subscriber != null) {
                        subscriber.delete();
                    }
                }
                catch (RemoteException remoteException) {
                    if (exception != null) {
                        throw new IllegalArgumentException((Throwable)((Object)exception));
                    }
                }
                finally {
                    if (exception == null) break block21;
                    throw new IllegalArgumentException((Throwable)((Object)exception));
                }
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "EventSubscriber";
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        this.checkPulse(true);
        super.refresh();
        if (this._repositoryObject instanceof ITEventSubscriber) {
            ITEventSubscriber subscriber = (ITEventSubscriber)this._repositoryObject;
            try {
                subscriber.getSubscriberEmails(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshEmail.ex.txt"));
            }
            try {
                subscriber.getProperties(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshProperties.ex.txt"));
            }
            try {
                subscriber.getContentDestinations(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshContentDestinations.ex.txt"));
            }
            try {
                subscriber.getProfileOwners(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshProfileOwners.ex.txt"));
            }
            try {
                subscriber.getTrees(true);
            }
            catch (MdException e) {
                throw new ServiceException(e, RB.getStringResource("OMRSubscriber.refreshTrees.ex.txt"));
            }
        }
    }

    @Override
    protected final ServerComponent getServerComponent(List servers) {
        ServerComponent httpServerComponent;
        block3: {
            this.checkPulse(true);
            httpServerComponent = null;
            try {
                if (servers == null || servers.size() <= 0) break block3;
                Object o2 = null;
                ServerComponent serverComponent = null;
                for (Object o2 : servers) {
                    if (!(o2 instanceof ServerComponent) || !Strings.equal((String)"DAC0D7F0-10DA-11D6-8816-AA0004006D06", (String)(serverComponent = (ServerComponent)o2).getClassIdentifier(), (boolean)false, (boolean)false)) continue;
                    httpServerComponent = serverComponent;
                    break;
                }
            }
            catch (RemoteException e) {
                httpServerComponent = null;
            }
        }
        return httpServerComponent;
    }

    @Override
    protected Filter createFilter() {
        return new EventSubscriberFilter();
    }
}

