/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.ColumnHierarchy;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.ColumnHierarchyImpl;
import com.sas.metadata.remote.impl.ColumnHierarchyImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.ColumnHierarchyInterface;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.RB;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRColumnHierarchy
extends Metadata
implements ColumnHierarchyInterface {
    private static final long serialVersionUID = 5832120810367765619L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRColumnHierarchy() throws RemoteException {
        super(OMRColumnHierarchy.class);
    }

    public OMRColumnHierarchy(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRColumnHierarchy(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRColumnHierarchy(ColumnHierarchy o) throws RemoteException {
        super(o, OMRColumnHierarchy.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRColumnHierarchy(ColumnHierarchyImpl o) throws RemoteException {
        super(o, OMRColumnHierarchy.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRColumnHierarchy(ColumnHierarchyImpl_Stub o) throws RemoteException {
        super(o, OMRColumnHierarchy.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRColumnHierarchy(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRColumnHierarchy.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                ColumnHierarchy columnHierarchy = (ColumnHierarchy)omirepository.createMetadata(name, "ColumnHierarchy");
                columnHierarchy.setPublicType("Embedded:ColumnHierarchy");
                columnHierarchy.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = columnHierarchy;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    columnHierarchy.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRColumnHeirarchy", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() {
        return "ColumnHierarchy";
    }

    @Override
    public List<ColumnInterface> getColumns() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<ColumnInterface> result = new ArrayList<ColumnInterface>();
        ColumnHierarchy fm = (ColumnHierarchy)this._repositoryObject;
        try {
            AssociationList list = fm.getFeatureTargets();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                if (!mi.getType().equals("Column")) continue;
                result.add((ColumnInterface)mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    @Override
    public void addColumn(ColumnInterface column) throws ServiceException, RemoteException {
        block8: {
            if (!this._isCompatible) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            this.checkPulse(true);
            ColumnHierarchy fm = (ColumnHierarchy)this._repositoryObject;
            try {
                Column c = (Column)column.getRepositoryEntity();
                DataTableInterface table = this.getTable();
                if (table != null && table.getReposId().substring(0, 8).equals(column.getTable().getReposId().substring(0, 8))) {
                    fm.getFeatureTargets().add((Object)c);
                    break block8;
                }
                if (table == null) {
                    if (this.getColumns().size() > 0) {
                        if (this.getColumns().get(0).getTable().getReposId().equals(column.getTable().getReposId())) {
                            fm.getFeatureTargets().add((Object)c);
                        }
                    } else {
                        fm.getFeatureTargets().add((Object)c);
                    }
                    break block8;
                }
                throw new ServiceException(RB.getStringResource("OMRColumnHierarchy.validateColumn.txt"));
            }
            catch (MdException mdex) {
                throw new ServiceException(mdex, mdex.getMessage());
            }
        }
    }

    @Override
    public void addColumnAt(ColumnInterface column, int index) throws ServiceException, RemoteException {
        block8: {
            if (!this._isCompatible) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            this.checkPulse(true);
            ColumnHierarchy fm = (ColumnHierarchy)this._repositoryObject;
            try {
                Column c = (Column)column.getRepositoryEntity();
                DataTableInterface table = this.getTable();
                if (table != null && table.getReposId().equals(column.getTable().getReposId())) {
                    fm.getFeatureTargets().add(index, (Object)c);
                    break block8;
                }
                if (table == null) {
                    if (this.getColumns().size() > 0) {
                        if (this.getColumns().get(0).getTable().getReposId().equals(column.getTable().getReposId())) {
                            fm.getFeatureTargets().add(index, (Object)c);
                        }
                    } else {
                        fm.getFeatureTargets().add(index, (Object)c);
                    }
                    break block8;
                }
                throw new ServiceException(RB.getStringResource("OMRColumnHierarchy.validateColumn.txt"));
            }
            catch (MdException mdex) {
                throw new ServiceException(mdex, mdex.getMessage());
            }
        }
    }

    @Override
    public void removeColumn(ColumnInterface column) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ColumnHierarchy fm = (ColumnHierarchy)this._repositoryObject;
        try {
            Column c = (Column)column.getRepositoryEntity();
            fm.getFeatureTargets().remove((Object)c);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeColumn(int pos) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ColumnHierarchy fm = (ColumnHierarchy)this._repositoryObject;
        try {
            fm.getFeatureTargets().remove(pos);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public boolean containsColumns() throws ServiceException, RemoteException {
        this.checkPulse(true);
        boolean result = false;
        StringBuilder sb = new StringBuilder();
        sb.append("<XMLSelect search=\"*[@Id='" + this.getReposId() + "']\"/>");
        Filter filter = new Filter();
        filter.setExplicitSearchString("omi", sb.toString());
        filter.setOMRTemplate("<Templates><ColumnHierarchy><FeatureTargets/></ColumnHierarchy></Templates>");
        filter.setType("ColumnHierarchy");
        int count = ((OMIRepositoryInterface)this._repository).getCountNoSecurity(filter, "FeatureTargets");
        if (count > 0) {
            result = true;
        }
        return result;
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        if (!this.containsColumns()) {
            super.delete();
        }
    }

    private DataTableInterface getTable() throws ServiceException, RemoteException {
        ColumnHierarchy fm = (ColumnHierarchy)this._repositoryObject;
        try {
            DataTable table = fm.getAssociatedDataTable();
            if (table != null) {
                return (DataTableInterface)this._repository.factoryProcess(table);
            }
            return null;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }
}

