/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.impl.AuthenticationDomainImpl;
import com.sas.metadata.remote.impl.AuthenticationDomainImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.AuthenticationDomainInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRAuthenticationDomain
extends Metadata
implements AuthenticationDomainInterface {
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRAuthenticationDomain() throws RemoteException {
    }

    public OMRAuthenticationDomain(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAuthenticationDomain(AuthenticationDomain o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAuthenticationDomain(AuthenticationDomainImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAuthenticationDomain(AuthenticationDomainImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAuthenticationDomain(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                AuthenticationDomain domain = (AuthenticationDomain)omirepository.createMetadata(name, "AuthenticationDomain");
                domain.setPublicType("AuthenticationDomain");
                domain.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = domain;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    domain.delete();
                    throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
                }
            }
            catch (ServiceException ex) {
                this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRAuthenticationDomain", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "AuthenticationDomain";
    }

    @Override
    public boolean isOutboundOnly() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AuthenticationDomain domain = (AuthenticationDomain)this._repositoryObject;
        return domain.getOutboundOnly() != 0;
    }

    @Override
    public void setOutboundOnly(boolean outbound) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        AuthenticationDomain domain = (AuthenticationDomain)this._repositoryObject;
        domain.setOutboundOnly(outbound ? 1 : 0);
    }

    @Override
    public boolean isTrustedOnly() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        AuthenticationDomain domain = (AuthenticationDomain)this._repositoryObject;
        return domain.getTrustedOnly() != 0;
    }

    @Override
    public void setTrustedOnly(boolean trusted) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        AuthenticationDomain domain = (AuthenticationDomain)this._repositoryObject;
        domain.setTrustedOnly(trusted ? 1 : 0);
    }
}

