/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.AccessControlEntryImpl;
import com.sas.metadata.remote.impl.AccessControlEntryImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.AccessControlEntryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.RB;
import com.sas.services.security.PermissionInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SASScope
public class OMRAccessControlEntry
extends Metadata
implements AccessControlEntryInterface {
    private static final long serialVersionUID = 7278026602828333961L;
    private boolean refreshIdentities = false;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRAccessControlEntry() throws RemoteException {
        super(OMRAccessControlEntry.class);
    }

    public OMRAccessControlEntry(AccessControlEntry o) throws RemoteException {
        super(o, OMRAccessControlEntry.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAccessControlEntry(AccessControlEntryImpl o) throws RemoteException {
        super(o, OMRAccessControlEntry.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAccessControlEntry(AccessControlEntryImpl_Stub o) throws RemoteException {
        super(o, OMRAccessControlEntry.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRAccessControlEntry(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRAccessControlEntry.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omiRepos = null;
        try {
            omiRepos = (OMIRepositoryInterface)repos;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(RB.getStringResource("Metadata.wrongrepos.ex.txt"));
        }
        AccessControlEntry ace = null;
        try {
            ace = (AccessControlEntry)omiRepos.createMetadata(name, "AccessControlEntry");
            ace.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
        }
        catch (ServiceException sex) {
            String message = sex.getMessage();
            throw new IllegalArgumentException(message);
        }
        this._repositoryObject = ace;
        this._repositoryFlag = 2;
        this.setRepository(repos);
        if (parent != null) {
            try {
                parent.addItem(this);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "AccessControlEntry";
    }

    @Override
    public List getIdentities() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = null;
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList ids = null;
            if (this.refreshIdentities) {
                ids = ace.getIdentities(true);
                this.refreshIdentities = false;
            } else {
                ids = ace.getIdentities();
            }
            result = new ArrayList<MetadataInterface>(ids.size());
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                MetadataInterface mi = this._repository.factoryProcess(it.next());
                result.add(mi);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public void addIdentity(IdentityInterface identity) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            String idFQID = identity.getReposId();
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList ids = ace.getIdentities();
            for (Root root : ids) {
                if (!root.getFQID().equals(idFQID)) continue;
                return;
            }
            ids.add(identity.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removeIdentity(IdentityInterface identity) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList ids = ace.getIdentities();
            ids.remove(identity.getRepositoryEntity());
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setIdentities(List identities) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList ids = ace.getIdentities();
            ids.clear();
            for (IdentityInterface nextId : identities) {
                Identity ident = (Identity)nextId.getRepositoryEntity();
                ids.add((Object)ident);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getPermissions() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<com.sas.services.security.Permission> result = null;
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList perms = ace.getPermissions();
            result = new ArrayList<com.sas.services.security.Permission>(perms.size());
            for (Permission cperm : perms) {
                com.sas.services.security.Permission perm = new com.sas.services.security.Permission(cperm.getType(), cperm.getName(), this);
                result.add(perm);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    @Override
    public void addPermission(PermissionInterface permission) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList perms = ace.getPermissions();
            for (Permission cperm : perms) {
                String type = cperm.getType();
                String action = cperm.getName();
                if (type == null || !type.equalsIgnoreCase(permission.getType()) || action == null || !action.equalsIgnoreCase(permission.getAction())) continue;
                return;
            }
            List permList = ((OMIRepositoryInterface)this._repository).getPermissions();
            if (permList != null && permList.size() > 0) {
                for (MetadataInterface mi : permList) {
                    Permission perm = (Permission)mi.getRepositoryEntity();
                    if (!perm.getName().equalsIgnoreCase(permission.getAction()) || !perm.getType().equalsIgnoreCase(permission.getType())) continue;
                    perms.add((Object)perm);
                }
            } else {
                Permission cperm = (Permission)((OMIRepositoryInterface)this._repository).createMetadata(permission.getAction(), "Permission");
                cperm.setType(permission.getType().toUpperCase());
                perms.add((Object)cperm);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void removePermission(PermissionInterface permission) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList perms = ace.getPermissions();
            for (Permission cperm : perms) {
                if (!cperm.getType().equalsIgnoreCase(permission.getType()) || !cperm.getName().equalsIgnoreCase(permission.getAction())) continue;
                perms.remove((Object)cperm);
                return;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void setPermissions(List permissions) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList perms = ace.getPermissions();
            perms.clear();
            for (com.sas.services.security.Permission permission : permissions) {
                this.addPermission(permission);
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            MdObjectStore store = (MdObjectStore)ace.getObjectStore();
            if (store == null || store.isDisposed()) {
                this._repository.browseFetch("AccessControlEntry+omi://host:port", null);
            }
            store.refreshObjectFromServer((CMetadata)ace, false, false);
            ace.getPermissions(true);
            this.refreshIdentities = true;
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    @Override
    public List getAccessControlTemplates() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        ArrayList<MetadataInterface> result = null;
        try {
            AccessControlEntry ace = (AccessControlEntry)this._repositoryObject;
            AssociationList templates = ace.getAccessControlTemplates();
            if (templates.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            result = new ArrayList<MetadataInterface>(templates.size());
            Iterator it = templates.iterator();
            while (it.hasNext()) {
                result.add(this._repository.factoryProcess(it.next()));
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }
}

