/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Timestamp;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.impl.TreeImpl;
import com.sas.metadata.remote.impl.TreeImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.ContentInfo;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.PartialListResultsException;
import com.sas.services.information.PartialResultsException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.TreeSearchFilter;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.DocumentInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.metadata.dav.DAVEntityInterface;
import com.sas.services.information.metadata.dav.DAVFolder;
import com.sas.services.information.metadata.dav.DAVFolderInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.util.TypeMapper;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.UpgradeInterface;
import com.sas.services.util.XMLUtil;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.UsageVersion;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Folder
extends Metadata
implements FolderInterface,
LocalizableProperties,
Serializable,
UpgradeInterface {
    @Deprecated
    public static final String REPOSITORY_CONTENT_MAPPING = "Report Repository Content Mapping";
    private static final String FOLDER_CONTEXT = "com.sas.services.information.metadata.Folder";
    public static final String CREATION_DATE = "Creation Date";
    public static final String MODIFIED_DATE = "Modified Date";
    private static final int SUBFOLDER_LIST_INIT = 8;
    private static final int ITEMLIST_INIT = 8;
    private static final int DAV_ID_INIT = 64;
    private static boolean contentUserFailedMessageFlag = false;
    private static final long serialVersionUID = -3969799882743011234L;
    static final long FOLDER_REFRESH_INTERVAL = -1L;
    static long folderRefreshInterval = -1L;
    static final long ITEM_REFRESH_INTERVAL = -1L;
    static long itemRefreshInterval = -1L;
    private long _itemRefreshTime;
    private long _subfolderRefreshTime;
    private long _myItemRefreshInterval;
    private long _myFolderRefreshInterval;
    private MetadataInterface _contentManagementObject;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final String DAV_CREDENTIALS_HELPER_CLASS_NAME = "com.sas.svcs.commons.webservice.omrclient.DAVCredentialsHelper";
    private static final String CREDENTIALS_SECURED_METHOD_NAME = "credentialsSecured";
    private static final String SERVICE_REGISTRY_HELPER_CLASS_NAME = "com.sas.svcs.commons.webservice.omrclient.ServiceRegistryHelper";
    private static final String GET_URL_METHOD_NAME = "getURL";
    private static final String OMRID_CLASS_NAME = "com.sas.report.repository.OMRID";
    private static final String SECURED_USER_AVAILABLE_METHOD_NAME = "securedUserAvailable";
    private static final String PING_DAV_SERVER_METHOD_NAME = "pingDAVServer";
    private static final String UTIL_SERVICE_PROXY_CLASS_NAME = "com.sas.svcs.reportrepository.proxy.UtilServiceInterfaceProxy";
    private static final String UTIL_REPORT_REPOS_CLASS_NAME = "com.sas.report.repository.UtilReportReposService";
    private static final String EXPIRE_STS_CLIENT_METHOD_NAME = "expireSTSClient";
    private final int MEMBER_OVERFLOW_LIMIT = 1000;

    public static void setFolderRefresh(long interval) {
        folderRefreshInterval = interval;
    }

    public static long getFolderRefresh() {
        return folderRefreshInterval;
    }

    public static void setItemRefresh(long interval) {
        itemRefreshInterval = interval;
    }

    public static long getItemRefresh() {
        return itemRefreshInterval;
    }

    public Folder() throws RemoteException {
        super(Folder.class);
        this._itemRefreshTime = 0L;
        this._subfolderRefreshTime = 0L;
        this._myItemRefreshInterval = itemRefreshInterval;
        this._myFolderRefreshInterval = folderRefreshInterval;
        this._contentManagementObject = null;
        this.MEMBER_OVERFLOW_LIMIT = 1000;
    }

    protected Folder(Class c) throws RemoteException {
        super(c);
        this._itemRefreshTime = 0L;
        this._subfolderRefreshTime = 0L;
        this._myItemRefreshInterval = itemRefreshInterval;
        this._myFolderRefreshInterval = folderRefreshInterval;
        this._contentManagementObject = null;
        this.MEMBER_OVERFLOW_LIMIT = 1000;
    }

    public Folder(Object o) throws RemoteException {
        this(o, Folder.class);
        if (o instanceof Tree) {
            this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        }
    }

    protected Folder(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
        this._itemRefreshTime = 0L;
        this._subfolderRefreshTime = 0L;
        this._myItemRefreshInterval = itemRefreshInterval;
        this._myFolderRefreshInterval = folderRefreshInterval;
        this._contentManagementObject = null;
        this.MEMBER_OVERFLOW_LIMIT = 1000;
        this._myFolderRefreshInterval = folderRefreshInterval;
        this._myItemRefreshInterval = itemRefreshInterval;
    }

    public Folder(Tree o) throws RemoteException {
        this(o, Folder.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Folder(TreeImpl o) throws RemoteException {
        this(o, Folder.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Folder(TreeImpl_Stub o) throws RemoteException {
        this(o, Folder.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Folder(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block13: {
            this._itemRefreshTime = 0L;
            this._subfolderRefreshTime = 0L;
            this._myItemRefreshInterval = itemRefreshInterval;
            this._myFolderRefreshInterval = folderRefreshInterval;
            this._contentManagementObject = null;
            this.MEMBER_OVERFLOW_LIMIT = 1000;
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            if (repos instanceof OMIRepositoryInterface) {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                Tree tree = null;
                try {
                    tree = (Tree)omirepository.createMetadata(name, "Tree");
                    String type = "Folder";
                    tree.setPublicType(type);
                    tree.setTreeType("BIP Folder");
                    this._repositoryObject = tree;
                    this._repositoryFlag = 2;
                    this.setRepository(repos);
                    tree.setUsageVersion(CURRENT_VERSION.encode());
                    this._isCompatible = true;
                    this._isReadCompatible = true;
                    if (parent == null) break block13;
                    String parentType = parent.getType();
                    if (parentType != null && !parentType.equalsIgnoreCase(type)) {
                        tree.setPublicType(parentType);
                    }
                    try {
                        parent.addSubfolder(this);
                    }
                    catch (ServiceException ex) {
                        tree.delete();
                        ex.printStackTrace(System.err);
                    }
                }
                catch (ServiceException ex) {
                    if (tree != null) {
                        tree.delete();
                    }
                    this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.OMRDocument", (Throwable)((Object)ex));
                }
            } else if (repos instanceof DAVRepositoryInterface) {
                if (parent == null) {
                    throw new IllegalArgumentException();
                }
                try {
                    DAVFolderInterface f = (DAVFolderInterface)parent.getRepositoryEntity();
                    DAVFolderInterface f2 = f.createFolder(name);
                    this._repositoryObject = f2;
                    this._repositoryFlag = 3;
                    this.setRepository(repos);
                }
                catch (ServiceException ex) {
                    throw new RemoteException("ServiceException", (Throwable)((Object)ex));
                }
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        String result = null;
        if (this._repositoryObject instanceof Tree) {
            result = ((Tree)this._repositoryObject).getPublicType();
        }
        if (result == null || result.trim().length() == 0) {
            result = "Folder";
        }
        return result;
    }

    @Override
    public String getPath() throws RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    return this.getPath(null);
                }
                catch (ServiceException svcex) {
                    return null;
                }
            }
            case 3: {
                try {
                    return this.getPath(null);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), FOLDER_CONTEXT, (Throwable)((Object)ex));
                }
            }
        }
        return null;
    }

    @Override
    public List getItems() throws ServiceException, RemoteException {
        this.checkPulse(true);
        return this.getItemsByType(null);
    }

    @Override
    public List getItemsByType(String metadataType) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getOMRItemsByType(metadataType);
            }
            case 3: {
                return this.getDAVItemsByType(metadataType);
            }
        }
        return null;
    }

    private List getDAVItemsByType(String metadataType) throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(8);
        if (!(this._repositoryObject instanceof DAVFolder)) {
            return results;
        }
        DAVFolderInterface f = (DAVFolderInterface)this._repositoryObject;
        Collection items = f.getEntities();
        Iterator _items = items.iterator();
        if (_items != null) {
            while (_items.hasNext()) {
                Object o = _items.next();
                MetadataInterface mi = this._repository.factoryProcess(o);
                if (mi != null && mi instanceof FolderInterface) continue;
                if (metadataType != null) {
                    if (!mi.getType().equalsIgnoreCase(metadataType)) continue;
                    results.add(mi);
                    continue;
                }
                results.add(mi);
            }
            return results;
        }
        return results;
    }

    private List getOMRItemsByType(String metadataType) throws ServiceException, RemoteException {
        PartialResultsException plre = null;
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(8);
        try {
            if (!(this._repositoryObject instanceof Tree)) {
                throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
            }
            Tree tree = (Tree)this._repositoryObject;
            AssociationList ass = null;
            if (System.currentTimeMillis() - this._itemRefreshTime > this._myItemRefreshInterval) {
                ass = tree.getMembers(true);
                this._itemRefreshTime = System.currentTimeMillis();
            } else {
                ass = tree.getMembers();
            }
            MetadataInterface mi = null;
            Iterator it = ass.iterator();
            while (it.hasNext()) {
                try {
                    Object o = it.next();
                    mi = this.hydrateMember((Root)o);
                    if (metadataType != null) {
                        if (!TypeMapper.isMapped(metadataType, mi.getType())) continue;
                        results.add(mi);
                        continue;
                    }
                    results.add(mi);
                }
                catch (ServiceException ex) {
                    if (plre == null) {
                        plre = new PartialListResultsException(results, ex.getMessage());
                    }
                    plre.addException((Throwable)((Object)ex));
                }
            }
            if (plre != null) {
                throw plre;
            }
            return results;
        }
        catch (MdException ex) {
            if (this.isConnectionException(ex)) {
                this._repository.getServer().reconnect();
                return this.getOMRItemsByType(metadataType);
            }
            throw new ServiceException(ex, RB.getStringResource("Folder.memberexcept.ex.txt"));
        }
    }

    private MetadataInterface hydrateMember(Root object) throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        mi = this._repository.factoryProcess(object);
        if (mi == null) {
            mi = new Metadata(object);
            mi.setRepository(this._repository);
        }
        return mi;
    }

    private List getMemberList() throws ServiceException, RemoteException {
        Tree tree = (Tree)this._repositoryObject;
        AssociationList members = null;
        try {
            if (System.currentTimeMillis() - this._itemRefreshTime > this._myItemRefreshInterval) {
                members = tree.getMembers(true);
                this._itemRefreshTime = System.currentTimeMillis();
            } else {
                members = tree.getMembers();
            }
        }
        catch (MdException mdex) {
            if (this.isConnectionException(mdex)) {
                this._repository.getServer().reconnect();
                return this.getMemberList();
            }
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return members;
    }

    @Override
    public List getItemsByClass(Class itemClass) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getOMRItemsByClass(itemClass);
            }
            case 3: {
                return this.getDAVItemsByClass(itemClass);
            }
        }
        return new ArrayList(8);
    }

    private List getOMRItemsByClass(Class itemClass) throws ServiceException, RemoteException {
        PartialResultsException plre = null;
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(8);
        if (!(this._repositoryObject instanceof Tree)) {
            throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
        }
        List memberList = this.getMemberList();
        Iterator it = memberList.iterator();
        while (it.hasNext()) {
            try {
                Object o = it.next();
                MetadataInterface mi = this.hydrateMember((Root)o);
                if (itemClass != null) {
                    if (!itemClass.isInstance(mi)) continue;
                    results.add(mi);
                    continue;
                }
                results.add(mi);
            }
            catch (ServiceException ex) {
                if (plre == null) {
                    plre = new PartialListResultsException(results, ex.getMessage());
                }
                plre.addException((Throwable)((Object)ex));
            }
        }
        if (plre != null) {
            throw plre;
        }
        return results;
    }

    private List getDAVItemsByClass(Class itemClass) throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(8);
        DAVFolderInterface f = (DAVFolderInterface)this._repositoryObject;
        Collection items = f.getEntities();
        Iterator _items = items.iterator();
        if (_items != null) {
            while (_items.hasNext()) {
                Object o = _items.next();
                MetadataInterface mi = this._repository.factoryProcess(o);
                if (mi != null && mi instanceof FolderInterface) continue;
                if (itemClass != null) {
                    if (!itemClass.isInstance(mi)) continue;
                    results.add(mi);
                    continue;
                }
                results.add(mi);
            }
        }
        return results;
    }

    @Override
    public MetadataInterface getItem(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        return this.getItemByType(name, null);
    }

    @Override
    public MetadataInterface getPublicTypeItem(String name, String type) throws ServiceException, RemoteException {
        List members;
        this.checkPulse(true);
        if (name == null || name.length() == 0) {
            return null;
        }
        if (type == null) {
            return null;
        }
        TypeDescriptorInterface tdi = this.getTypeDescriptor(type);
        if (tdi == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.notpublictype.ex.txt.fmt", (Object)type));
        }
        String folderId = this.getReposId();
        if (folderId == null || folderId.contains("$")) {
            return null;
        }
        String publicType = tdi.getTypeName();
        StringBuilder sb = new StringBuilder();
        sb.append("@Name='");
        sb.append(XMLUtil.normalize(name));
        sb.append("' and (@PublicType='");
        sb.append(publicType);
        if (publicType.indexOf(46) == -1) {
            sb.append("' or @PublicType =: '");
            sb.append(publicType);
        }
        sb.append("')");
        String template = "<Templates><Tree><Members search=\"" + sb.toString() + "\" /></Tree></Templates>";
        Filter filter = new Filter();
        filter.setType("Tree");
        filter.setOMRTemplate(template);
        BrowseMetadataInterface browseFolder = this._repository.browseFetch(this.getEntityKey(), filter);
        if (browseFolder != null && (members = browseFolder.getMembers()) != null && !members.isEmpty()) {
            BrowseMetadataInterface browseMember = (BrowseMetadataInterface)members.get(0);
            return this._repository.fetch(browseMember.getISEntityKey(), true);
        }
        return null;
    }

    @Override
    public MetadataInterface getItemByType(String name, String metadataType) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (name == null || name.length() == 0) {
            return null;
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getOMRItemByType(name, metadataType);
            }
            case 3: {
                return this.getDAVItemByType(name, metadataType);
            }
        }
        return null;
    }

    private TypeDescriptorInterface getTypeDescriptor(String type) throws ServiceException, RemoteException {
        List mappedTypes = TypeMapper.mapType(type);
        TypeDescriptorInterface result = this._repository.getServer().getTypeDescriptor(type);
        if (result == null) {
            for (String mappedType : mappedTypes) {
                result = this._repository.getServer().getTypeDescriptor(mappedType);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    private MetadataInterface getOMRItemByType(String name, String metadataType) throws ServiceException, RemoteException {
        MetadataInterface result = null;
        name = name.trim();
        String jomaType = null;
        int jomaFlags = 0;
        HashSet<String> typeSet = new HashSet<String>();
        TypeDescriptorInterface tdi = this.getTypeDescriptor(metadataType);
        if (tdi != null) {
            return this.getPublicTypeItem(name, metadataType);
        }
        Collection<TypeDescriptorInterface> tdis = this._repository.getServer().getTypeDescriptors();
        String prefix = metadataType + ".";
        for (TypeDescriptorInterface descriptor : tdis) {
            if (!descriptor.getTypeName().startsWith(prefix)) continue;
            typeSet.add(descriptor.getMetadataType());
        }
        if (typeSet.size() == 1) {
            jomaType = (String)typeSet.iterator().next();
        } else {
            jomaType = "Root";
            jomaFlags = 16;
        }
        Filter filter = new Filter("Name", 0, name);
        if (jomaFlags != 0) {
            filter.setOMRFlags(jomaFlags);
        }
        AssociationPathComponent treeComponent = new AssociationPathComponent("Trees", "Tree");
        treeComponent.setAttributeCriteria(new FilterComponent("Id", 0, ((Tree)this._repositoryObject).getFQID()));
        filter.getFilterComponent().addAssociationPathComponent(treeComponent);
        filter.setType(jomaType);
        List candidates = null;
        try {
            candidates = this._repository.search(filter);
        }
        catch (ServiceException ex) {
            if (ex instanceof PartialListResultsException) {
                candidates = ((PartialListResultsException)ex).getResults();
            }
            throw ex;
        }
        if (candidates != null && candidates.size() > 0) {
            for (MetadataInterface mi : candidates) {
                if (metadataType != null && !mi.getType().equals(metadataType)) continue;
                result = mi;
                break;
            }
        }
        return result;
    }

    private MetadataInterface getDAVItemByType(String name, String metadataType) throws ServiceException, RemoteException {
        DAVFolderInterface f = (DAVFolderInterface)this._repositoryObject;
        DAVEntityInterface item = f.getItem(name);
        if (item != null) {
            MetadataInterface mi = this._repository.factoryProcess(item);
            if (mi instanceof FolderInterface) {
                return null;
            }
            if (metadataType != null) {
                if (mi.getType().equalsIgnoreCase(metadataType)) {
                    return mi;
                }
            } else {
                return mi;
            }
        }
        return null;
    }

    @Override
    public MetadataInterface getItemByClass(String name, Class itemClass) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                return this.getOMRItemByClass(name, itemClass);
            }
            case 3: {
                return this.getDAVItemByClass(name, itemClass);
            }
        }
        return null;
    }

    private MetadataInterface getOMRItemByClass(String name, Class itemClass) throws ServiceException, RemoteException {
        MetadataInterface result = null;
        Filter filter = new Filter("Name", 0, name);
        AssociationPathComponent treeComponent = new AssociationPathComponent("Trees", "Tree");
        treeComponent.setAttributeCriteria(new FilterComponent("Id", 0, ((Tree)this._repositoryObject).getFQID()));
        filter.getFilterComponent().addAssociationPathComponent(treeComponent);
        filter.setType("Root");
        filter.setOMRFlags(16);
        List candidates = null;
        try {
            candidates = this._repository.search(filter);
        }
        catch (ServiceException ex) {
            if (ex instanceof PartialListResultsException) {
                candidates = ((PartialListResultsException)ex).getResults();
            }
            throw ex;
        }
        if (candidates != null && candidates.size() > 0) {
            for (MetadataInterface mi : candidates) {
                if (itemClass != null && !itemClass.isInstance(mi)) continue;
                result = mi;
            }
        }
        return result;
    }

    private MetadataInterface getDAVItemByClass(String name, Class itemClass) throws ServiceException, RemoteException {
        DAVFolderInterface f = (DAVFolderInterface)this._repositoryObject;
        DAVEntityInterface item = f.getItem(name);
        if (item != null) {
            MetadataInterface mi = this._repository.factoryProcess(item);
            if (mi instanceof FolderInterface) {
                return null;
            }
            if (itemClass.isInstance(mi)) {
                return mi;
            }
        }
        return null;
    }

    @Override
    public List getSubfolders() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(8);
                    if (!(this._repositoryObject instanceof Tree)) {
                        throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                    }
                    Tree tree = (Tree)this._repositoryObject;
                    AssociationList ass = null;
                    if (System.currentTimeMillis() - this._subfolderRefreshTime > this._myFolderRefreshInterval) {
                        ass = tree.getSubTrees(true);
                        this._subfolderRefreshTime = System.currentTimeMillis();
                    } else {
                        ass = tree.getSubTrees();
                    }
                    for (Object o : ass) {
                        MetadataInterface mi = this._repository.factoryProcess(o);
                        if (mi == null) {
                            mi = new Metadata(o);
                            mi.setRepository(this._repository);
                        }
                        results.add(mi);
                    }
                    if (FolderUtil.isSystemFolder(this)) {
                        VirtualFolderManager vfm = VirtualFolderManager.getInstance(this._repository.getServer());
                        results.addAll(vfm.getSystemVirtualFolders(this));
                    }
                    return results;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getSubfolders();
                    }
                    throw new ServiceException(ex, RB.getStringResource("Folder.memberexcept.ex.txt"));
                }
            }
            case 3: {
                DAVFolderInterface f = (DAVFolderInterface)this._repositoryObject;
                ArrayList<MetadataInterface> results = new ArrayList<MetadataInterface>(8);
                Collection items = f.getEntities();
                Iterator _items = items.iterator();
                if (_items == null) break;
                while (_items.hasNext()) {
                    Object o = _items.next();
                    MetadataInterface mi = this._repository.factoryProcess(o);
                    if (mi == null || !(mi instanceof FolderInterface)) continue;
                    results.add(mi);
                }
                return results;
            }
        }
        return null;
    }

    @Override
    public FolderInterface getSubfolder(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: 
            case 3: {
                List folders = this.getSubfolders();
                for (FolderInterface folder : folders) {
                    if (!folder.getName().equalsIgnoreCase(name)) continue;
                    return folder;
                }
                break;
            }
        }
        return null;
    }

    @Override
    public void addItem(MetadataInterface item) throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.addItem(item, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addItem(MetadataInterface item, int index) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                return;
            }
            case 2: {
                try {
                    if (!(this._repositoryObject instanceof Tree)) throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                    if ("Folder.SecuredData".equalsIgnoreCase(this.getType()) && !"SecuredLibrary".equalsIgnoreCase(item.getType())) {
                        throw new ServiceException(RB.getStringResource("Folder.secureddata.invalidmember.txt"));
                    }
                    RepositoryInterface hisRepos = item.getRepository();
                    if (!this._repository.equals(hisRepos)) {
                        throw new ServiceException(RB.getStringResource("Folder.nocrossrepos.ex.txt"));
                    }
                    Tree tree = (Tree)this._repositoryObject;
                    Root newItem = (Root)item.getRepositoryEntity();
                    if (newItem.getTrees().contains((Object)tree)) {
                        return;
                    }
                    if (this.hasDuplicate(item.getName(), item.getType())) {
                        throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.dupitem.ex.fmt.txt", (Object)item.getName(), (Object)item.getType()));
                    }
                    if (index < 0) {
                        this.addToList((List)newItem.getTrees(), tree);
                    } else {
                        ((Tree)this._repositoryObject).getMembers().add(index, (Object)tree);
                    }
                    this.setContentModifyDate(new Date());
                    return;
                }
                catch (MdException ex) {
                    if (!this.isConnectionException(ex)) throw new ServiceException(ex, RB.getStringResource("Folder.adderrror.ex.txt"));
                    this._repository.getServer().reconnect();
                    this.addItem(item);
                    return;
                }
            }
        }
    }

    @Override
    public MetadataInterface addNewItem(String name, String type) throws ServiceException, RemoteException {
        this.checkPulse(true);
        InformationServiceInterface is = Folder.getInformationService();
        HashMap types = is.getFactoryConfig();
        String url = this._repository.getUrl();
        String protocol = url.substring(0, url.indexOf(":"));
        String key = protocol + ':' + type;
        Object typeObject = types.get(key);
        String reposType = null;
        if (typeObject instanceof String) {
            reposType = (String)typeObject;
        }
        MetadataInterface mi = null;
        if (reposType == null) {
            reposType = type;
        }
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    if (!Names.validateOMRObjectName(name, true)) {
                        throw new ServiceException(RB.getStringResource("Folder.invalidName.ex.txt"));
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ServiceException(e.getMessage());
                }
                mi = is.newMetadataInFolder(this, this._repository, type, name);
                this.setContentModifyDate(new Date());
                break;
            }
            case 3: {
                DAVFolderInterface f = (DAVFolderInterface)this._repositoryObject;
                StringBuffer reposBuffer = new StringBuffer(64);
                String _reposId = f.getReposId();
                _reposId = _reposId.substring(0, _reposId.lastIndexOf(47));
                reposBuffer.append(_reposId);
                reposBuffer.append('/');
                reposBuffer.append(name);
                reposBuffer.append('/');
                reposBuffer.append(reposType);
                _reposId = reposBuffer.toString();
                mi = this._repository.newMetadata(_reposId, name, reposType);
                mi.add();
            }
        }
        return mi;
    }

    @Override
    public void removeItem(MetadataInterface item) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    if (this._repositoryObject instanceof Tree) {
                        Tree tree = (Tree)this._repositoryObject;
                        Root newItem = (Root)item.getRepositoryEntity();
                        if (!newItem.getTrees().remove((Object)tree)) {
                            throw new ServiceException(RB.getStringResource("Folder.noitem.ex.txt"));
                        }
                    } else {
                        throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                    }
                    this.setContentModifyDate(new Date());
                    break;
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeItem(item);
                        return;
                    }
                    throw new ServiceException(ex, RB.getStringResource("Folder.removeerror.ex.txt"));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteItem(MetadataInterface item) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                return;
            }
            case 2: {
                try {
                    if (!(this._repositoryObject instanceof Tree)) throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                    Tree tree = (Tree)this._repositoryObject;
                    Root root = (Root)item.getRepositoryEntity();
                    if (!root.getTrees().remove((Object)tree)) return;
                    item.delete();
                    this.setContentModifyDate(new Date());
                    return;
                }
                catch (MdException ex) {
                    if (!this.isConnectionException(ex)) throw new ServiceException(ex, RB.getStringResource("Folder.adderrror.ex.txt"));
                    this._repository.getServer().reconnect();
                    this.deleteItem(item);
                    return;
                }
            }
            case 3: {
                item.delete();
            }
        }
    }

    @Override
    public FolderInterface makeSubfolder(String name, String type) throws RemoteException, ServiceException {
        FolderInterface result;
        this.checkPulse(true);
        if (this._repositoryFlag == 2) {
            try {
                if (!Names.validateOMRObjectName(name, true)) {
                    throw new ServiceException(RB.getStringResource("Folder.invalidName.ex.txt"));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException(e.getMessage());
            }
        }
        if ((result = this.getSubfolder(name)) == null) {
            MetadataInterface mi;
            if (this._repositoryFlag == 2 && this.hasDuplicateSubfolder(name)) {
                throw new ServiceException(RB.getStringResource("Folder.dupsubfolder.ex.txt"));
            }
            InformationServiceInterface is = Folder.getInformationService();
            if (type == null) {
                type = "Folder";
            }
            if (!((mi = is.newMetadataInFolder(this, this._repository, type, name)) instanceof FolderInterface)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.notfoldertype.ex.fmt.txt", (Object)type));
            }
            result = (FolderInterface)mi;
            this.setContentModifyDate(new Date());
        }
        return result;
    }

    @Override
    public FolderInterface makeSubfolder(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        return this.makeSubfolder(name, this.getType());
    }

    @Override
    public void addSubfolder(FolderInterface folder) throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.addSubfolder(folder, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addSubfolder(FolderInterface folder, int index) throws ServiceException, RemoteException {
        if (folder == null) {
            return;
        }
        switch (this._repositoryFlag) {
            case 0: {
                return;
            }
            case 2: {
                try {
                    if (!(this._repositoryObject instanceof Tree)) throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                    if ("Folder.SecuredData".equalsIgnoreCase(this.getType()) && !"Folder.SecuredData".equalsIgnoreCase(folder.getType())) {
                        throw new ServiceException(RB.getStringResource("Folder.secureddata.invalidsubfolder.txt"));
                    }
                    RepositoryInterface hisRepos = folder.getRepository();
                    if (!this._repository.equals(hisRepos)) {
                        throw new ServiceException(RB.getStringResource("Folder.nocrosssubfolder.ex.txt"));
                    }
                    Tree tree = (Tree)this._repositoryObject;
                    Tree newMember = (Tree)folder.getRepositoryEntity();
                    if (this.hasDuplicateSubfolder(folder.getName())) {
                        throw new ServiceException(RB.getStringResource("Folder.dupsubfolder.ex.txt"));
                    }
                    if (index < 0) {
                        newMember.setParentTree(tree);
                    } else {
                        ((Tree)this._repositoryObject).getSubTrees().add(index, (Object)newMember);
                    }
                    this.setContentModifyDate(new Date());
                    return;
                }
                catch (MdException ex) {
                    if (!this.isConnectionException(ex)) throw new ServiceException(ex, RB.getStringResource("Folder.addsubfolder.ex.txt"));
                    this._repository.getServer().reconnect();
                    this.addSubfolder(folder);
                    return;
                }
            }
        }
    }

    @Override
    public void removeSubfolder(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    if (this._repositoryObject instanceof Tree) {
                        Tree tree = (Tree)this._repositoryObject;
                        ArrayList list = new ArrayList(tree.getSubTrees(true));
                        AssociationList ass = tree.getSubTrees();
                        for (Tree subtree : list) {
                            if (!subtree.getName().equalsIgnoreCase(name)) continue;
                            this.removeFromList((List)ass, subtree);
                            this.setContentModifyDate(new Date());
                            return;
                        }
                        break;
                    }
                    throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.removeSubfolder(name);
                        return;
                    }
                    throw new ServiceException(ex, RB.getStringResource("Folder.removesubfolder.ex.txt"));
                }
            }
        }
    }

    @Override
    public void deleteSubfolder(String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                FolderInterface subfolder = this.getSubfolder(name);
                if (subfolder == null) break;
                subfolder.delete();
                break;
            }
            case 3: {
                FolderInterface f2 = this.getSubfolder(name);
                if (f2 == null) break;
                f2.delete();
            }
        }
    }

    @Override
    public FolderInterface copyTo(FolderInterface folder, String name) throws ServiceException, RemoteException {
        if (folder != null && folder.hasDuplicateSubfolder(name)) {
            throw new ServiceException(RB.getStringResource("Folder.dupsubfolder.ex.txt"));
        }
        if (this._repositoryFlag == 2) {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this._repository;
            Tree cm = (Tree)this._repositoryObject;
            Tree dest = (Tree)omirepository.createMetadata(name, cm.getCMetadataType());
            FolderInterface newFolder = null;
            Map attrs = cm.getAttrs();
            try {
                attrs.put("Id", dest.getFQID());
                attrs.remove("Name");
                MdStoreUtil.setMetaObjectAttributes((CMetadata)cm, (CMetadata)dest, (Map)attrs, (int)1);
                newFolder = (FolderInterface)this._repository.factoryProcess(dest);
                List promptList = this.getPrompts();
                for (BaseOMRPromptInterface nextPrompt : promptList) {
                    BaseOMRPromptInterface nextNewPrompt = (BaseOMRPromptInterface)nextPrompt.copyTo(null, nextPrompt.getName());
                    newFolder.addPrompt(nextNewPrompt);
                }
                if (folder != null) {
                    dest.setParentTree((Tree)folder.getRepositoryEntity());
                } else {
                    Tree parentTree = cm.getParentTree();
                    if (parentTree != null) {
                        dest.setParentTree(parentTree);
                    }
                }
                FolderInterface folderInterface = newFolder;
                return folderInterface;
            }
            catch (MdException ex) {
                if (this.isConnectionException(ex)) {
                    this._repository.getServer().reconnect();
                    FolderInterface folderInterface = this.copyTo(folder, name);
                    return folderInterface;
                }
                throw new ServiceException(ex, ex.getMessage());
            }
            finally {
                if (attrs != null) {
                    MapPool.returnMap((Map)attrs);
                }
            }
        }
        return (FolderInterface)super.copyTo(folder, name);
    }

    @Override
    public void moveTo(FolderInterface folder) throws ServiceException, RemoteException {
        if (folder == null) {
            return;
        }
        if (this._repositoryFlag == 2) {
            boolean hasContent = false;
            try {
                hasContent = this.hasContentBacking();
            }
            catch (ServiceException ex) {
                hasContent = this.hasContentBackedItems();
            }
            if (hasContent) {
                Object o = this.newServiceObject();
                if (o != null) {
                    try {
                        String className = "com.sas.report.repository.EntryInterface";
                        ClassLoader cl = this.getClass().getClassLoader();
                        Class<?> entryClass = null;
                        try {
                            entryClass = cl.loadClass(className);
                        }
                        catch (NoClassDefFoundError ex) {
                            throw new ServiceException(RB.getStringResource("Folder.noreportclass.ex.txt"));
                        }
                        Method method = o.getClass().getMethod("moveTo", entryClass);
                        method.setAccessible(true);
                        method.invoke(o, folder.newServiceObject());
                    }
                    catch (IllegalArgumentException ex) {
                        String className = "com.sas.report.repository.RemoteDirectoryInterface";
                        ClassLoader cl = this.getClass().getClassLoader();
                        Class<?> entryClass = null;
                        try {
                            entryClass = cl.loadClass(className);
                        }
                        catch (ClassNotFoundException exe) {
                            throw new ServiceException(RB.getStringResource("Folder.noreportclass.ex.txt"));
                        }
                        catch (NoClassDefFoundError exe) {
                            throw new ServiceException(RB.getStringResource("Folder.noreportclass.ex.txt"));
                        }
                        try {
                            Method method = o.getClass().getMethod("moveTo", entryClass);
                            method.setAccessible(true);
                            method.invoke(o, folder.newServiceObject());
                        }
                        catch (InvocationTargetException exe) {
                            Throwable cause = exe.getCause();
                            throw new ServiceException(cause, cause.getMessage());
                        }
                        catch (Exception exe) {
                            throw new ServiceException(ex, ex.getMessage());
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause = ex.getCause();
                        throw new ServiceException(cause, cause.getMessage());
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (ClassNotFoundException ex) {
                        throw new ServiceException(ex, RB.getStringResource("Folder.noreportclass.ex.txt"));
                    }
                }
            } else {
                String otherReposId;
                if (folder.hasDuplicateSubfolder(this.getName())) {
                    throw new ServiceException(RB.getStringResource("Folder.dupsubfolder.ex.txt"));
                }
                Tree myTree = (Tree)this._repositoryObject;
                Object o = folder.getRepositoryEntity();
                String myReposId = myTree.getFQID().substring(0, 8);
                if (!myReposId.equals(otherReposId = ((Root)o).getFQID().substring(0, 8))) {
                    throw new ServiceException(RB.getStringResource("Folder.xreposmove.ex.txt"));
                }
                if (o instanceof Tree) {
                    Tree otherTree = (Tree)o;
                    try {
                        if (myTree.getParentTree() == null) {
                            myTree.getSoftwareComponents().clear();
                        }
                        myTree.setParentTree(otherTree);
                    }
                    catch (MdException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                } else if (o instanceof SoftwareComponent) {
                    SoftwareComponent serverRoot = (SoftwareComponent)o;
                    myTree.setParentTree(null);
                    try {
                        myTree.getSoftwareComponents().add((Object)serverRoot);
                    }
                    catch (MdException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                }
            }
        } else {
            super.moveTo(folder);
        }
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    if (this._repositoryObject instanceof Tree) {
                        Tree tree = (Tree)this._repositoryObject;
                        int count = this.countAssociatedObjects("SubTrees");
                        if (count > 0) {
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.dirhassubfolders.ex.fmt.txt", (Object)tree.getName()));
                        }
                        count = this.countAssociatedObjects("Members");
                        if (count > 0) {
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.dirhasitems.ex.fmt.txt", (Object)tree.getName()));
                        }
                        ArrayList tsList = new ArrayList(tree.getTimestamps());
                        for (Timestamp ts : tsList) {
                            ts.delete();
                        }
                        break;
                    }
                    throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.delete();
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        super.delete();
        this.expireMidTierSessionContext();
    }

    @Override
    public FolderInterface getParent() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    if (this._repositoryObject instanceof Tree) {
                        RootFolderInterface mainRoot = this._repository.getServer().getRootFolder();
                        String rootId = mainRoot.getReposId();
                        Tree tree = (Tree)this._repositoryObject;
                        Tree parent = tree.getParentTree();
                        if (parent != null) {
                            FolderInterface parentFolder = (FolderInterface)this._repository.factoryProcess(parent);
                            return parentFolder;
                        }
                        AssociationList swList = tree.getSoftwareComponents();
                        if (swList.size() > 0) {
                            SoftwareComponent root = null;
                            for (SoftwareComponent nextSC : swList) {
                                if (!rootId.equals(nextSC.getFQID())) continue;
                                root = nextSC;
                                break;
                            }
                            if (root != null) {
                                FolderInterface rootFolder = null;
                                rootFolder = (FolderInterface)this._repository.factoryProcess(root);
                                return rootFolder;
                            }
                        }
                        break;
                    }
                    throw new ServiceException(RB.getStringResource("Folder.onlyatree.ex.txt"));
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        return this.getParent();
                    }
                    throw new ServiceException(ex, RB.getStringResource("Folder.removesubfolder.ex.txt"));
                }
            }
            case 3: {
                MetadataInterface mi;
                String s = this.getReposId();
                s = s.substring(0, s.lastIndexOf("/"));
                if (s.length() <= 0) break;
                if (s.indexOf("/") == -1) {
                    s = "/" + s;
                }
                if (!((mi = this._repository.fetch(s)) instanceof FolderInterface)) break;
                return (FolderInterface)mi;
            }
        }
        return null;
    }

    @Override
    public boolean isItemNameUnique(MetadataInterface member) throws ServiceException, RemoteException {
        int cnt;
        if (member == null) {
            return true;
        }
        boolean result = true;
        String type = member.getType();
        String name = member.getName();
        int index = type.indexOf(46);
        if (index > -1) {
            type = type.substring(0, index);
        }
        List memList = this.getItems();
        Iterator it = memList.iterator();
        int testedObjects = 0;
        while (it.hasNext()) {
            MetadataInterface mi = (MetadataInterface)it.next();
            if (!mi.equals(member) && name.equalsIgnoreCase(mi.getName()) && TypeMapper.isMapped(type, mi.getType())) {
                result = false;
                break;
            }
            ++testedObjects;
        }
        if (!result && this._repositoryFlag == 2 && testedObjects < (cnt = this.countAssociatedObjects("Members"))) {
            List typeList = TypeMapper.mapType(type);
            String selectName = XMLUtil.normalize(name);
            StringBuffer selectBuffer = new StringBuffer();
            selectBuffer.append("<XMLSelect search=\"*[@Name='" + selectName + "' and ");
            if (typeList.size() > 1) {
                selectBuffer.append("( ");
                Iterator typeIt = typeList.iterator();
                while (typeIt.hasNext()) {
                    String nextType = (String)typeIt.next();
                    selectBuffer.append("@PublicType=:'" + nextType + "'");
                    if (!typeIt.hasNext()) continue;
                    selectBuffer.append(" or ");
                }
                selectBuffer.append(" ) ");
            } else {
                selectBuffer.append("@PublicType=:'" + (String)typeList.get(0) + "'");
            }
            selectBuffer.append("][Trees/Tree[@Id='" + this.getReposId() + "']]\" />");
            String selectString = selectBuffer.toString();
            Filter filter = new Filter();
            filter.setExplicitSearchString("omi", selectString);
            MetadataServerInterface server = (MetadataServerInterface)this._repository.getServer();
            ArrayList<String> defList = new ArrayList<String>();
            Map typeMap = server.getTypeDictionaryMap();
            for (String nextKey : typeMap.keySet()) {
                TypeDescriptorInterface tdi;
                if (!nextKey.startsWith(type) || defList.contains((tdi = (TypeDescriptorInterface)typeMap.get(nextKey)).getMetadataType())) continue;
                defList.add(tdi.getMetadataType());
            }
            for (String metaType : defList) {
                filter.setType(metaType);
                int count = server.getCountNoSecurity(filter, null);
                if (count <= 1) continue;
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean hasDuplicate(String name, String type) throws ServiceException, RemoteException {
        int cnt;
        if (name == null || type == null) {
            return false;
        }
        if (FolderUtil.isFolder(type)) {
            return this.hasDuplicateSubfolder(name);
        }
        boolean result = false;
        int index = type.indexOf(46);
        if (index > -1) {
            type = type.substring(0, index);
        }
        List memList = this.getItems();
        Iterator it = memList.iterator();
        int testedObjects = 0;
        while (it.hasNext()) {
            MetadataInterface mi = (MetadataInterface)it.next();
            if (name.equalsIgnoreCase(mi.getName()) && TypeMapper.isMapped(type, mi.getType())) {
                result = true;
                break;
            }
            ++testedObjects;
        }
        if (!result && this._repositoryFlag == 2 && testedObjects < (cnt = this.countAssociatedObjects("Members"))) {
            List typeList = TypeMapper.mapType(type);
            String selectName = XMLUtil.normalize(name);
            StringBuffer selectBuffer = new StringBuffer();
            selectBuffer.append("<XMLSelect search=\"*[@Name='" + selectName + "' and ");
            if (typeList.size() > 1) {
                selectBuffer.append("( ");
                Iterator typeIt = typeList.iterator();
                while (typeIt.hasNext()) {
                    String nextType = (String)typeIt.next();
                    selectBuffer.append("@PublicType=:'" + nextType + "'");
                    if (!typeIt.hasNext()) continue;
                    selectBuffer.append(" or ");
                }
                selectBuffer.append(" ) ");
            } else {
                selectBuffer.append("@PublicType=:'" + (String)typeList.get(0) + "'");
            }
            selectBuffer.append("][Trees/Tree[@Id='" + this.getReposId() + "']]\" />");
            String selectString = selectBuffer.toString();
            Filter filter = new Filter();
            filter.setExplicitSearchString("omi", selectString);
            MetadataServerInterface server = (MetadataServerInterface)this._repository.getServer();
            ArrayList<String> defList = new ArrayList<String>();
            Map typeMap = server.getTypeDictionaryMap();
            for (String nextKey : typeMap.keySet()) {
                TypeDescriptorInterface tdi;
                if (!nextKey.startsWith(type) || defList.contains((tdi = (TypeDescriptorInterface)typeMap.get(nextKey)).getMetadataType())) continue;
                defList.add(tdi.getMetadataType());
            }
            for (String metaType : defList) {
                filter.setType(metaType);
                int count = ((OMIRepositoryInterface)this._repository).getCountNoSecurity(filter, null);
                if (count <= 0) continue;
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean hasDuplicateSubfolder(String name) throws ServiceException, RemoteException {
        return this.hasDuplicateSubfolder(name, null);
    }

    public boolean hasDuplicateSubfolder(String name, FolderInterface subFolderToExclude) throws ServiceException, RemoteException {
        VirtualFolderManager vfm;
        if (this._repositoryFlag != 2) {
            return false;
        }
        String selectName = XMLUtil.normalize(name);
        StringBuffer selectBuffer = new StringBuffer();
        selectBuffer.append("<XMLSelect search=\"*[@Name='" + selectName);
        if (subFolderToExclude != null) {
            selectBuffer.append("' and @Id NE '");
            selectBuffer.append(subFolderToExclude.getReposId());
        }
        selectBuffer.append("'][ParentTree/Tree[@Id='" + this.getReposId() + "']]\" />");
        String selectString = selectBuffer.toString();
        Filter filter = new Filter();
        filter.setType("Tree");
        filter.setExplicitSearchString("omi", selectString);
        int count = ((OMIRepositoryInterface)this._repository).getCountNoSecurity(filter, null);
        if (count > 0) {
            return true;
        }
        return FolderUtil.isSystemFolder(this) && (vfm = VirtualFolderManager.getInstance(this._repository.getServer())).hasDuplicateSubfolder(name, this);
    }

    @Override
    public boolean isEmpty() throws ServiceException, RemoteException {
        if (this._repositoryFlag == 2) {
            if (this.getSubfolders().size() > 0) {
                return false;
            }
            if (this.countAssociatedObjects("Members") > 0) {
                return false;
            }
        } else if (this._repositoryFlag == 3) {
            if (this.getSubfolders().size() > 0) {
                return false;
            }
            if (this.getItems().size() > 0) {
                return false;
            }
        } else {
            throw new UnsupportedOperationException("FolderInterface.isEmpty() is not supported for this folder object.");
        }
        return true;
    }

    @Override
    public void setRepository(RepositoryInterface ri) throws RemoteException {
        this.checkPulse(true);
        super.setRepository(ri);
        if (this._repositoryFlag == 2) {
            AssociationList members;
            Tree tree;
            Map map;
            AssociationList trees;
            OMIRepositoryInterface ori = (OMIRepositoryInterface)ri;
            long reposRefresh = ori.getFolderItemRefreshInterval();
            if (reposRefresh > -1L) {
                this._myItemRefreshInterval = reposRefresh;
            }
            if ((reposRefresh = ori.getFolderSubfolderRefreshInterval()) > -1L) {
                this._myFolderRefreshInterval = reposRefresh;
            }
            if ((trees = (AssociationList)(map = (tree = (Tree)this._repositoryObject).getAssocs()).get("SubTrees")) != null && trees.size() > 0 && (trees.getState() & 0x20) != 1) {
                this._subfolderRefreshTime = System.currentTimeMillis();
            }
            if ((members = (AssociationList)map.get("Members")) != null && members.size() > 0 && (members.getState() & 0x20) != 1) {
                this._itemRefreshTime = System.currentTimeMillis();
            }
            MapPool.returnMap((Map)map);
        }
    }

    @Override
    public void setFolderType(String type) throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Tree tree = (Tree)this._repositoryObject;
                tree.setTreeType(type);
                return;
            }
        }
    }

    @Override
    public String getFolderType() throws ServiceException, RemoteException {
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Tree tree = (Tree)this._repositoryObject;
                String treeType = tree.getTreeType();
                if (treeType == null) {
                    treeType = "";
                }
                return treeType;
            }
        }
        return "";
    }

    @Override
    public void setName(String name) throws RemoteException {
        block20: {
            this.checkPulse(true);
            String myName = this.getName();
            if (myName != null && myName.equals(name)) {
                return;
            }
            if (this._repositoryFlag == 2) {
                if (!Names.validateOMRObjectName(name, true)) {
                    throw new IllegalArgumentException(RB.getStringResource("Folder.invalidName.ex.txt"));
                }
                if (!name.equalsIgnoreCase(this.getName())) {
                    try {
                        FolderInterface parent = this.getParent();
                        if (parent.hasDuplicateSubfolder(name)) {
                            throw new IllegalArgumentException(RB.getStringResource("Folder.dupsubfolder.ex.txt"));
                        }
                    }
                    catch (ServiceException ex) {
                        throw new IllegalArgumentException(ex.getMessage(), (Throwable)((Object)ex));
                    }
                }
                try {
                    int cnt = this.countAssociatedObjects("Members") + this.countAssociatedObjects("SubTrees");
                    if (cnt <= 0) break block20;
                    try {
                        boolean hasContent = false;
                        try {
                            hasContent = this.hasContentBacking();
                        }
                        catch (ServiceException ex) {
                            hasContent = this.hasContentBackedItems();
                        }
                        if (!hasContent) {
                            super.setName(name);
                            return;
                        }
                        Object o = this.newServiceObject();
                        if (o == null) break block20;
                        try {
                            Class[] parms = new Class[]{String.class};
                            Object[] args = new Object[]{name};
                            Method method = o.getClass().getMethod("renameTo", parms);
                            method.setAccessible(true);
                            method.invoke(o, args);
                            Tree tree = (Tree)this._repositoryObject;
                            if (!tree.getName().equals(name)) {
                                MdObjectStore store = (MdObjectStore)tree.getObjectStore();
                                MdFactory factory = store.getFactory();
                                store.refreshObjectFromServer((CMetadata)tree, false, true, true);
                                HashMap<String, String> objectMap = new HashMap<String, String>();
                                objectMap.put(tree.getFQID(), tree.getCMetadataType());
                                factory.fireMdObjectsModified(new MdFactoryEvent(factory, objectMap));
                            }
                            return;
                        }
                        catch (NoSuchMethodException ex) {
                            ChainedException.printStackTrace((Throwable)ex, (PrintStream)System.err, (boolean)true);
                        }
                        catch (InvocationTargetException ex) {
                            ChainedException.printStackTrace((Throwable)ex, (PrintStream)System.err, (boolean)true);
                        }
                        catch (IllegalAccessException ex) {
                            ChainedException.printStackTrace((Throwable)ex, (PrintStream)System.err, (boolean)true);
                        }
                        catch (Throwable t) {
                            ChainedException.printStackTrace((Throwable)t, (PrintStream)System.err, (boolean)true);
                        }
                    }
                    catch (Exception ex) {
                        ChainedException.printStackTrace((Throwable)ex, (PrintStream)System.err, (boolean)true);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
        }
        super.setName(name);
    }

    @Override
    public String mapNameToFilesystem(int hostOS, String prefix, String suffix) throws RemoteException, IllegalArgumentException {
        this.checkPulse(true);
        return Names.mapNameToFilesystem(this.getName(), hostOS, prefix, suffix);
    }

    @Override
    public String mapUrlToFilesystem(int hostOS, String prefix, String suffix) throws ServiceException, RemoteException, IllegalArgumentException {
        this.checkPulse(true);
        return Names.mapUrlToFilesystem(this.getPathUrl().toString(), hostOS, prefix, suffix);
    }

    @Override
    public List getItemSublist(int start, int end) throws RemoteException, ServiceException {
        this.checkPulse(true);
        return this.getItemSublist(start, end, null);
    }

    @Override
    public List getItemSublist(int start, int end, String sort) throws RemoteException, ServiceException {
        this.checkPulse(true);
        ArrayList list = new ArrayList();
        List all = this.getItems();
        all.addAll(this.getSubfolders());
        if (sort != null) {
            Comparator comparator = this.getComparator(sort);
            Collections.sort(all, comparator);
        }
        if (start < 0) {
            start = 0;
        }
        if (end >= all.size()) {
            end = all.size() - 1;
        }
        for (int i = start; i <= end; ++i) {
            list.add(all.get(i));
        }
        return list;
    }

    private Comparator getComparator(String sort) {
        if ("desc".equals(sort)) {
            return new DescriptionComparator();
        }
        if ("descdescending".equals(sort)) {
            return new DescriptionDescendingComparator();
        }
        if ("date".equals(sort)) {
            return new DateComparator();
        }
        if ("datedescending".equals(sort)) {
            return new DateDescendingComparator();
        }
        if ("type".equals(sort)) {
            return new TypeComparator();
        }
        if ("typedescending".equals(sort)) {
            return new TypeDescendingComparator();
        }
        if ("name".equals(sort)) {
            return new NameComparator();
        }
        if ("namedescending".equals(sort)) {
            return new NameDescendingComparator();
        }
        return new NameComparator();
    }

    @Override
    public int getTotalNumberOfItems() throws RemoteException, ServiceException {
        return this.getItems().size() + this.getSubfolders().size();
    }

    private String getType(MetadataInterface mi) throws RemoteException {
        if (mi instanceof DocumentInterface) {
            DocumentInterface doc = (DocumentInterface)mi;
            String type = null;
            try {
                type = doc.getDocumentType();
            }
            catch (ServiceException ex) {
                type = "";
            }
            return type;
        }
        if ("Transformation".equals(mi.getType())) {
            return "ROMReport";
        }
        if ("BriefInformationMap".equals(mi.getType()) || "Cube".equals(mi.getType())) {
            return "InformationMap";
        }
        return mi.getType();
    }

    @Override
    public List getChildren() throws ServiceException, RemoteException {
        this.checkPulse(true);
        List results = this.getSubfolders();
        results.addAll(this.getItems());
        return results;
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        this.checkPulse(true);
        List children = this.getChildren();
        if (children == null || children.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("The folder has no children");
        }
        return (PublicObjectInterface)children.get(index);
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        this.checkPulse(true);
        List children = this.getChildren();
        return children.size();
    }

    @Override
    public void insertChild(PublicObjectInterface child, int index) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (child instanceof FolderInterface) {
            this.addSubfolder((FolderInterface)child, index);
        } else {
            this.addItem((MetadataInterface)child, index);
        }
    }

    @Override
    public void addChild(PublicObjectInterface newChild) throws ServiceException, RemoteException {
        if (newChild instanceof FolderInterface) {
            this.addSubfolder((FolderInterface)newChild);
        } else {
            this.addItem((MetadataInterface)newChild);
        }
    }

    @Override
    public void removeChild(PublicObjectInterface child) throws ServiceException, RemoteException {
        if (child instanceof FolderInterface) {
            this.removeSubfolder(child.getName());
        } else {
            this.removeItem((MetadataInterface)child);
        }
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        return this.addNewItem(type, name);
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        super.refresh();
        this.checkPulse(true);
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                Tree tree = (Tree)this._repositoryObject;
                try {
                    tree.getSubTrees(true);
                }
                catch (MdException ex) {
                    if (this.isConnectionException(ex)) {
                        this._repository.getServer().reconnect();
                        this.refresh();
                        return;
                    }
                    throw new ServiceException(ex, ex.getMessage());
                }
                return;
            }
        }
    }

    @Override
    public ContentInfo getContentInfo() throws IllegalStateException, ServiceException, RemoteException {
        if (this._repositoryFlag != 2) {
            return null;
        }
        PathUrl sbipUrl = this.getPathUrl();
        String absPath = sbipUrl.getAbsolutePath();
        if (absPath.endsWith(")")) {
            int index = absPath.lastIndexOf(40);
            absPath = absPath.substring(0, index);
        }
        PathUrl sbipRoot = (PathUrl)sbipUrl.clone();
        sbipRoot.setPath(null);
        sbipRoot.setName(null);
        sbipRoot.setType(null);
        ContentInfo contentInfo = null;
        try {
            String pw;
            String userId;
            TextStore ts;
            Document doc = null;
            try {
                doc = this.getContentInfoDoc();
            }
            catch (IllegalStateException ex) {
                doc = null;
            }
            if (doc == null) {
                return null;
            }
            String uri = doc.getURI();
            if (uri == null || uri.length() == 0) {
                return null;
            }
            if ((uri = uri.trim()).charAt(uri.length() - 1) == '/') {
                uri = uri.substring(0, uri.length() - 1);
            }
            if (REPOSITORY_CONTENT_MAPPING.equals(doc.getName())) {
                uri = uri + "/" + sbipUrl.getRootTree();
                int index = absPath.indexOf(47, 1);
                absPath = index > -1 ? absPath.substring(index) : "";
            }
            if ((ts = this.getAuthenticationTextStore(doc)) != null) {
                String storedTextEncoded = ts.getStoredText();
                String storedText = null;
                boolean sasPasswordEncoding = storedTextEncoded.startsWith("{sas");
                try {
                    if (sasPasswordEncoding) {
                        storedText = SasPasswordString.decode((String)storedTextEncoded);
                    } else {
                        MdObjectStore store = (MdObjectStore)ts.getObjectStore();
                        MdFactory factory = store.getFactory();
                        storedText = factory.getUtil().decrypt(storedTextEncoded);
                    }
                }
                catch (SasPasswordEncodingException e) {
                    throw new ServiceException(e, e.getMessage());
                }
                int delimiterPos = storedText.indexOf(10);
                if (delimiterPos > 0 && delimiterPos < storedText.length() - 1) {
                    userId = storedText.substring(0, delimiterPos);
                    pw = storedText.substring(delimiterPos + 1);
                } else {
                    userId = storedText;
                    pw = "";
                }
            } else {
                userId = "";
                pw = "";
                if (!contentUserFailedMessageFlag) {
                    this.logFormat(Level.INFO, FOLDER_CONTEXT, RB.getResources(), "Folder.retrieveContentUserFailed.fmt.txt", sbipRoot.toString());
                    contentUserFailedMessageFlag = true;
                }
            }
            contentInfo = new ContentInfo(uri, absPath, userId, pw);
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getMessage());
        }
        return contentInfo;
    }

    private Document getContentInfoDoc() throws IllegalArgumentException, ServiceException, RemoteException {
        PathUrl myPath = this.getPathUrl();
        if (myPath == null) {
            return null;
        }
        String rootFolderName = myPath.getRootTree();
        ServerInterface server = this._repository.getServer();
        RootFolderInterface serverRoot = server.getRootFolder();
        try {
            FolderInterface rootFolder = serverRoot.getSubfolder(rootFolderName);
            Tree rootFolderMdObj = null;
            if (rootFolder != null) {
                rootFolderMdObj = (Tree)rootFolder.getRepositoryEntity();
            }
            if (rootFolderMdObj == null) {
                throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"Folder.noMatchForRoot.ex.fmt.txt", (Object)myPath.toString()));
            }
            AssociationList rootDocList = rootFolderMdObj.getDocuments();
            Document contentInfoDoc = this.getContentInfoDocFromList((List)rootDocList, rootFolderName);
            if (contentInfoDoc != null) {
                return contentInfoDoc;
            }
            SoftwareComponent sc = (SoftwareComponent)serverRoot.getRepositoryEntity();
            AssociationList scDocList = sc.getDocuments();
            contentInfoDoc = this.getContentInfoDocFromList((List)scDocList, rootFolderName);
            if (contentInfoDoc == null && (contentInfoDoc = this.getContentInfoDocFromList((List)scDocList, REPOSITORY_CONTENT_MAPPING)) == null) {
                return null;
            }
            return contentInfoDoc;
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (ServiceException e) {
            throw new ServiceException((Throwable)((Object)e), e.getMessage());
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    private Document getContentInfoDocFromList(List list, String docName) throws RemoteException {
        Document contentInfoDoc = null;
        Iterator docItor = list.iterator();
        while (contentInfoDoc == null && docItor.hasNext()) {
            Document doc = (Document)docItor.next();
            if (!doc.getName().equals(docName)) continue;
            contentInfoDoc = doc;
        }
        return contentInfoDoc;
    }

    private TextStore getAuthenticationTextStore(Document doc) throws ServiceException {
        try {
            String nameToMatch = doc.getName();
            AssociationList noteList = doc.getNotes();
            for (TextStore textStore : noteList) {
                String tsName = textStore.getName();
                if (!nameToMatch.equals(tsName)) continue;
                return textStore;
            }
            return null;
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public Date getContentCreateDate() throws ServiceException, RemoteException {
        Date retVal = null;
        Timestamp ts = this.getTimestamp(CREATION_DATE);
        if (ts != null) {
            retVal = new Date((long)ts.getDateandTime());
        }
        return retVal;
    }

    @Override
    public void setContentCreateDate(Date date) throws ServiceException, RemoteException {
        if (!(this._repositoryObject instanceof Tree)) {
            return;
        }
    }

    @Override
    public Date getContentModifyDate() throws ServiceException, RemoteException {
        Date retVal = null;
        Timestamp ts = this.getTimestamp(MODIFIED_DATE);
        if (ts != null) {
            retVal = new Date((long)ts.getDateandTime());
        }
        return retVal;
    }

    @Override
    public void setContentModifyDate(Date date) throws ServiceException, RemoteException {
        if (!(this._repositoryObject instanceof Tree)) {
            return;
        }
    }

    private Timestamp getTimestamp(String timestampRole) throws ServiceException, RemoteException {
        Tree tree = (Tree)this._repositoryObject;
        try {
            AssociationList vTimestampObjects = tree.getTimestamps();
            for (Timestamp timestamp : vTimestampObjects) {
                String timestampName = timestamp.getTimestampRole();
                if (timestampRole.compareTo(timestampName) != 0) continue;
                return timestamp;
            }
        }
        catch (MdException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return null;
    }

    @Override
    public Object newServiceObject() throws ServiceException, RemoteException {
        ContentInfo ci = this.getContentInfo();
        if (ci == null) {
            return null;
        }
        if (this._contentManagementObject == null) {
            try {
                String className = "com.sas.report.repository.OMRReportDirectory";
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> newClass = null;
                try {
                    newClass = cl.loadClass(className);
                }
                catch (NoClassDefFoundError ex) {
                    throw new ServiceException(RB.getStringResource("Folder.noreportclass.ex.txt"));
                }
                Class[] ctorArgs = new Class[]{this._repositoryObject.getClass()};
                Object[] ctorParms = new Object[]{this._repositoryObject};
                Constructor<?> ctor = null;
                try {
                    ctor = newClass.getConstructor(ctorArgs);
                }
                catch (NoSuchMethodException nsme) {
                    ctorArgs[0] = Object.class;
                    ctor = newClass.getConstructor(ctorArgs);
                }
                Object obj = ctor.newInstance(ctorParms);
                this._contentManagementObject = (MetadataInterface)obj;
                this._contentManagementObject.setRepository(this._repository);
            }
            catch (NoClassDefFoundError ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (ClassNotFoundException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (NoSuchMethodException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (InstantiationException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                throw new ServiceException(ex, ex.getMessage());
            }
        }
        try {
            return this._contentManagementObject.newServiceObject();
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }

    @Override
    public boolean moveMembersOnOverflow() throws ServiceException, RemoteException {
        if (this.getMemberList().size() > 1000) {
            int i = 1;
            String subfolderName = "1";
            while (this.hasDuplicateSubfolder(subfolderName) && i < 1000) {
                subfolderName = Integer.toString(++i);
            }
            String msg = Message.format((String)RB.getStringResource("Folder.FolderOverflow.fmt.txt"), (Object)this.getPathUrl().getDisplayPath(), (Object)subfolderName);
            this.logMessage(Level.WARN, msg);
            FolderInterface subfolder = this.makeSubfolder(subfolderName);
            for (MetadataInterface member : this.getItems()) {
                member.moveTo(subfolder);
            }
            this.update();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasContentBacking() throws RemoteException, ServiceException {
        boolean result = false;
        if (this._repositoryFlag != 2) {
            return false;
        }
        ContentInfo ci = this.getContentInfo();
        if (ci == null) return result;
        if (this.davCredentialsSecured()) return this.pingDAVServer();
        String url = ci.getRoot();
        String path = ci.getPath();
        String userid = ci.getUserId();
        String passwd = ci.getPassword();
        ConnectionInfo cxn = new ConnectionInfo(url + (path != null ? path : ""), userid, passwd);
        try {
            DAVResource dr = new DAVResource(cxn);
            int status = dr.getStatusCode();
            dr.close();
            if ((status /= 100) != 2) return result;
            return true;
        }
        catch (DAVException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
    }

    public boolean hasContentBackedItems() throws ServiceException, RemoteException {
        if (this._repositoryFlag != 2) {
            return false;
        }
        HashMap filterMap = new HashMap();
        ArrayList<String> reportList = new ArrayList<String>();
        reportList.add("Report");
        filterMap.put("Transformation", reportList);
        Filter reportFilter = new Filter("PublicType", 2, "Report");
        reportFilter.addProtocol("omi");
        reportFilter.setType("Transformation");
        int memCnt = this.countAssociatedObjects("Members");
        int assnCnt = this.countAssociatedObjects("SubTrees");
        if (memCnt + assnCnt == 0) {
            return false;
        }
        Map typeMap = ((MetadataServerInterface)this._repository.getServer()).getTypeDictionaryMap();
        for (TypeDescriptorInterface tdi : typeMap.values()) {
            if (!tdi.hasContentBacking()) continue;
            String string = tdi.getMetadataType();
            String publicType = tdi.getTypeName();
            ArrayList<String> typeList = (ArrayList<String>)filterMap.get(string);
            if (typeList == null) {
                typeList = new ArrayList<String>();
                typeList.add(publicType);
                filterMap.put(string, typeList);
                continue;
            }
            if (typeList.contains(publicType)) continue;
            typeList.add(publicType);
        }
        String[] treeList = this.getAllSubfolders();
        for (Map.Entry entry : filterMap.entrySet()) {
            String rootType = (String)entry.getKey();
            List publicTypeList = (List)entry.getValue();
            reportFilter = new Filter();
            reportFilter.addProtocol("omi");
            reportFilter.setType(rootType);
            FilterComponent component = new FilterComponent();
            component.setAggregation(1);
            reportFilter.setFilterComponent(component);
            for (String nextPublicType : publicTypeList) {
                component.addComponent(new FilterComponent("PublicType", 2, nextPublicType));
            }
            TreeSearchFilter tsf = new TreeSearchFilter((FilterInterface)reportFilter, treeList);
            int count = ((MetadataServerInterface)this._repository.getServer()).getCountNoSecurity(tsf, null);
            if (count <= 0) continue;
            return true;
        }
        return false;
    }

    String[] getAllSubfolders() throws ServiceException, RemoteException {
        String[] result = null;
        String template = "<Templates><Tree Name=\"\" Id=\"\"><Subtrees/></Tree></Templates>";
        Filter filter = new Filter();
        filter.setOMRFlags(-2147483260);
        filter.setType("Tree");
        filter.setOMRTemplate(template);
        BrowseMetadataInterface bmi = this._repository.getServer().browseFetch(this.getEntityKey(), filter);
        ArrayList resultList = new ArrayList();
        this.flattenBrowseResults(bmi, resultList);
        result = new String[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    void flattenBrowseResults(BrowseMetadataInterface bmi, List list) {
        List subfolderList = bmi.getSubfolders();
        if (subfolderList != null) {
            for (BrowseMetadataInterface subfolder : subfolderList) {
                this.flattenBrowseResults(subfolder, list);
            }
        }
        list.add(bmi.getReposId());
    }

    private void expireMidTierSessionContext() throws RemoteException {
        block4: {
            try {
                this.invokeStaticMethod(UTIL_REPORT_REPOS_CLASS_NAME, EXPIRE_STS_CLIENT_METHOD_NAME, new Class[]{UserContextInterface.class}, new Object[]{this.getRepository().getUserContext()});
            }
            catch (ServiceException e) {
                Logger logger;
                UserContextInterface uc = this._repository.getUserContext();
                if (uc == null || (logger = LogManager.getLogger((String)FOLDER_CONTEXT)) == null || !logger.isDebugEnabled()) break block4;
                Serializable t = e;
                while (t != null) {
                    logger.log(Level.DEBUG, "Exception while expiring Midtier Session in Report Repository", (Throwable)t);
                    Throwable rootCause = ChainedException.getRootException((Throwable)t);
                    if (rootCause != null && !rootCause.equals(t)) {
                        t = rootCause;
                        logger.log(Level.DEBUG, "<<<<------------------------------->>>>");
                        continue;
                    }
                    t = null;
                }
                logger.log(Level.DEBUG, "Exception while expiring Midtier Session in Report Repository", (Throwable)t);
            }
        }
    }

    private boolean davCredentialsSecured() throws RemoteException {
        try {
            Boolean secured = (Boolean)this.invokeStaticMethod(DAV_CREDENTIALS_HELPER_CLASS_NAME, CREDENTIALS_SECURED_METHOD_NAME, new Class[]{MetadataInterface.class}, new Object[]{this});
            return secured;
        }
        catch (ServiceException e) {
            this.logThrowable(Level.WARN, e.getMessage(), FOLDER_CONTEXT, (Throwable)((Object)e));
            return false;
        }
    }

    private boolean pingDAVServer() throws RemoteException, ServiceException {
        Boolean result;
        if (this.davSecuredUserAvailable()) {
            result = (Boolean)this.invokeStaticMethod(OMRID_CLASS_NAME, PING_DAV_SERVER_METHOD_NAME, new Class[]{String.class}, new Object[]{this.getPathUrl().toString()});
        } else {
            String serviceRegistryURL = this.getServiceRegistryURL();
            Object obj = this.instantiateObject(UTIL_SERVICE_PROXY_CLASS_NAME, new Class[]{String.class}, new Object[]{serviceRegistryURL});
            result = (Boolean)this.invokeMethod(obj, PING_DAV_SERVER_METHOD_NAME, new Class[]{String.class}, new Object[]{this.getPathUrl().toString()});
        }
        return result;
    }

    private boolean davSecuredUserAvailable() throws ServiceException {
        Boolean available = (Boolean)this.invokeStaticMethod(OMRID_CLASS_NAME, SECURED_USER_AVAILABLE_METHOD_NAME, null, null);
        return available;
    }

    private String getServiceRegistryURL() throws RemoteException, ServiceException {
        String serviceRegistryURL = (String)this.invokeStaticMethod(SERVICE_REGISTRY_HELPER_CLASS_NAME, GET_URL_METHOD_NAME, new Class[]{InformationServiceInterface.class, UserContextInterface.class}, new Object[]{Folder.getInformationService(), this.getRepository().getUserContext()});
        return serviceRegistryURL;
    }

    private Object invokeStaticMethod(String className, String methodName, Class[] params, Object[] args) throws ServiceException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            Method m = clazz.getMethod(methodName, params);
            return m.invoke(null, args);
        }
        catch (SecurityException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    private Object instantiateObject(String className, Class[] ctorParams, Object[] ctorArgs) throws ServiceException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            Constructor<?> ctor = clazz.getConstructor(ctorParams);
            return ctor.newInstance(ctorArgs);
        }
        catch (SecurityException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    private Object invokeMethod(Object obj, String methodName, Class[] params, Object[] args) throws ServiceException {
        try {
            Method m = obj.getClass().getMethod(methodName, params);
            return m.invoke(obj, args);
        }
        catch (SecurityException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        String validName;
        String oldName;
        String treeType;
        boolean isUpdated = false;
        if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), CURRENT_VERSION)) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        Tree treeObject = (Tree)this._repositoryObject;
        if (!FolderUtil.isFolder(treeObject.getPublicType())) {
            treeObject.setPublicType(this.getType());
            isUpdated = true;
        }
        if (treeObject.getUsageVersion() < CURRENT_VERSION.encode()) {
            treeObject.setUsageVersion(CURRENT_VERSION.encode());
            isUpdated = true;
        }
        if (!(treeType = treeObject.getTreeType()).equalsIgnoreCase("BIP Folder") && !treeType.equalsIgnoreCase("System")) {
            treeObject.setTreeType("BIP Folder");
        }
        if (!(oldName = this.getName()).equals(validName = FolderUtil.makeValidFolderName(this, null))) {
            PathUrl oldPathUrl = this.getPathUrl();
            String oldPath = oldPathUrl != null ? oldPathUrl.getDisplayPath() : this.getName();
            treeObject.setName(validName);
            isUpdated = true;
            this.logMessage(Level.WARN, Message.format((ResourceBundle)RB.getResources(), (String)"Metadata.RenameObject.fmt.txt", (Object)"Folder", (Object)oldPath, (Object)validName));
        }
        if (isUpdated) {
            try {
                treeObject.updateMetadataAll();
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    class DateDescendingComparator
    implements Comparator {
        DateDescendingComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                Date firstDate = firstMI.getModifyDate();
                Date secondDate = secondMI.getModifyDate();
                return secondDate.compareTo(firstDate);
            }
            catch (RemoteException e) {
                return 0;
            }
            catch (ServiceException e) {
                return 0;
            }
        }
    }

    class DateComparator
    implements Comparator {
        DateComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                Date firstDate = firstMI.getModifyDate();
                Date secondDate = secondMI.getModifyDate();
                return firstDate.compareTo(secondDate);
            }
            catch (RemoteException e) {
                return 0;
            }
            catch (ServiceException e) {
                return 0;
            }
        }
    }

    class DescriptionDescendingComparator
    implements Comparator {
        DescriptionDescendingComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                String firstDesc = firstMI.getDescription();
                String secondDesc = secondMI.getDescription();
                return secondDesc.compareToIgnoreCase(firstDesc);
            }
            catch (RemoteException e) {
                return 0;
            }
        }
    }

    class DescriptionComparator
    implements Comparator {
        DescriptionComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                String firstDesc = firstMI.getDescription();
                String secondDesc = secondMI.getDescription();
                return firstDesc.compareToIgnoreCase(secondDesc);
            }
            catch (RemoteException e) {
                return 0;
            }
        }
    }

    class TypeDescendingComparator
    implements Comparator {
        TypeDescendingComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                String firstType = Folder.this.getType(firstMI);
                String secondType = Folder.this.getType(secondMI);
                return secondType.compareToIgnoreCase(firstType);
            }
            catch (RemoteException e) {
                return 0;
            }
        }
    }

    class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                String firstType = Folder.this.getType(firstMI);
                String secondType = Folder.this.getType(secondMI);
                return firstType.compareToIgnoreCase(secondType);
            }
            catch (RemoteException e) {
                return 0;
            }
        }
    }

    class NameDescendingComparator
    implements Comparator {
        NameDescendingComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                String firstName = firstMI.getName();
                String secondName = secondMI.getName();
                return secondName.compareToIgnoreCase(firstName);
            }
            catch (RemoteException e) {
                return 0;
            }
        }
    }

    class NameComparator
    implements Comparator {
        NameComparator() {
        }

        public int compare(Object first, Object second) {
            if (!(first instanceof MetadataInterface) || !(second instanceof MetadataInterface)) {
                return 0;
            }
            MetadataInterface firstMI = (MetadataInterface)first;
            MetadataInterface secondMI = (MetadataInterface)second;
            try {
                String firstName = firstMI.getName();
                String secondName = secondMI.getName();
                return firstName.compareToIgnoreCase(secondName);
            }
            catch (RemoteException e) {
                return 0;
            }
        }
    }
}

