/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.metadata.Attachment;
import com.sas.services.information.metadata.CommentInterface;
import com.sas.services.user.UserContextInterface;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Comment
implements CommentInterface,
Serializable {
    private static final long serialVersionUID = 7809186461122332553L;
    private static final int ATTACHMENT_ARRAY_INIT = 4;
    private String _author = null;
    private long _timestamp = 0L;
    private String _text = null;
    private boolean _private = false;
    private ArrayList _attachments = new ArrayList(4);
    private static DateFormat dt = DateFormat.getDateTimeInstance(2, 2);

    public Comment() throws RemoteException {
    }

    public Comment(UserContextInterface author, String text) throws RemoteException {
        this(author, text, false);
    }

    public Comment(UserContextInterface author, String text, boolean secret) throws RemoteException {
        this._author = author.getName();
        this._text = text;
        this._timestamp = System.currentTimeMillis();
        this._private = secret;
    }

    @Override
    public String getText() throws RemoteException {
        return this._text;
    }

    @Override
    public String getTimestamp(DateFormat dtFormat) throws RemoteException {
        return dtFormat.format(new Date(this._timestamp));
    }

    @Override
    public long getTimestamp() throws RemoteException {
        return this._timestamp;
    }

    @Override
    public String getAuthor() throws RemoteException {
        return this._author;
    }

    @Override
    public boolean hasAttachments() throws RemoteException {
        return this._attachments.size() > 0;
    }

    @Override
    public List getAttachments() throws RemoteException {
        return this._attachments;
    }

    @Override
    public void addAttachment(String name, String desc, String mimeType, InputStream content) throws RemoteException {
        Attachment _attachment = new Attachment(name, desc, mimeType, content);
        this._attachments.add(_attachment);
    }

    @Override
    public String formatComment(String xsl) throws RemoteException {
        return xsl;
    }

    @Override
    public void delete() throws RemoteException {
    }

    @Override
    public void setTimeStamp(long timestamp) throws IllegalStateException, RemoteException {
        if (this._timestamp != 0L) {
            throw new IllegalStateException("Comment timestamp is already set");
        }
        this._timestamp = timestamp;
    }

    @Override
    public void setAuthor(String author) throws IllegalStateException, RemoteException {
        if (this._author != null) {
            throw new IllegalStateException("Comment author is already set");
        }
        this._author = author;
    }

    @Override
    public void setText(String text) throws IllegalStateException, RemoteException {
        if (this._text != null) {
            throw new IllegalStateException("Comment text is already set");
        }
        this._text = text;
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    public String toString() {
        return dt.format(new Date(this._timestamp)) + ": (" + this._author + ") " + this._text;
    }
}

