/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RB;

@SASScope
public class TreeSearchFilter
extends Filter {
    private static final int TREEBUFFER_INIT = 64;
    private static final long serialVersionUID = 5682278581650865715L;
    String _selectString;
    String _type;
    String _template;

    public TreeSearchFilter(FilterInterface oldFilter, String treeId) {
        this(oldFilter, new String[]{treeId});
    }

    public TreeSearchFilter(FilterInterface oldFilter, String[] trees) {
        String oldSelect = oldFilter.getXMLSelectString();
        if (oldSelect.equals("UNSUPPORTED")) {
            throw new IllegalArgumentException(RB.getStringResource("TreeSearchFilter.unsupported.ex.txt"));
        }
        StringBuffer buffer = new StringBuffer(64);
        String prefix = null;
        String postfix = null;
        if (oldSelect == null || oldSelect.length() == 0) {
            prefix = "    <XMLSelect search=\"*";
            postfix = "\" />";
        } else {
            int index = oldSelect.lastIndexOf("\"");
            prefix = oldSelect.substring(0, index).trim();
            postfix = oldSelect.substring(index).trim();
        }
        buffer.append(prefix);
        buffer.append("[Trees/Tree[");
        for (int i = 0; i < trees.length; ++i) {
            if (i > 0) {
                buffer.append(" or ");
            }
            buffer.append(" @Id='" + trees[i] + '\'');
        }
        buffer.append("]]");
        buffer.append(postfix);
        this._selectString = buffer.toString();
        this._type = oldFilter.getOMRType();
        this._template = oldFilter.getOMRTemplate();
        this.setOMRFlags(oldFilter.getOMRFlags());
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getOMRType() {
        return this._type;
    }

    @Override
    public String getOMRTemplate() {
        return this._template;
    }

    @Override
    public String getXMLSelectString() {
        return this._selectString;
    }
}

