/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.app.AppClassLoader;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.PluginRequest;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import com.sas.app.VersionSpec;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Logger;

@SASScope
public class PluginClassLoader
extends URLClassLoader {
    public static final int POLICY_PLATFORM_STRICT = 1;
    public static final int POLICY_PLATFORM_UPGRADE = 2;
    public static final int POLICY_PLATFORM_FLEXIBLE = 3;
    private static final String[] POLICY_STRINGS = new String[]{null, "PLATFORM_STRICT", "PLATFORM_UPGRADE", "PLATFORM_FLEXIBLE"};
    private String _name;
    private File _pluginDir;
    private int _policy;
    private boolean _isValid;
    private Logger _logger;
    private Map _knownPluginVersions = null;

    PluginClassLoader(File pluginDir, int policy, Logger logger) throws SecurityException, ServiceException {
        super(new URL[0]);
        this.init(pluginDir, policy, logger);
    }

    PluginClassLoader(File pluginDir, int policy, Logger logger, ClassLoader parent) throws SecurityException, ServiceException {
        super(new URL[0], parent);
        this.init(pluginDir, policy, logger);
    }

    private void init(File pluginDir, int policy, Logger logger) throws ServiceException {
        this._name = pluginDir.getName();
        this._pluginDir = pluginDir;
        this._policy = policy > 0 && policy < POLICY_STRINGS.length ? policy : 2;
        this._isValid = false;
        this._logger = logger;
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Initializing plugin class loader for " + this._pluginDir);
        }
        this.addPluginJars();
        this.addPicklistModules();
        if (!this._isValid) {
            throw new ServiceException(Message.format((String)"{0} plugin not found at {1}.", (Object)this._name, (Object)this._pluginDir));
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public File getPluginDir() {
        return this._pluginDir;
    }

    public int getPolicy() {
        return this._policy;
    }

    private Plugin[] loadPicklist(File pickListFile) throws ServiceException {
        Plugin[] plugins = null;
        if (pickListFile.exists()) {
            try {
                FileInputStream input = new FileInputStream(pickListFile);
                PickList pickList = new PickList((InputStream)input);
                plugins = Repository.getDefaultRepository().find(pickList);
            }
            catch (RepositoryException e) {
                StringBuffer errorMsg = new StringBuffer("Unable to load following picklist modules.");
                List modules = e.getUnsatisfiedRequests();
                for (PluginRequest module : modules) {
                    VersionSpec pluginVersion = module.getRange();
                    errorMsg.append(Message.format((String)"\n    {0} {1}", (Object)module.getName(), (Object)(pluginVersion.isRange() ? pluginVersion.toRangeString(false) : pluginVersion.toVersionString())));
                }
                throw new ServiceException(errorMsg.toString());
            }
            catch (Exception e) {
                throw new ServiceException(e, Message.format((String)"Error loading picklist for {0} plugin.", (Object)this._name));
            }
        }
        return plugins;
    }

    private void addPluginJars() throws ServiceException {
        try {
            File classesDir = new File(this._pluginDir, "classes");
            if (classesDir.exists() && classesDir.isDirectory()) {
                this.addURL(classesDir.toURI().toURL());
                this._isValid = true;
            }
            String[] names = this._pluginDir.list(new FileExtension(".jar"));
            for (int i = 0; i < names.length; ++i) {
                File urlFile = new File(this._pluginDir, names[i]);
                this.addURL(urlFile.toURI().toURL());
                this._isValid = true;
            }
        }
        catch (MalformedURLException e) {
            throw new ServiceException(e);
        }
    }

    private void addPicklistModules() throws ServiceException {
        Plugin[] picklistModules = this.loadPicklist(new File(this._pluginDir, "picklist"));
        if (picklistModules == null || picklistModules.length == 0) {
            return;
        }
        this._isValid = true;
        this._knownPluginVersions = new HashMap();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof AppClassLoader) {
            this._knownPluginVersions.putAll(((AppClassLoader)cl).getLoadedPluginNameVersions());
        }
        StringBuffer versionErrorMessage = new StringBuffer();
        for (int i = 0; i < picklistModules.length; ++i) {
            Plugin plugin = picklistModules[i];
            if (!this.getPluginLoadStatus(plugin, versionErrorMessage)) continue;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((String)"Adding {0} to {1} plugin class loader.", (Object)plugin.getName(), (Object)this._name));
            }
            URL[] pluginUrls = plugin.getBundleClasspath();
            for (int j = 0; j < pluginUrls.length; ++j) {
                this.addURL(pluginUrls[j]);
            }
        }
        if (versionErrorMessage.length() > 0) {
            throw new InitializationException(versionErrorMessage.toString());
        }
    }

    public PluginClassLoader getChildLoader(File pluginDir) throws SecurityException, ServiceException {
        return new PluginClassLoader(pluginDir, this._policy, this._logger, this);
    }

    public ClassLoader getChildLoader(URL[] initialUrls, List plugins) throws ServiceException {
        ArrayList<URL> urls = new ArrayList<URL>(Arrays.asList(initialUrls));
        StringBuffer versionErrorMessage = new StringBuffer();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Initializing child plugin class loader for plugin " + this._name);
        }
        for (Plugin plugin : plugins) {
            if (!this.getPluginLoadStatus(plugin, versionErrorMessage)) continue;
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((String)"Adding {0} to {1} plugin class loader.", (Object)plugin.getName(), (Object)this._name));
            }
            URL[] pluginUrls = plugin.getBundleClasspath();
            for (int i = 0; i < pluginUrls.length; ++i) {
                urls.add(pluginUrls[i]);
            }
        }
        if (versionErrorMessage.length() > 0) {
            throw new InitializationException(versionErrorMessage.toString());
        }
        return new URLClassLoader(urls.toArray(new URL[0]), (ClassLoader)this);
    }

    private boolean getPluginLoadStatus(Plugin plugin, StringBuffer versionErrorMessage) {
        boolean versionError = false;
        String pluginName = plugin.getName();
        VersionSpec pluginVersion = plugin.getVersion();
        if (this._knownPluginVersions.containsKey(pluginName)) {
            VersionSpec platformVersion = (VersionSpec)this._knownPluginVersions.get(pluginName);
            switch (this._policy) {
                case 1: {
                    if (!pluginVersion.includes(platformVersion)) {
                        versionError = true;
                    }
                }
                case 2: {
                    if (pluginVersion.compareTo(platformVersion) > 0) {
                        versionError = true;
                    }
                }
                case 3: {
                    return false;
                }
            }
            if (versionError) {
                if (versionErrorMessage.length() == 0) {
                    versionErrorMessage.append("Unable to load following picklist modules due to class loader version policy.");
                }
                versionErrorMessage.append(Message.format((String)"\n    {0} {1}", (Object)pluginName, (Object)(pluginVersion.isRange() ? pluginVersion.toRangeString(false) : pluginVersion.toVersionString())));
            }
            return false;
        }
        return true;
    }

    public static int parsePolicy(String policy) {
        for (int i = 1; i < POLICY_STRINGS.length; ++i) {
            if (!policy.toUpperCase().equals(POLICY_STRINGS[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid PluginClassLoader policy.");
    }

    public static String toStringPolicy(int policy) {
        if (policy <= 0 || policy >= POLICY_STRINGS.length) {
            throw new IllegalArgumentException("Invalid PluginClassLoader policy string.");
        }
        return POLICY_STRINGS[policy];
    }

    @SASScope
    public class InitializationException
    extends ServiceException {
        private static final long serialVersionUID = 92000001L;

        public InitializationException(String msg) {
            super(msg);
        }
    }

    @SASScope
    private class FileExtension
    implements FilenameFilter {
        private String _extension;

        public FileExtension(String ext) {
            this._extension = ext.toLowerCase(Locale.US);
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.US).endsWith(this._extension);
        }
    }
}

