/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.AssociationPathComponent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SASScope(value="ALL")
public class FilterComponent
implements Serializable {
    private static final long serialVersionUID = 339692642076714674L;
    public static final int ALL_OF = 0;
    public static final int ANY_OF = 1;
    public static final int EQUALS = 0;
    public static final int CONTAINS = 1;
    public static final int STARTSWITH = 2;
    public static final int ENDSWITH = 3;
    public static final int DAVSERVERTEST = 4;
    public static final int DAVSERVERNOTTEST = 5;
    public static final int LT = 6;
    public static final int LTE = 7;
    public static final int GT = 8;
    public static final int GTE = 9;
    public static final int FULLTEXT = 10;
    public static final int NE = 11;
    private static final String ATTRIBUTE_KEY = "@";
    private static final String ASSOCIATION_KEY = "/";
    int _relation = 0;
    int _aggregation = 0;
    String _key = null;
    String _value = null;
    List<FilterComponent> _elements = new ArrayList<FilterComponent>(8);
    List<AssociationPathComponent> _assocElements = null;
    private static final int ELEMENT_LIST_INIT = 8;

    public FilterComponent() {
    }

    public FilterComponent(String key, int relation, String value) {
        this();
        this._key = key;
        this._relation = relation;
        this._value = value;
    }

    public void setFilter(String key, int relation, String value) {
        this._key = key;
        this._relation = relation;
        this._value = value;
    }

    public String getKey() {
        return this._key;
    }

    public String getValue() {
        return this._value;
    }

    public int getRelation() {
        return this._relation;
    }

    public void addComponent(FilterComponent newComponent) {
        this._elements.add(newComponent);
    }

    public Iterator getComponents() {
        return this._elements.iterator();
    }

    public List<FilterComponent> getSubcomponentList() {
        return this._elements;
    }

    public boolean containsComponents() {
        return this._elements == null ? false : this._elements.size() > 0;
    }

    public void addAssociationPathComponent(AssociationPathComponent newComponent) {
        this.addAssociationPathComponent(newComponent, -1);
    }

    public void addAssociationPathComponent(AssociationPathComponent newComponent, int aggregation) {
        if (this._assocElements == null) {
            this._assocElements = new ArrayList<AssociationPathComponent>(2);
        }
        if (this._assocElements.size() > 0) {
            newComponent.setAggregation(aggregation);
        }
        this._assocElements.add(newComponent);
    }

    public Iterator<AssociationPathComponent> getAssociationPathComponents() {
        if (this._assocElements == null) {
            this._assocElements = new ArrayList<AssociationPathComponent>(2);
        }
        return this._assocElements.iterator();
    }

    public List<AssociationPathComponent> getAssociationComponents() {
        return this._assocElements;
    }

    public boolean containsAssociationPathComponents() {
        return this._assocElements == null ? false : this._assocElements.size() > 0;
    }

    public void setAggregation(int aggregator) {
        this._aggregation = aggregator;
    }

    public int getAggregation() {
        return this._aggregation;
    }
}

