/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.antlr.CommonAST;
import com.sas.antlr.RecognitionException;
import com.sas.antlr.collections.AST;
import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.FactoryAction;
import com.sas.services.information.FactoryException;
import com.sas.services.information.FactoryNotInitializedException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.NewInstanceException;
import com.sas.services.information.PluginLoader;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.Content;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.dav.DAVEntity;
import com.sas.services.information.metadata.dav.DAVItem;
import com.sas.services.information.rules.EvaluatorInterface;
import com.sas.services.information.rules.ExpressionLexer;
import com.sas.services.information.rules.ExpressionParser;
import com.sas.services.information.rules.ExpressionTreeWalker;
import com.sas.services.information.rules.ParseException;
import com.sas.text.Message;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Factory {
    private static Factory _theInstance;
    private Map _TypeMap;
    private boolean _Configured;
    private Logger _Logger;
    private PluginLoader _pluginLoader;
    private static final int TESTLIST_INIT = 16;
    private static final int LISTINIT_ONE = 1;

    private Factory() {
    }

    public static Factory getInstance() {
        if (_theInstance == null) {
            _theInstance = new Factory();
        }
        return _theInstance;
    }

    static InformationServiceInterface getInformationService() throws ServiceException {
        InformationServiceInterface informationService = null;
        try {
            informationService = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        }
        catch (RemoteException t) {
            t.printStackTrace(System.out);
            informationService = null;
        }
        return informationService;
    }

    void destroy() {
        this._Logger = null;
        if (this._TypeMap != null) {
            this._TypeMap.clear();
        }
        this._pluginLoader = null;
        _theInstance = null;
    }

    private boolean isDebug() {
        return this._Logger != null && this._Logger.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debug(String debugString) {
        if (this.isDebug()) {
            Logger logger = this._Logger;
            synchronized (logger) {
                this._Logger.debug(debugString);
            }
        }
    }

    private boolean isInfo() {
        return this._Logger != null && this._Logger.isInfoEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void info(String infoString) {
        if (this.isInfo()) {
            Logger logger = this._Logger;
            synchronized (logger) {
                this._Logger.info(infoString);
            }
        }
    }

    private void infoException(Throwable throwable) {
        if (this.isInfo()) {
            Throwable rootCause = this.getRootCause(throwable);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            rootCause.printStackTrace(pw);
            sw.flush();
            this.info(sw.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warn(String warnString) {
        if (this._Logger != null && this._Logger.isEnabled(Level.WARN)) {
            Logger logger = this._Logger;
            synchronized (logger) {
                this._Logger.warn(warnString);
            }
        }
    }

    private void warnException(Throwable throwable) {
        Throwable rootCause = this.getRootCause(throwable);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        rootCause.printStackTrace(pw);
        sw.flush();
        this.warn(sw.toString());
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable rootCause = throwable;
        while (rootCause.getCause() != null && !rootCause.equals(rootCause.getCause())) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    public void configure(Map types) {
        this._Logger = LogManager.getLogger((String)"com.sas.services.information.Factory");
        this._TypeMap = new HashMap(types);
        try {
            this._pluginLoader = PluginLoader.getInstance("sas.services.information.types");
        }
        catch (ServiceException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        this._Configured = true;
    }

    public boolean isConfigured() {
        return this._Configured;
    }

    String getAction(String type, Object o, RepositoryInterface repos) throws ServiceException {
        if (type.startsWith("tdi:")) {
            this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.retaction.msg.fmt.txt", (Object)("ctor::" + type.substring(4))));
            return "ctor::" + type.substring(4);
        }
        if (!this._Configured) {
            try {
                InformationServiceInterface is = Factory.getInformationService();
                HashMap config = is.getFactoryConfig();
                this.configure(config);
            }
            catch (RemoteException rex) {
                this.warnException(rex);
                throw new ServiceException(RB.getStringResource("Factory.notconfig.ex.txt"));
            }
            catch (ServiceException t) {
                this.warnException((Throwable)((Object)t));
                throw new ServiceException(RB.getStringResource("Factory.notconfig.ex.txt"));
            }
        }
        if (this.isDebug()) {
            this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.getaction.msg.fmt", (Object)type));
        }
        if (this._TypeMap == null) {
            return null;
        }
        Object typeEntry = this._TypeMap.get(type);
        if (typeEntry == null) {
            if (this.isDebug()) {
                this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.noaction.msg.fmt", (Object)type));
            }
            return null;
        }
        ArrayList<FactoryAction> factoryActions = null;
        if (typeEntry instanceof FactoryAction) {
            factoryActions = new ArrayList<FactoryAction>(1);
            factoryActions.add((FactoryAction)typeEntry);
        } else if (typeEntry instanceof List) {
            List typeList = (List)typeEntry;
            factoryActions = new ArrayList(typeList.size());
            for (Object fAction : typeList) {
                factoryActions.add((FactoryAction)fAction);
            }
            Collections.sort(factoryActions, new FactoryAction());
        }
        for (FactoryAction faction : factoryActions) {
            String filter = faction.getFilter();
            String action = faction.getAction();
            if (filter == null || filter.length() == 0) {
                if (this.isDebug()) {
                    this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.retaction.msg.fmt.txt", (Object)action));
                }
                return action;
            }
            if (this.isDebug()) {
                this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.chkfilter.msg.fmt.txt", (Object)filter));
            }
            if (repos != null) {
                try {
                    StringReader input = new StringReader(filter);
                    ExpressionLexer lexer = new ExpressionLexer(input);
                    ExpressionParser parser = new ExpressionParser(lexer);
                    EvaluatorInterface evaluator = repos.getEvaluator(o);
                    try {
                        parser.parse();
                        ExpressionTreeWalker expressionTreeWalker = new ExpressionTreeWalker(evaluator);
                        CommonAST parseTree = (CommonAST)parser.getAST();
                        boolean b = expressionTreeWalker.expr((AST)parseTree);
                        if (!b) continue;
                        return action;
                    }
                    catch (ParseException ex) {
                        System.err.println(filter);
                        throw new ServiceException((Throwable)((Object)ex), ex.getMessage());
                    }
                    catch (RecognitionException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                    catch (RemoteException ex) {
                        throw new ServiceException(ex, ex.getMessage());
                    }
                }
                catch (RemoteException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
            ArrayList<Object> testObjects = new ArrayList<Object>(16);
            testObjects.add(o);
            StringTokenizer st = new StringTokenizer(filter, "/", false);
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.charAt(0) == '@') {
                    Iterator testIt;
                    StringBuilder buffer = new StringBuilder(nextToken);
                    while (st.hasMoreTokens()) {
                        buffer.append('/' + st.nextToken());
                    }
                    nextToken = buffer.toString();
                    int index = nextToken.indexOf("=");
                    String string = nextToken.substring(1, index);
                    index = nextToken.indexOf("'");
                    if (index < 0) {
                        throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)nextToken));
                    }
                    int index2 = nextToken.lastIndexOf("'");
                    if (index2 <= index) {
                        throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)nextToken));
                    }
                    String value = nextToken.substring(index + 1, index2);
                    if (o instanceof Root) {
                        testIt = testObjects.iterator();
                        while (testIt.hasNext()) {
                            if (!Factory.isMatch(testIt.next(), string, value)) continue;
                            if (this.isDebug()) {
                                this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.retaction.msg.fmt.txt", (Object)action));
                            }
                            return action;
                        }
                        continue;
                    }
                    if (!(o instanceof Map)) continue;
                    testIt = testObjects.iterator();
                    while (testIt.hasNext()) {
                        if (!Factory.isMapMatch(testIt.next(), string, value)) continue;
                        if (this.isDebug()) {
                            this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.retaction.msg.fmt.txt", (Object)action));
                        }
                        return action;
                    }
                    continue;
                }
                if (nextToken.charAt(0) == '*') {
                    ArrayList newTestObjects = new ArrayList(16);
                    nextToken = nextToken.substring(1);
                    if (o instanceof Root) {
                        for (Object e : testObjects) {
                            this.buildTestList(e, nextToken, newTestObjects);
                        }
                        testObjects = newTestObjects;
                        continue;
                    }
                    if (!(o instanceof Map)) continue;
                    for (Map map : testObjects) {
                        Factory.addToTestObjects(map, nextToken, newTestObjects);
                    }
                    testObjects = newTestObjects;
                    continue;
                }
                throw new FactoryException(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.badfileter.ex.fmt", (Object)nextToken));
            }
        }
        if (this.isDebug()) {
            this.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.noaction.msg.fmt", (Object)type));
        }
        return null;
    }

    private static boolean isMatch(Object testObject, String attribute, String value) {
        try {
            Root root = (Root)testObject;
            Map attrMap = root.getAttrs();
            String attrValue = (String)attrMap.get(attribute);
            if (attrValue == null) {
                return false;
            }
            if (value.equalsIgnoreCase(attrValue)) {
                return true;
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace(System.out);
        }
        catch (RemoteException ex) {
            ex.printStackTrace(System.out);
        }
        return false;
    }

    private static boolean isMapMatch(Object testObject, String attribute, String value) {
        try {
            Map nextMap = (Map)testObject;
            String attrValue = (String)nextMap.get(attribute);
            if (attrValue == null) {
                return false;
            }
            if (value.equalsIgnoreCase(attrValue)) {
                return true;
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace(System.out);
        }
        return false;
    }

    private void buildTestList(Object nextObject, String nextToken, List newTestObjects) throws ServiceException {
        Class<?> metaClass = nextObject.getClass();
        String methodName = "get" + nextToken;
        Method getMethod = null;
        Class[] args = new Class[]{Boolean.TYPE};
        Object[] parms = new Object[]{Boolean.TRUE};
        try {
            getMethod = metaClass.getMethod(methodName, null);
            Object output = getMethod.invoke(nextObject, (Object[])null);
            if (output instanceof AssociationList) {
                Iterator outputIt = ((AssociationList)output).iterator();
                while (outputIt.hasNext()) {
                    newTestObjects.add(outputIt.next());
                }
            } else if (output != null) {
                newTestObjects.add(output);
            }
        }
        catch (NoSuchMethodException ex) {
            this.warn(Message.format((ResourceBundle)RB.getResources(), (String)"Factory.nometh.ex.fmt", metaClass, (Object)methodName));
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (InvocationTargetException ite) {
            this.warnException(ite);
            Throwable throwable = this.getRootCause(ite);
            throw new ServiceException(throwable, throwable.getMessage());
        }
        catch (IllegalAccessException iae) {
            this.warnException(iae);
            Throwable throwable = this.getRootCause(iae);
            throw new ServiceException(throwable, throwable.getMessage());
        }
    }

    private static void addToTestObjects(Map nextObject, String nextToken, List newTestObjects) {
        List list = (List)nextObject.get(nextToken);
        if (list != null) {
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                Object testObject = list.get(i);
                if (!(testObject instanceof Map)) continue;
                newTestObjects.add(testObject);
            }
        }
    }

    @Deprecated
    public MetadataInterface process(Object o) throws ServiceException {
        return this.processWithRepository(o, null);
    }

    public MetadataInterface processWithRepository(Object o, RepositoryInterface ri) throws ServiceException {
        String key;
        boolean isDav;
        MetadataInterface result;
        block29: {
            result = null;
            if (!this.isConfigured()) {
                try {
                    InformationServiceInterface is = Factory.getInformationService();
                    HashMap config = is.getFactoryConfig();
                    this.configure(config);
                }
                catch (RemoteException t) {
                    throw new ServiceException(t, t.getMessage());
                }
            }
            isDav = false;
            if (o == null) {
                return null;
            }
            key = null;
            if (ri == null) {
                if (o instanceof CMetadata) {
                    try {
                        key = "omi:" + ((CMetadata)o).getCMetadataType().toLowerCase();
                    }
                    catch (RemoteException rex) {
                        throw new ServiceException(rex, rex.getMessage());
                    }
                } else if (o instanceof DAVEntity) {
                    key = "dav:" + ((DAVEntity)o).getType().toLowerCase();
                }
            } else {
                try {
                    key = ri.getFactoryKey(o);
                }
                catch (RemoteException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
            if (o instanceof DAVEntity) {
                isDav = true;
            }
            if (key == null) {
                return null;
            }
            String action = this.getAction(key, o, ri);
            if (action != null && action.startsWith("ctor")) {
                String className = null;
                try {
                    int index = action.lastIndexOf(":");
                    className = action.substring(index + 1);
                    Class[] ctorArgs = new Class[]{o.getClass()};
                    Object[] ctorParms = new Object[]{o};
                    try {
                        result = (MetadataInterface)this.newInstance(className, ctorArgs, ctorParms);
                    }
                    catch (ServiceException e) {
                        if (e.getCause() instanceof NoSuchMethodException) {
                            Class[] ctorArgs2 = new Class[]{Object.class};
                            result = (MetadataInterface)this.newInstance(className, ctorArgs2, ctorParms);
                            break block29;
                        }
                        throw e;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.infoException(cnfe);
                }
                catch (ServiceException e) {
                    this.infoException((Throwable)((Object)e));
                }
            }
        }
        if (result == null) {
            if (this.isDebug()) {
                this.debug(RB.getStringResource("Factory.dfltaction.msg.txt"));
            }
            try {
                result = ri != null ? ri.produceDefaultMetadata(o) : (isDav ? (o instanceof DAVItem ? new Content(o) : new Folder(o)) : new Metadata(o));
            }
            catch (RemoteException rex) {
                FactoryException fax = new FactoryException(rex, RB.getStringResource("Factory.newobject.ex.txt"));
                fax.setRepositoryType(key);
                throw fax;
            }
        }
        if (result != null && ri != null) {
            try {
                result.setRepository(ri);
            }
            catch (RemoteException rex) {
                this._Logger.warn("", (Throwable)rex);
            }
        }
        return result;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (!this._Configured) {
            return null;
        }
        return this._pluginLoader.loadClass(className);
    }

    public String toString() {
        return "Object factory";
    }

    public Object newInstance(String className) throws ClassNotFoundException, ServiceException {
        Class[] initParams = new Class[]{};
        Object[] initArgs = new Object[]{};
        return this.newInstance(className, initParams, initArgs);
    }

    public Object newInstance(String className, Class[] initParams, Object[] initArgs) throws ClassNotFoundException, ServiceException {
        if (!this._Configured) {
            throw new FactoryNotInitializedException("Factory class is not initialized.");
        }
        Class objectClass = this.loadClass(className);
        try {
            if (this.isDebug()) {
                this.debug("Creating new instance of " + className);
            }
            Constructor ctor = objectClass.getConstructor(initParams);
            return ctor.newInstance(initArgs);
        }
        catch (InstantiationException e) {
            throw new NewInstanceException(e, className);
        }
        catch (IllegalAccessException e) {
            throw new NewInstanceException(e, className);
        }
        catch (NoSuchMethodException e) {
            throw new NewInstanceException(e, className);
        }
        catch (InvocationTargetException e) {
            throw new NewInstanceException(e, className);
        }
        catch (IllegalArgumentException e) {
            throw new NewInstanceException(e, className);
        }
        catch (SecurityException e) {
            throw new NewInstanceException(e, className);
        }
    }

    @Deprecated
    public PluginLoader getPluginLoader() {
        return this._pluginLoader;
    }
}

