/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import java.io.Serializable;

public class Authorization
implements Serializable {
    private static final long serialVersionUID = 8558004602944133560L;
    public static final int AUTHSOURCE_EXPLICIT = 1;
    public static final int AUTHSOURCE_ACT = 2;
    public static final int AUTHSOURCE_INDIRECT = 3;
    public static final String AUTHTYPE_GRANT = "Grant";
    public static final String AUTHTYPE_DENY = "Deny";
    public static final String AUTHTYPE_REMOVE = "Remove";
    private String identType;
    private String identName;
    private String authAction;
    private int authSource;
    private String authType;
    private String conditions;

    public Authorization(String authType, String conditions) {
        this.authType = authType;
        this.conditions = conditions;
        this.authSource = 0;
        this.identType = null;
        this.identName = null;
        this.authAction = null;
    }

    public Authorization(String identType, String identName, String authAction, int authSource, String authType, String conditions) {
        this.identType = identType;
        this.identName = identName;
        this.authAction = authAction;
        this.authSource = authSource;
        this.authType = authType;
        this.conditions = conditions;
    }

    public String toString() {
        return this.identName + " " + this.authAction + " " + this.authType + (this.authSource == 1 ? "!" : "") + (this.authSource == 2 ? "*" : "") + (this.authSource == 3 ? "-" : "");
    }

    public final String getConditions() {
        return this.conditions;
    }

    public final void setConditions(String conditions) {
        this.conditions = conditions;
    }

    public final boolean isAuthorized() {
        return AUTHTYPE_GRANT.equalsIgnoreCase(this.authType);
    }

    public final String getAuthType() {
        return this.authType;
    }

    public final void setAuthType(String authType) {
        this.authType = authType;
    }

    public final int getAuthSource() {
        return this.authSource;
    }

    public final void setAuthSource(int authSource) {
        this.authSource = authSource;
    }

    public final String getIdentName() {
        return this.identName;
    }

    public final void setIdentName(String identName) {
        this.identName = identName;
    }

    public final String getIdentType() {
        return this.identType;
    }

    public final void setIdentType(String identType) {
        this.identType = identType;
    }

    public final String getAuthAction() {
        return this.authAction;
    }

    public final void setAuthAction(String authAction) {
        this.authAction = authAction;
    }
}

