/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information;

import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.Factory;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RB;
import com.sas.services.information.RepositoryEvent;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRepository2
extends UnicastRemoteObject
implements RepositoryInterface {
    protected String _isName = null;
    protected boolean _isDestroyed = false;
    protected Exception closeStack = null;
    protected UserContextInterface _user;
    protected Logger _logger = LogManager.getLogger((String)this.getClass().getName());
    protected String _url;
    protected String _domain;
    protected String _host;
    protected String _principal;
    protected int _portInt;
    protected ArrayList _listeners;
    protected String _uniqueId = null;
    private static final int COLLECTION_INIT = 5;

    @Override
    public void close() throws RemoteException {
        this._user = null;
        if (this._listeners != null) {
            this._listeners.clear();
        }
        this._listeners = null;
    }

    public static InformationServiceInterface getInformationService() throws RemoteException {
        InformationServiceInterface is = null;
        LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
        try {
            is = (InformationServiceInterface)discoveryService.findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return is;
    }

    protected AbstractRepository2() throws RemoteException {
    }

    protected AbstractRepository2(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
    }

    @Override
    public void setISName(String name) throws RemoteException {
        if (name != null && name.length() > 0) {
            this._isName = name;
        }
    }

    @Override
    public String getISName() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (this._isName != null) {
            return this._isName;
        }
        return null;
    }

    @Override
    public void setUserContext(UserContextInterface user) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        if (user == null) {
            return;
        }
        this._user = user;
    }

    @Override
    public UserContextInterface getUserContext() throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._user;
    }

    @Override
    public String getUrl() throws RemoteException {
        return this._url;
    }

    @Override
    public String getDomain() {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        return this._domain;
    }

    @Override
    public void setDomain(String domain) throws RemoteException {
        try {
            this.pulseCheck();
        }
        catch (ServiceException svcEx) {
            throw new IllegalStateException(svcEx.getMessage());
        }
        this._domain = domain;
    }

    @Override
    public String getHost() throws RemoteException {
        return this._host;
    }

    @Override
    public int getPort() throws RemoteException {
        return this._portInt;
    }

    @Override
    public String getPrincipal() throws RemoteException {
        return this._principal;
    }

    @Override
    public MetadataInterface getTrackedObject(int trackingId) throws RemoteException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._listeners != null) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RepositoryListenerInterface listener) throws ServiceException, RemoteException {
        this.pulseCheck();
        if (this._listeners != null) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                this._listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(int event) throws RemoteException {
        RepositoryEvent repEvent = new RepositoryEvent(this, event);
        ArrayList list = null;
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            list = new ArrayList(this._listeners);
        }
        for (RepositoryListenerInterface next : list) {
            next.repositoryCallback(repEvent);
        }
    }

    @Override
    public String getUniqueId() throws RemoteException {
        if (this._uniqueId != null) {
            return this._uniqueId;
        }
        this._uniqueId = new VMID().toString() + ':' + this.hashCode();
        return this._uniqueId;
    }

    @Override
    public boolean isDestroyed() throws RemoteException {
        return this._isDestroyed;
    }

    protected String getSmartType(String key, SmartTypeHelper helper, Map rawData, Logger logger) {
        try {
            String action = Factory.getInstance().getAction(key, rawData, this);
            if (action == null) {
                SmartTypeHelper.Result def = helper.getDefaultResult();
                rawData.put("isAFolder", def.isFolderStr());
                return helper.getDefaultResult().getSmartType();
            }
            String classString = action.substring(action.lastIndexOf(":") + 1);
            SmartTypeHelper.Result str = helper.lookup(classString);
            rawData.put("isAFolder", str.isFolderStr());
            rawData.put("smartclass", classString);
            return str.getSmartType();
        }
        catch (Exception ex) {
            this._logger.warn(RB.getStringResource("OMIRepository.smrttypeerr.ex.txt"), (Throwable)ex);
            SmartTypeHelper.Result def = helper.getDefaultResult();
            rawData.put("isAFolder", def.isFolderStr());
            return helper.getDefaultResult().getSmartType();
        }
    }

    protected void pulseCheck() throws ServiceException {
        if (this._isDestroyed) {
            if (this.closeStack != null && this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(RB.getStringResource("Repository.isdestroyed.ex.txt"), (Throwable)this.closeStack);
            }
            throw new ServiceException(RB.getStringResource("Repository.isdestroyed.ex.txt"));
        }
    }

    public class SmartTypeHelper {
        public final String TRUE = Boolean.TRUE.toString();
        public final String FALSE = Boolean.FALSE.toString();
        private Result _defaultResult;
        private Map _results = Collections.synchronizedMap(new HashMap(5));

        public SmartTypeHelper(String defaultSmartType) {
            this._defaultResult = new Result(defaultSmartType, false);
        }

        Result getDefaultResult() {
            return this._defaultResult;
        }

        Result lookup(String className) throws Exception {
            Result rval = (Result)this._results.get(className);
            if (rval == null) {
                try {
                    MetadataInterface emptyMd = (MetadataInterface)Factory.getInstance().newInstance(className);
                    String smartType = emptyMd.getType();
                    boolean isFolder = emptyMd instanceof FolderInterface;
                    rval = new Result(smartType, isFolder);
                    this._results.put(className, rval);
                }
                catch (Exception e) {
                    this._results.put(className, this.getDefaultResult());
                    throw e;
                }
            }
            return rval;
        }

        public class Result {
            private String _smartType;
            private boolean _isFolder;

            public Result(String smartType, boolean isFolder) {
                this._smartType = smartType;
                this._isFolder = isFolder;
            }

            public String getSmartType() {
                return this._smartType;
            }

            public boolean isFolder() {
                return this._isFolder;
            }

            public String isFolderStr() {
                return this._isFolder ? SmartTypeHelper.this.TRUE : SmartTypeHelper.this.FALSE;
            }
        }
    }
}

