/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.discovery.ClassUtil;
import com.sas.services.discovery.RB;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.io.Serializable;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceTypes
implements Serializable {
    private static final long serialVersionUID = -1875751467882826814L;
    private Class[] _classesOrInterfaces;
    private final Set<Class> _classes = new HashSet<Class>(5);
    private final Set<Class> _interfaces = new HashSet<Class>(5);

    public ServiceTypes() {
    }

    public ServiceTypes(Class[] classesOrInterfaces) {
        this();
        this.setClasses(classesOrInterfaces);
    }

    public ServiceTypes(Class classOrInterface) {
        this();
        this.setClass(classOrInterface);
    }

    public Iterator<Class> iteratorClasses() {
        return this._classes.iterator();
    }

    public Iterator<Class> iteratorInterfaces() {
        return this._interfaces.iterator();
    }

    public final void setClass(Class classOrInterface) {
        ClassUtil.determineIfsAndSuperClasses(this._interfaces, this._classes, classOrInterface);
    }

    public final void setClasses(Class[] classesOrInterfaces) {
        this.clear();
        int numItems = classesOrInterfaces != null ? classesOrInterfaces.length : 0;
        this._classesOrInterfaces = new Class[numItems];
        if (numItems > 0) {
            System.arraycopy(classesOrInterfaces, 0, this._classesOrInterfaces, 0, numItems);
            Class aClass = null;
            for (int i = 0; i < numItems; ++i) {
                aClass = classesOrInterfaces[i];
                if (aClass.isInterface()) {
                    this._interfaces.add(aClass);
                    continue;
                }
                this._classes.add(aClass);
            }
        }
    }

    public final Class[] getClasses() {
        Class[] classesOrInterfaces = new Class[]{};
        if (this._classesOrInterfaces != null) {
            int numItems = this._classesOrInterfaces.length;
            classesOrInterfaces = new Class[numItems];
            System.arraycopy(this._classesOrInterfaces, 0, classesOrInterfaces, 0, numItems);
        }
        return classesOrInterfaces;
    }

    public final void clear() {
        this._interfaces.removeAll(this._interfaces);
        this._classes.removeAll(this._classes);
    }

    public boolean contains(ServiceTypes requiredClassesOrInterfaces) {
        boolean foundMatch = this.containsRequiredInterfaces(requiredClassesOrInterfaces);
        if (foundMatch) {
            foundMatch = this.containsRequiredClasses(requiredClassesOrInterfaces);
        }
        return foundMatch;
    }

    private boolean containsRequiredInterfaces(ServiceTypes reqSvcCapabilities) {
        boolean foundMatch = true;
        Iterator<Class> iteratorRequired = reqSvcCapabilities.iteratorInterfaces();
        Iterator<Class> iteratorSupported = null;
        if (iteratorRequired.hasNext()) {
            foundMatch = false;
            Class reqClass = null;
            Class thisClass = null;
            while (iteratorRequired.hasNext()) {
                foundMatch = false;
                reqClass = iteratorRequired.next();
                iteratorSupported = this.iteratorInterfaces();
                while (iteratorSupported.hasNext()) {
                    thisClass = iteratorSupported.next();
                    if (thisClass != reqClass) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                break;
            }
        }
        return foundMatch;
    }

    private boolean containsRequiredClasses(ServiceTypes reqSvcCapabilities) {
        boolean foundMatch = true;
        Class reqClass = null;
        Class thisClass = null;
        Iterator<Class> iteratorRequired = reqSvcCapabilities.iteratorClasses();
        if (iteratorRequired.hasNext()) {
            foundMatch = false;
            while (iteratorRequired.hasNext()) {
                foundMatch = false;
                reqClass = iteratorRequired.next();
                Iterator<Class> iteratorSupported = this.iteratorClasses();
                while (iteratorSupported.hasNext()) {
                    thisClass = iteratorSupported.next();
                    if (thisClass != reqClass) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                break;
            }
        }
        return foundMatch;
    }

    public final boolean areSatisfiedBy(RemoteServiceInterface serviceIf) {
        boolean satisfies = true;
        Iterator<Class> iterator = this.iteratorClasses();
        Class aClass = null;
        while (iterator.hasNext()) {
            aClass = iterator.next();
            if (aClass.isInstance(serviceIf)) continue;
            satisfies = false;
            break;
        }
        if (satisfies) {
            iterator = this.iteratorInterfaces();
            while (iterator.hasNext()) {
                aClass = iterator.next();
                if (aClass.isInstance(serviceIf)) continue;
                satisfies = false;
                break;
            }
        }
        return satisfies;
    }

    public void add(Class svcCapability) {
        if (svcCapability.isInterface()) {
            this._interfaces.add(svcCapability);
        } else {
            this._classes.add(svcCapability);
        }
    }

    public final String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        StringBuilder sb = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceTypes.toStringHeader.fmt.txt", (Object)lineSeparator));
        Iterator<Class> iterator = this.iteratorClasses();
        int i = 1;
        while (iterator.hasNext()) {
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"IterationItem.fmt.txt", (Object)i++, (Object)iterator.next(), (Object)lineSeparator));
        }
        iterator = this.iteratorInterfaces();
        while (iterator.hasNext()) {
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"IterationItem.fmt.txt", (Object)i++, (Object)iterator.next(), (Object)lineSeparator));
        }
        if (i == 1) {
            sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceTypes.noDesiredCapabilitiesWereSpecified.fmt.txt", (Object)lineSeparator));
        }
        sb.append('}');
        return sb.toString();
    }
}

