/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceNotAvailableException
extends ServiceException
implements Serializable {
    private static final long serialVersionUID = 9080982357342216906L;
    private static final String DEFAULT_MESSAGE = RB.getStringResource("ServiceNotAvailableException.defaultMessage.txt");
    private ServiceTemplate _serviceTemplate = null;

    public ServiceNotAvailableException() {
        super(DEFAULT_MESSAGE);
    }

    public ServiceNotAvailableException(String message) {
        super(message);
    }

    public ServiceNotAvailableException(Throwable throwable, String message) {
        super(throwable, message);
    }

    public ServiceNotAvailableException(ServiceTemplate serviceTemplate) {
        this(DEFAULT_MESSAGE);
        this.setServiceTemplate(serviceTemplate);
    }

    public ServiceNotAvailableException(String message, ServiceTemplate serviceTemplate) {
        this(message);
        this.setServiceTemplate(serviceTemplate);
    }

    public ServiceNotAvailableException(ServiceTemplate serviceTemplate, Throwable throwable) {
        this(throwable, DEFAULT_MESSAGE);
        this.setServiceTemplate(serviceTemplate);
    }

    public ServiceNotAvailableException(String message, Throwable throwable, ServiceTemplate serviceTemplate) {
        this(throwable, message);
        this.setServiceTemplate(serviceTemplate);
    }

    private final void setServiceTemplate(ServiceTemplate serviceTemplate) {
        this._serviceTemplate = serviceTemplate;
    }

    public final ServiceTemplate getServiceTemplate() {
        return this._serviceTemplate;
    }

    public final String getMessage() {
        String superMsg = super.getMessage();
        String serviceTemplateMsg = this._serviceTemplate != null ? this._serviceTemplate.toString() : null;
        String msg = serviceTemplateMsg != null ? Message.format((ResourceBundle)RB.getResources(), (String)"ServiceNotAvailableException.msg.fmt.txt", (Object)superMsg, (Object)serviceTemplateMsg) : superMsg;
        return msg;
    }
}

