/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.GUID;
import com.sas.services.InitializationException;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfiguration;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RMIBinding;
import com.sas.services.discovery.HostAttribute;
import com.sas.services.discovery.IdAttribute;
import com.sas.services.discovery.IsRemotelyAccessibleAttribute;
import com.sas.services.discovery.JVMAttribute;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceDeploymentAttribute;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.ReflectionUtil;
import com.sas.text.Message;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceDiscoveryConfiguration
extends ServiceConfiguration
implements ServiceDiscoveryConfigurationInterface {
    private static final long serialVersionUID = 1451216715494895240L;
    private static final int STRING_BUFFER_LENGTH = 200;
    private String _serviceFactory;
    private boolean _isDelegateRegistrationEnabled;
    private final String _runtimeId = GUID.newGUID();
    private static final transient Map<InetAddress, Set<String>> INETADDRESS_MAP = new HashMap<InetAddress, Set<String>>(5);
    private String _discoveryId;
    private transient Map<ServiceComponentAttribute, Set<MetadataAttribute>> _map = new HashMap<ServiceComponentAttribute, Set<MetadataAttribute>>(2);
    private String _repositoryId;
    private Class[] _serviceTypes;
    private ServiceAttributeInterface[] _serviceAttributes;
    private List<ServiceAttributeInterface> _serviceAttributesList = new ArrayList<ServiceAttributeInterface>(5);
    private final Set<RMIBinding> _rmiBindings = new HashSet<RMIBinding>(1);
    private ServiceComponentAttribute _serviceComponentAttribute;
    private String _serviceGroup;
    private ServiceDeploymentAttribute _serviceDeploymentAttribute;
    private final JVMAttribute _jvmAttribute = new JVMAttribute();

    public ServiceDiscoveryConfiguration() throws ServiceException {
        this.addJVMAttribute();
        this.addHostAttributes();
    }

    public ServiceDiscoveryConfiguration(boolean isRegistrationEnabled, Class[] serviceTypes, ServiceAttributeInterface[] serviceAttributes, String repositoryId) throws ServiceException {
        this();
        this.setDelegateRegistrationEnabled(isRegistrationEnabled);
        this.setServiceTypes(serviceTypes);
        if (serviceAttributes != null) {
            int numItems = serviceAttributes.length;
            for (int i = 0; i < numItems; ++i) {
                this.addServiceAttribute(serviceAttributes[i]);
            }
        }
        this.setRepositoryId(repositoryId);
    }

    @Override
    public final String getDiscoveryId() {
        String discoveryId = null;
        ServiceComponentAttribute serviceComponentAttribute = this.getServiceComponentAttribute();
        if (serviceComponentAttribute != null && "ServiceComponent".equals(serviceComponentAttribute.elementType) && "ABC1212121212".equals(serviceComponentAttribute.classIdentifier)) {
            discoveryId = serviceComponentAttribute.runtimeId;
        }
        return discoveryId;
    }

    @Override
    public final String getRepositoryId() {
        return this._repositoryId;
    }

    public final void setRepositoryId(String repositoryId) {
        this._repositoryId = repositoryId;
    }

    @Override
    public final boolean isDelegateRegistrationEnabled() {
        return this._isDelegateRegistrationEnabled;
    }

    @Override
    public final void setDelegateRegistrationEnabled(boolean isRegistrationEnabled) {
        this._isDelegateRegistrationEnabled = isRegistrationEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class[] getServiceTypes() {
        Class[] serviceTypes = null;
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            int numTypes = this._serviceTypes != null ? this._serviceTypes.length : 0;
            serviceTypes = new Class[numTypes];
            if (numTypes > 0) {
                System.arraycopy(this._serviceTypes, 0, serviceTypes, 0, numTypes);
            }
        }
        return serviceTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setServiceTypes(Class[] serviceTypes) {
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            int numItems = serviceTypes != null ? serviceTypes.length : 0;
            this._serviceTypes = new Class[numItems];
            System.arraycopy(serviceTypes, 0, this._serviceTypes, 0, numItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServiceAttributeInterface[] getServiceAttributes() {
        ServiceAttributeInterface[] serviceAttributes = null;
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            if (this._serviceAttributesList == null) {
                int numAttrs = this._serviceAttributes != null ? this._serviceAttributes.length : 0;
                this._serviceAttributesList = new ArrayList<ServiceAttributeInterface>(numAttrs);
                for (int i = 0; i < numAttrs; ++i) {
                    this._serviceAttributesList.add(this._serviceAttributes[i]);
                }
            }
            serviceAttributes = this._serviceAttributesList.toArray(new ServiceAttributeInterface[this._serviceAttributesList.size()]);
        }
        return serviceAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setServiceAttributes(ServiceAttributeInterface[] serviceAttributes) {
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            this._serviceAttributesList.clear();
            int numAttrs = serviceAttributes != null ? serviceAttributes.length : 0;
            for (int i = 0; i < numAttrs; ++i) {
                this._serviceAttributesList.add(serviceAttributes[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServiceAttributes(ServiceAttributeInterface[] serviceAttributes) {
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            int numItems = serviceAttributes != null ? serviceAttributes.length : 0;
            for (int i = 0; i < numItems; ++i) {
                this.addServiceAttribute(serviceAttributes[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addServiceAttributes(List<ServiceAttributeInterface> serviceAttributesList) {
        if (serviceAttributesList.size() > 0) {
            ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
            synchronized (serviceDiscoveryConfiguration) {
                Iterator<ServiceAttributeInterface> iter = serviceAttributesList.iterator();
                while (iter.hasNext()) {
                    this._serviceAttributesList.add(iter.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean addServiceAttribute(ServiceAttributeInterface serviceAttribute) {
        boolean wasAdded = false;
        if (serviceAttribute == null) {
            throw new IllegalArgumentException();
        }
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            wasAdded = this._serviceAttributesList.add(serviceAttribute);
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeServiceAttribute(ServiceAttributeInterface serviceAttribute) {
        boolean wasRemoved = false;
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            Set<MetadataAttribute> set;
            wasRemoved = this._serviceAttributesList.remove(serviceAttribute);
            if (wasRemoved && this._map != null && (set = this._map.get(serviceAttribute)) != null && set.size() > 0) {
                this._serviceAttributesList.removeAll(set);
            }
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceComponentAttribute(ServiceComponentAttribute serviceComponentAttribute) {
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            Set<MetadataAttribute> set;
            this._serviceComponentAttribute = serviceComponentAttribute;
            this.addServiceAttribute(serviceComponentAttribute);
            if (this._map == null) {
                this._map = new HashMap<ServiceComponentAttribute, Set<MetadataAttribute>>(2);
            }
            if ((set = this._map.get(serviceComponentAttribute)) == null) {
                set = new HashSet<MetadataAttribute>(2);
            }
            this._map.put(serviceComponentAttribute, set);
            MetadataAttribute metadataAttribute = new MetadataAttribute(serviceComponentAttribute.id, serviceComponentAttribute.name, serviceComponentAttribute.elementType, serviceComponentAttribute.classIdentifier);
            this.addServiceAttribute(metadataAttribute);
            set.add(metadataAttribute);
            String runtimeID = serviceComponentAttribute.runtimeId;
            if (runtimeID != null) {
                metadataAttribute = new MetadataAttribute(runtimeID, serviceComponentAttribute.name, serviceComponentAttribute.elementType, serviceComponentAttribute.classIdentifier);
                this.addServiceAttribute(metadataAttribute);
                set.add(metadataAttribute);
            }
        }
    }

    @Override
    public final ServiceComponentAttribute getServiceComponentAttribute() {
        return this._serviceComponentAttribute;
    }

    @Override
    public final void setServiceGroup(String serviceGroup) {
        this._serviceGroup = serviceGroup;
    }

    @Override
    public final String getServiceGroup() {
        return this._serviceGroup;
    }

    @Override
    public final String getJVMId() {
        String id = null;
        if (this._jvmAttribute != null) {
            id = this._jvmAttribute.id;
        }
        return id;
    }

    @Override
    public void setServiceDeploymentAttribute(ServiceDeploymentAttribute serviceDeploymentAttribute) {
        this._serviceDeploymentAttribute = serviceDeploymentAttribute;
        this.addServiceAttribute(serviceDeploymentAttribute);
    }

    @Override
    public final ServiceDeploymentAttribute getServiceDeploymentAttribute() {
        return this._serviceDeploymentAttribute;
    }

    @Override
    public final String getServiceFactory() {
        String serviceFactory = "";
        if (this._serviceFactory != null) {
            serviceFactory = this._serviceFactory;
        }
        return serviceFactory;
    }

    @Override
    public final void setServiceFactory(String serviceFactory) throws InitializationException {
        if (serviceFactory == null || serviceFactory.trim().length() <= 0) {
            throw new InitializationException(RB.getStringResource("ServiceDiscoveryConfiguration.nonNullServiceFactoryRequired.ex.txt"));
        }
        this._serviceFactory = serviceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addRMIBinding(RMIBinding rmiBinding) {
        boolean wasAdded = false;
        if (rmiBinding != null) {
            ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
            synchronized (serviceDiscoveryConfiguration) {
                wasAdded = this._rmiBindings.add(rmiBinding);
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unbindFromRMIRegistry() {
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            if (this._rmiBindings.size() > 0) {
                for (RMIBinding rmiBinding : this._rmiBindings) {
                    rmiBinding.unbind();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        this.unbindFromRMIRegistry();
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            if (this._rmiBindings != null) {
                this._rmiBindings.clear();
            }
            if (this._serviceAttributesList != null) {
                this._serviceAttributesList.clear();
            }
            this._serviceTypes = null;
        }
        this._isDelegateRegistrationEnabled = false;
        this._repositoryId = null;
        this._serviceFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        String noneNewLine = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.noneNewLine.fmt.txt", (Object)lineSeparator);
        String closingBraceNewLine = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.closingBraceNewLine.fmt.txt", (Object)lineSeparator);
        StringBuilder sb = new StringBuilder(200);
        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.toStringOpen.fmt.txt", (Object)lineSeparator));
        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.toStringsFactory.fmt.txt", (Object)this._serviceFactory, (Object)lineSeparator));
        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.toStringExposeRemotely.fmt.txt", (Object)this._isDelegateRegistrationEnabled, (Object)lineSeparator));
        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.toStringDiscoveryId.fmt.txt", (Object)this._runtimeId, (Object)lineSeparator));
        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.toStringRepositoryId.fmt.txt", (Object)this._repositoryId, (Object)lineSeparator));
        sb.append(RB.getStringResource("ServiceDiscoveryConfiguration.toStringServiceTypes.txt"));
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            if (this._serviceTypes != null) {
                int numElements = this._serviceTypes.length;
                if (numElements > 0) {
                    sb.append(lineSeparator);
                    for (int i = 0; i < numElements; ++i) {
                        sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDiscoveryConfiguration.serviceTypeNewLine.fmt.txt", (Object)this._serviceTypes[i], (Object)lineSeparator));
                    }
                } else {
                    sb.append(noneNewLine);
                }
            } else {
                sb.append(noneNewLine);
            }
            sb.append(RB.getStringResource("ServiceDiscoveryConfiguration.toStringServiceAttributes.txt"));
            ServiceDiscoveryConfiguration serviceDiscoveryConfiguration2 = this;
            synchronized (serviceDiscoveryConfiguration2) {
                if (this._serviceAttributesList.size() > 0) {
                    sb.append(lineSeparator);
                    for (ServiceAttributeInterface serviceAttribute : this._serviceAttributesList) {
                        sb.append(lineSeparator);
                        sb.append(ReflectionUtil.toStringFields(serviceAttribute));
                    }
                } else {
                    sb.append(noneNewLine);
                }
            }
        }
        sb.append(closingBraceNewLine);
        sb.append(closingBraceNewLine);
        return sb.toString();
    }

    private final void addJVMAttribute() {
        this.addServiceAttribute(this._jvmAttribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addHostAttributes() throws ServiceException {
        block7: {
            SocketException ex = null;
            try {
                for (Map.Entry<InetAddress, Set<String>> mapEntry : ServiceDiscoveryConfiguration.getInetAddressMap().entrySet()) {
                    InetAddress inetAddress = mapEntry.getKey();
                    for (String hostName : mapEntry.getValue()) {
                        if ("localhost".equals(hostName)) continue;
                        this.addServiceAttribute(new HostAttribute(inetAddress));
                    }
                }
            }
            catch (SocketException e) {
                ex = e;
            }
            finally {
                if (ex == null) break block7;
                throw new ServiceException(ex, RB.getStringResource("ServiceDiscoveryConfiguration.addInetAddressAttributes.ex.txt"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<InetAddress, Set<String>> getInetAddressMap() throws SocketException {
        Map<InetAddress, Set<String>> inetAddressMap = INETADDRESS_MAP;
        Map<InetAddress, Set<String>> map = INETADDRESS_MAP;
        synchronized (map) {
            if (INETADDRESS_MAP.size() == 0) {
                NetworkInterface networkInterface = null;
                InetAddress inetAddress = null;
                Enumeration<InetAddress> inetAddresses = null;
                String hostName = null;
                HashSet<String> hostNameSet = null;
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements()) {
                    networkInterface = netInterfaces.nextElement();
                    inetAddresses = networkInterface.getInetAddresses();
                    hostNameSet = new HashSet<String>(5);
                    while (inetAddresses.hasMoreElements()) {
                        inetAddress = inetAddresses.nextElement();
                        hostName = inetAddress.getHostName();
                        if ("localhost".equals(hostName)) continue;
                        hostNameSet.add(hostName);
                    }
                    INETADDRESS_MAP.put(inetAddress, hostNameSet);
                }
            }
        }
        return inetAddressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        int hashCodeId = IdAttribute.class.getName().hashCode();
        int hashCodeIsRemotelyAccessible = IsRemotelyAccessibleAttribute.class.getName().hashCode();
        int hashCodeMetadata = MetadataAttribute.class.getName().hashCode();
        int hashCodeServiceComponent = ServiceComponentAttribute.class.getName().hashCode();
        int hashCodeJVM = JVMAttribute.class.getName().hashCode();
        int hashCodeServiceDeployment = ServiceDeploymentAttribute.class.getName().hashCode();
        ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = this;
        synchronized (serviceDiscoveryConfiguration) {
            ServiceAttributeInterface[] serviceAttributes = this.getServiceAttributes();
            int numAttrs = serviceAttributes.length;
            ArrayList<ServiceAttributeInterface> sp4ServiceAttributes = new ArrayList<ServiceAttributeInterface>(numAttrs + 1);
            ServiceAttributeInterface serviceAttribute = null;
            int attributeHash = 0;
            for (int i = 0; i < numAttrs; ++i) {
                serviceAttribute = serviceAttributes[i];
                attributeHash = serviceAttribute.getClass().getName().hashCode();
                if (hashCodeId == attributeHash || hashCodeIsRemotelyAccessible == attributeHash || hashCodeMetadata == attributeHash) {
                    sp4ServiceAttributes.add(serviceAttribute);
                    continue;
                }
                if (hashCodeJVM == attributeHash) {
                    JVMAttribute jvmAttribute = (JVMAttribute)serviceAttribute;
                    sp4ServiceAttributes.add(new IdAttribute(jvmAttribute.id, jvmAttribute.idType));
                    continue;
                }
                if (hashCodeServiceDeployment == attributeHash) {
                    ServiceDeploymentAttribute serviceDeploymentAttribute = (ServiceDeploymentAttribute)serviceAttribute;
                    sp4ServiceAttributes.add(new MetadataAttribute(serviceDeploymentAttribute.id, serviceDeploymentAttribute.name, serviceDeploymentAttribute.elementType, serviceDeploymentAttribute.classIdentifier));
                    continue;
                }
                if (hashCodeServiceComponent != attributeHash) continue;
                ServiceComponentAttribute serviceComponentAttribute = (ServiceComponentAttribute)serviceAttribute;
                String runtimeID = serviceComponentAttribute.runtimeId;
                if (runtimeID == null) continue;
                this._discoveryId = runtimeID;
            }
            this._serviceAttributes = sp4ServiceAttributes.toArray(new ServiceAttributeInterface[sp4ServiceAttributes.size()]);
        }
        stream.defaultWriteObject();
    }
}

