/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProxy;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.FindServiceInterface;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.RemoteDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import com.sas.text.Message;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class RemoteDiscoveryServiceProxy
extends ServiceProxy
implements RemoteDiscoveryServiceInterface,
Serializable {
    private static final long serialVersionUID = 1453316715494895240L;

    public RemoteDiscoveryServiceProxy(DiscoveryServiceInterface discoveryService) throws InitializationException {
        super(discoveryService);
    }

    @Override
    public final RemoteServiceInterface getServiceProxy() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteServiceInterface findServiceUsingId(String serviceId) throws ServiceException, ServiceNotAvailableException, RemoteException {
        RemoteServiceInterface discoveredService = null;
        DiscoveryServiceInterface service = this.getDiscoveryService();
        RemoteException remoteException = null;
        if (service == null) {
            throw new ServiceNotAvailableException();
        }
        try {
            discoveredService = service.findServiceUsingId(serviceId);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null && (service = this.findDiscoveryService()) != null) {
                discoveredService = this.findDiscoveryService().findServiceUsingId(serviceId);
            }
        }
        if (discoveredService == null) {
            throw new ServiceNotAvailableException();
        }
        return discoveredService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RemoteServiceInterface findService(ServiceTemplate serviceTemplate) throws ServiceException, ServiceNotAvailableException, RemoteException {
        RemoteServiceInterface discoveredService = null;
        DiscoveryServiceInterface service = this.getDiscoveryService();
        RemoteException remoteException = null;
        if (service == null) {
            throw new ServiceNotAvailableException();
        }
        try {
            discoveredService = service.findService(serviceTemplate);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                discoveredService = this.findDiscoveryService().findService(serviceTemplate);
            }
        }
        if (discoveredService == null) {
            throw new ServiceNotAvailableException(serviceTemplate);
        }
        return discoveredService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Services findServices(ServiceTemplate serviceTemplate, int maxNumMatches, Services discoveredServices) throws ServiceException, ServiceNotAvailableException, RemoteException {
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service == null) {
            throw new ServiceNotAvailableException();
        }
        Services services = null;
        if (discoveredServices != null && maxNumMatches > discoveredServices.size()) {
            RemoteException remoteException = null;
            try {
                boolean isAvailable = false;
                try {
                    service.sameEntity(this);
                    isAvailable = true;
                }
                catch (RemoteException e) {
                    remoteException = e;
                    LogManager.getLogger(RemoteDiscoveryServiceProxy.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"RDSP.sameEntity.ex.fmt.log", (Object)this.getEntityKey()), (Throwable)remoteException);
                }
                if (isAvailable) {
                    services = service.findServices(serviceTemplate, maxNumMatches, new Services());
                }
            }
            catch (ConnectException e) {
                remoteException = e;
                LogManager.getLogger(RemoteDiscoveryServiceProxy.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"RDSP.connect.ex.fmt.log", (Object)this.getEntityKey()), (Throwable)e);
            }
            catch (NoSuchObjectException e) {
                remoteException = e;
                LogManager.getLogger(RemoteDiscoveryServiceProxy.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"RDSP.noSuchObject.ex.fmt.log", (Object)this.getEntityKey()), (Throwable)e);
            }
            finally {
                if (remoteException != null && (service = this.findDiscoveryService()) != null) {
                    services = this.findDiscoveryService().findServices(serviceTemplate, maxNumMatches, new Services());
                }
            }
        }
        if (services == null || services.size() <= 0) {
            throw new ServiceNotAvailableException(serviceTemplate);
        }
        discoveredServices.addAll(services);
        return discoveredServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryDelegate(FindServiceInterface serviceFinder) throws RemoteException {
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service != null) {
            RemoteException remoteException = null;
            try {
                service.addDiscoveryDelegate(serviceFinder);
            }
            catch (ConnectException e) {
                remoteException = e;
            }
            catch (NoSuchObjectException e) {
                remoteException = e;
            }
            finally {
                if (remoteException != null) {
                    try {
                        service = this.findDiscoveryService();
                        if (service == null) {
                            throw remoteException;
                        }
                        service.addDiscoveryDelegate(serviceFinder);
                    }
                    catch (ServiceException ex) {
                        throw remoteException;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDiscoveryDelegate(FindServiceInterface serviceFinder) throws RemoteException {
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service != null) {
            RemoteException remoteException = null;
            try {
                service.removeDiscoveryDelegate(serviceFinder);
            }
            catch (ConnectException e) {
                remoteException = e;
            }
            catch (NoSuchObjectException e) {
                remoteException = e;
            }
            finally {
                if (remoteException != null) {
                    try {
                        service = this.findDiscoveryService();
                        if (service == null) {
                            throw remoteException;
                        }
                        service.removeDiscoveryDelegate(serviceFinder);
                    }
                    catch (ServiceException ex) {
                        throw remoteException;
                    }
                }
            }
        }
    }

    @Override
    public Iterator<RemoteServiceInterface> getRemoteServices() throws RemoteException {
        Iterator iterator = null;
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service != null) {
            try {
                if (this.isProxyToRemoteService()) {
                    iterator = new ArrayList(0).iterator();
                }
            }
            catch (ClassCastException e) {
                iterator = service.getRemoteServices();
            }
        }
        if (iterator == null) {
            iterator = new ArrayList(0).iterator();
        }
        return iterator;
    }

    @Override
    public final Iterator<RemoteServiceInterface> getLocalServices() throws RemoteException {
        Iterator iterator = null;
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service != null) {
            try {
                if (service instanceof Proxy || service instanceof RemoteObject) {
                    iterator = new ArrayList(0).iterator();
                }
            }
            catch (ClassCastException e) {
                iterator = service.getLocalServices();
            }
        }
        if (iterator == null) {
            iterator = new ArrayList(0).iterator();
        }
        return iterator;
    }

    @Override
    public void removeService(RemoteServiceInterface serviceIf) throws RemoteException {
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service != null && !this.isProxyToRemoteService()) {
            service.removeService(serviceIf);
        }
    }

    @Override
    public final Iterator<FindServiceInterface> getDiscoverers() throws RemoteException {
        Iterator iterator = null;
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service != null) {
            try {
                if (service instanceof Proxy || service instanceof RemoteObject) {
                    iterator = new ArrayList(0).iterator();
                }
            }
            catch (ClassCastException e) {
                iterator = service.getDiscoverers();
            }
        }
        if (iterator == null) {
            iterator = new ArrayList(0).iterator();
        }
        return iterator;
    }

    @Override
    public void addService(RemoteServiceInterface serviceIf) throws ServiceException, RemoteException {
        DiscoveryServiceInterface service = this.getDiscoveryService();
        if (service != null && !this.isProxyToRemoteService()) {
            service.addService(serviceIf);
        }
    }

    private final DiscoveryServiceInterface getDiscoveryService() {
        return (DiscoveryServiceInterface)this.getService();
    }

    private final DiscoveryServiceInterface findDiscoveryService() throws ServiceException, RemoteException {
        return (DiscoveryServiceInterface)this.findRemoteService();
    }
}

