/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.FindServiceInterface;
import com.sas.services.discovery.RB;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.Services;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class RegistryDiscoveryService
implements FindServiceInterface {
    private final EntityKeyInterface _entityKey = new DefaultEntityKeyImpl();
    private Registry _registry;

    public RegistryDiscoveryService() {
    }

    public RegistryDiscoveryService(Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.nullRegistry.ex.txt"));
        }
        this.setRegistry(registry);
    }

    public void setRegistry(Registry registry) {
        this._registry = registry;
    }

    public void destroy() {
        this._registry = null;
    }

    @Override
    public RemoteServiceInterface findService(ServiceTemplate serviceTemplate) throws RemoteException, ServiceException, ServiceNotAvailableException {
        RemoteServiceInterface o;
        RemoteServiceInterface service = null;
        Services boundServices = this.findServicesInRegistry(serviceTemplate, 1);
        if (boundServices.size() > 0 && (o = boundServices.iterator().next()) instanceof RemoteServiceInterface) {
            service = o;
        }
        if (service == null) {
            throw new ServiceNotAvailableException(serviceTemplate);
        }
        return service;
    }

    @Override
    public RemoteServiceInterface findServiceUsingId(String runtimeServiceId) throws RemoteException, ServiceException, ServiceNotAvailableException {
        return this.findService(new ServiceTemplate(new Class[]{RemoteServiceInterface.class}, new ServiceAttributeInterface[]{new ServiceComponentAttribute(null, null, runtimeServiceId)}));
    }

    @Override
    public Services findServices(ServiceTemplate serviceTemplate, int maxNumMatches, Services services) throws RemoteException, ServiceException, ServiceNotAvailableException {
        Services boundServices = this.findServicesInRegistry(serviceTemplate, maxNumMatches);
        if (boundServices.size() == 0) {
            throw new ServiceNotAvailableException(serviceTemplate);
        }
        services.addAll(boundServices);
        return services;
    }

    private Services findServicesInRegistry(ServiceTemplate serviceTemplate, int maxNumMatches) throws RemoteException, ServiceException, ServiceNotAvailableException {
        Services services = new Services();
        if (this._registry != null) {
            String[] bindNames = this._registry.list();
            int numNames = bindNames.length;
            String bindName = null;
            RemoteServiceInterface remoteService = null;
            int numMatches = 0;
            for (int i = 0; i < numNames; ++i) {
                bindName = bindNames[i];
                try {
                    remoteService = (RemoteServiceInterface)this._registry.lookup(bindName);
                    if (!serviceTemplate.isSatisfiedBy(remoteService)) continue;
                    if (services.add(remoteService)) {
                        ++numMatches;
                    }
                    if (numMatches != maxNumMatches) continue;
                    break;
                }
                catch (ClassCastException e) {
                    continue;
                }
                catch (NotBoundException e) {
                    // empty catch block
                }
            }
        }
        return services;
    }

    public String getEntityKey() throws RemoteException {
        return this._entityKey.getEntityKey();
    }

    public boolean sameEntity(EntityKeyInterface entity) throws RemoteException {
        return this._entityKey.sameEntity(entity);
    }

    public void setEntityKey(String key) throws RemoteException, IllegalStateException {
        this._entityKey.setEntityKey(key);
    }
}

