/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.discovery;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.discovery.LookupPolicyInterface;
import com.sas.services.discovery.RB;
import com.sas.text.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class LookupPolicyAttempts
implements LookupPolicyInterface {
    private final Map<String, Data> _lookupRequestMap = new HashMap<String, Data>(5);
    private static final int DEFAULT_MAX_NUM_ATTEMPTS = 1;
    private static final long DEFAULT_ATTEMPT_INTERVAL_MSEC = 500L;
    private long _attemptIntervalInMsec = 500L;
    private int _maxNumAttempts = 1;

    public LookupPolicyAttempts() {
        this(1, 500L);
    }

    public LookupPolicyAttempts(int maxNumAttempts, long attemptIntervalInMsec) {
        this.setPauseInterval(attemptIntervalInMsec);
        this.setMaxNumAttempts(maxNumAttempts);
    }

    public final void setMaxNumAttempts(int maxNumAttempts) {
        this._maxNumAttempts = maxNumAttempts >= 0 ? maxNumAttempts : 1;
    }

    public final void setPauseInterval(long attemptIntervalInMsec) {
        this._attemptIntervalInMsec = attemptIntervalInMsec > 0L ? attemptIntervalInMsec : 500L;
    }

    @Override
    public final void serviceLookupInitiated(String serviceLookupRequestId) {
        if (serviceLookupRequestId != null) {
            Data data = new Data();
            this._lookupRequestMap.put(serviceLookupRequestId, data);
        }
    }

    @Override
    public final void serviceLookupTerminated(String serviceLookupRequestId) {
        if (serviceLookupRequestId != null) {
            this._lookupRequestMap.remove(serviceLookupRequestId);
        }
    }

    @Override
    public final boolean isOKToRetryLookup(String serviceLookupRequestId) {
        boolean isOKToRetryLookup = false;
        if (serviceLookupRequestId != null) {
            try {
                Data data = this._lookupRequestMap.get(serviceLookupRequestId);
                int numAttempts = data.getNumAttempts();
                if (numAttempts < this._maxNumAttempts) {
                    long startTime = data.getStartTime();
                    long timeToNextAttempt = (long)numAttempts * this._attemptIntervalInMsec;
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    long timeToWaitInMsec = timeToNextAttempt - elapsedTime;
                    isOKToRetryLookup = this.waitUntilNextInterval(timeToWaitInMsec, data);
                }
            }
            catch (ClassCastException e) {
                isOKToRetryLookup = false;
            }
        }
        return isOKToRetryLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean waitUntilNextInterval(long timeToWaitInMsec, Data data) {
        boolean isOKToRetryLookup = false;
        try {
            if (timeToWaitInMsec > 0L) {
                try {
                    Thread.sleep(timeToWaitInMsec);
                }
                catch (InterruptedException e) {
                    Logger logger = LogManager.getLogger(LookupPolicyAttempts.class);
                    if (logger.isDebugEnabled()) {
                        logger.debug(RB.getStringResource("LookupPolicyAttempts.retryLookup.txt"));
                    }
                }
            }
        }
        finally {
            data.incrementAttempts();
            isOKToRetryLookup = true;
        }
        return isOKToRetryLookup;
    }

    public final String toString() {
        String value = "";
        try {
            value = Message.format((ResourceBundle)RB.getResources(), (String)"LookupPolicyAttempts.toString.fmt.txt", (Object)this._maxNumAttempts, (Object)this._attemptIntervalInMsec);
        }
        catch (MissingResourceException e) {
            value = "";
        }
        return value;
    }

    @SASScope
    private static class Data {
        private final long _startTime = System.currentTimeMillis();
        private int _numAttempts;

        private Data() {
        }

        public final int getNumAttempts() {
            return this._numAttempts;
        }

        public final long getStartTime() {
            return this._startTime;
        }

        public final void incrementAttempts() {
            ++this._numAttempts;
        }
    }
}

