/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment.ioc;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractDeploymentStrategy;
import com.sas.services.deployment.DeploymentDescriptorContext;
import com.sas.services.deployment.ioc.OMRDeploymentContext;
import com.sas.services.deployment.ioc.RB;
import com.sas.services.deployment.ioc.URLDeploymentContext;
import com.sas.text.Message;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DeploymentContextFactory {
    public static final String PROPERTYNAME_STRATEGYCLASSNAME = "strategyClassName";
    public static final String PROPERTYNAME_CONTAINER = "container";
    public static final String CONTAINER_JBOSSMC = "jbossmc";
    public static final String CONTAINER_SPRING = "spring";
    public static final String STRATEGY_JBOSSMC = "com.sas.services.deployment.ioc.jbossmc.DeploymentStrategy";
    public static final String STRATEGY_SPRING = "com.sas.services.deployment.ioc.spring.DeploymentStrategy";

    private DeploymentContextFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentDescriptorContext createDeploymentContext(Properties properties, ClassLoader classLoader) throws ServiceException {
        DeploymentDescriptorContext deploymentContext;
        block25: {
            deploymentContext = null;
            if (properties == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyProperties.ex.txt"));
            }
            if (classLoader == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyClassLoader.ex.txt"));
            }
            String deploymentStrategyClassName = properties.getProperty(PROPERTYNAME_STRATEGYCLASSNAME);
            if (deploymentStrategyClassName == null) {
                String containerType = properties.getProperty(PROPERTYNAME_CONTAINER);
                if (CONTAINER_SPRING.equals(containerType)) {
                    deploymentStrategyClassName = STRATEGY_SPRING;
                } else if (CONTAINER_JBOSSMC.equals(containerType)) {
                    deploymentStrategyClassName = STRATEGY_JBOSSMC;
                }
            }
            if (deploymentStrategyClassName == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"DCF.specifyContainer.ex.fmt.txt", (Object)PROPERTYNAME_CONTAINER, (Object)CONTAINER_JBOSSMC, (Object)CONTAINER_SPRING, (Object)AbstractDeploymentStrategy.class.getName(), (Object)PROPERTYNAME_STRATEGYCLASSNAME));
            }
            Exception exception = null;
            try {
                Class<?> clazz = classLoader.loadClass(deploymentStrategyClassName);
                Constructor<?> ctor = clazz.getConstructor(Properties.class);
                AbstractDeploymentStrategy strategy = (AbstractDeploymentStrategy)ctor.newInstance(properties);
                if (properties.getProperty("url") != null) {
                    deploymentContext = new URLDeploymentContext(strategy);
                } else if (properties.getProperty("omr_repository") != null) {
                    deploymentContext = new OMRDeploymentContext(strategy);
                }
            }
            catch (ClassNotFoundException e) {
                exception = e;
                return exception;
            }
            catch (InstantiationException e) {
                exception = e;
                return exception;
            }
            catch (IllegalAccessException e) {
                exception = e;
                return exception;
            }
            catch (NoSuchMethodException e) {
                exception = e;
                return exception;
            }
            catch (IllegalArgumentException e) {
                exception = e;
                return exception;
            }
            catch (InvocationTargetException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block25;
                throw new ServiceException(exception, RB.getStringResource("DCF.createContext.ex.txt"));
            }
        }
        return deploymentContext;
    }

    public static final boolean isValidContainerType(String containerType) {
        return CONTAINER_JBOSSMC.equals(containerType) || CONTAINER_SPRING.equals(containerType);
    }
}

