/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.AbstractServiceConfigFactory;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class URLServiceConfigFactory
extends AbstractServiceConfigFactory {
    private String _metadataXML;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLServiceConfigFactory(URL url) throws ServiceException {
        block13: {
            super(null);
            if (url == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.url.ex.txt"));
            }
            InputStream inputStream = null;
            IOException exception = null;
            try {
                inputStream = url.openStream();
                this._metadataXML = AbstractMetadataSource.getStringFromInputSource(inputStream);
            }
            catch (IOException e) {
                exception = e;
                return exception;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(URLServiceConfigFactory.class).error(RB.getStringResource("IOStream.close.ex.log"), (Throwable)e);
                    }
                }
                if (exception == null) break block13;
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.url.ex.fmt.txt", (Object)url.getPath()));
            }
        }
    }

    @Override
    public ServiceConfigurationInterface createConfigForService(String softwareComponentName, String treeName, String serviceComponentName, MetadataSourceInterface metadataSource, boolean isRMIExportEnabled) throws ServiceException {
        return this.createServiceConfiguration(softwareComponentName, treeName, serviceComponentName, metadataSource, isRMIExportEnabled);
    }

    public ServiceConfigurationInterface createServiceConfiguration(String softwareComponentName, String treeName, String serviceComponentName, MetadataSourceInterface metadataSource, boolean isRMIExportEnabled) throws ServiceException {
        return this.createServiceConfig(this._metadataXML, softwareComponentName, treeName, serviceComponentName, metadataSource, isRMIExportEnabled);
    }

    @Override
    public void destroy() {
        this._metadataXML = null;
        super.destroy();
    }
}

