/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.DependentServicesException;
import com.sas.services.deployment.DeploymentGroupDeleter;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RegistryDeleter;
import com.sas.services.deployment.ServiceDeleter;
import com.sas.services.deployment.ServiceDeploymentDeleter;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceDeployments {
    private static final int STRING_LENGTH_SEARCH_FILTER = 150;
    private static final int TYPICAL_NUM_SERVICES = 20;
    private static final int OMI_FLAGS = 396;
    private static final String CLASS_IDENTIFIER = "@ClassIdentifier='";
    private static final int MAX_LENGTH_NAME = 60;

    private ServiceDeployments() {
    }

    public static final void deleteDeployment(SoftwareComponent softwareComponent) throws ServiceException, IllegalArgumentException {
        new ServiceDeploymentDeleter(softwareComponent).delete();
    }

    public static final void deleteGroup(Tree tree, boolean isValidatingServiceDependencies) throws ServiceException, DependentServicesException, IllegalArgumentException {
        new DeploymentGroupDeleter(tree, isValidatingServiceDependencies).delete();
    }

    public static final void deleteService(ServiceComponent serviceComponent, boolean isValidatingDependentServices) throws DependentServicesException, ServiceException, IllegalArgumentException {
        new ServiceDeleter(serviceComponent, isValidatingDependentServices).delete();
    }

    public static final void deleteRegistry(DeployedComponent deployedComponent) throws ServiceException, IllegalArgumentException {
        new RegistryDeleter(deployedComponent).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void verifyNoDependentServices(List<Tree> trees) throws DependentServicesException {
        block10: {
            Throwable exception = null;
            try {
                ArrayList membersList = new ArrayList(20);
                int numItems = trees.size();
                Tree tree = null;
                for (int i = 0; i < numItems; ++i) {
                    tree = trees.get(i);
                    membersList.addAll(tree.getMembers(true));
                }
                for (Object o2 : membersList) {
                    if (!(o2 instanceof ServiceComponent)) continue;
                    ServiceComponent serviceComponent = (ServiceComponent)o2;
                    for (Object o2 : serviceComponent.getUsedByComponents()) {
                        ServiceComponent serviceComponentDep;
                        if (!(o2 instanceof ServiceComponent) || membersList.contains(serviceComponentDep = (ServiceComponent)o2)) continue;
                        throw new DependentServicesException((DeployedComponent)serviceComponent, (DeployedComponent)serviceComponentDep);
                    }
                }
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block10;
                throw new DependentServicesException(exception, exception.getLocalizedMessage(), null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SoftwareComponent getSoftwareComponent(Root root) throws IllegalArgumentException {
        SoftwareComponent softwareComponent;
        block12: {
            softwareComponent = null;
            if (root == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyMetadata.ex.txt"));
            }
            Throwable exception = null;
            try {
                if (root instanceof DeployedComponent) {
                    Iterator iter = ((DeployedComponent)root).getTrees().iterator();
                    while (iter.hasNext() && (softwareComponent = ServiceDeployments.getSoftwareComponentForGroup((Tree)iter.next())) == null) {
                    }
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (ClassCastException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block12;
                throw new IllegalArgumentException(exception);
            }
        }
        return softwareComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SoftwareComponent getSoftwareComponentForGroup(Tree serviceDeploymentGroup) throws IllegalArgumentException {
        SoftwareComponent softwareComponent;
        block9: {
            softwareComponent = null;
            if (serviceDeploymentGroup != null) {
                Throwable exception = null;
                try {
                    SoftwareComponent nextSoftwareComponent2 = null;
                    String classIdentifier = null;
                    for (SoftwareComponent nextSoftwareComponent2 : serviceDeploymentGroup.getSoftwareComponents()) {
                        classIdentifier = nextSoftwareComponent2.getClassIdentifier();
                        if (!"abc7fd619d0dc4a3:2c1e6b:f6cd2758ff:-7ffb".equals(classIdentifier) && !"ABC1234567890".equals(classIdentifier)) continue;
                        softwareComponent = nextSoftwareComponent2;
                        break;
                    }
                }
                catch (MdException e) {
                    exception = e;
                    return exception;
                }
                catch (RemoteException e) {
                    exception = e;
                    return exception;
                }
                finally {
                    if (exception == null) break block9;
                    throw new IllegalArgumentException(exception);
                }
            }
        }
        return softwareComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set<ServiceComponent> getServices(SoftwareComponent softwareComponent) {
        HashSet<ServiceComponent> services = new HashSet<ServiceComponent>(20);
        Throwable exception = null;
        try {
            if (softwareComponent != null) {
                AssociationList serviceDeployments = softwareComponent.getSoftwareTrees(true);
                for (Tree tree : serviceDeployments) {
                    for (CMetadata o : tree.getMembers(true)) {
                        if (!(o instanceof ServiceComponent)) continue;
                        services.add((ServiceComponent)o);
                    }
                }
            }
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (MdException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                LogManager.getLogger(CorePlatformServices.class).error(RB.getStringResource("ServiceDeployments.getDeployments.ex.txt"), exception);
            }
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set<ServiceComponent> getServices2(SoftwareComponent softwareComponent) throws ServiceException {
        HashSet<ServiceComponent> services;
        block10: {
            services = new HashSet<ServiceComponent>(20);
            Throwable exception = null;
            try {
                if (softwareComponent != null) {
                    AssociationList serviceDeployments = softwareComponent.getSoftwareTrees(true);
                    for (Tree tree : serviceDeployments) {
                        for (CMetadata o : tree.getMembers(true)) {
                            if (!(o instanceof ServiceComponent)) continue;
                            services.add((ServiceComponent)o);
                        }
                    }
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block10;
                throw new ServiceException(exception, RB.getStringResource("ServiceDeployments.getDeployments.ex.txt"));
            }
        }
        return services;
    }

    public static final SoftwareComponent getServiceDeployment(MdStore mdStore, String repositoryID, String serviceDeploymentName) throws ServiceException {
        SoftwareComponent softwareComponent = null;
        HashSet<String> serviceDeploymentNames = new HashSet<String>(1);
        serviceDeploymentNames.add(serviceDeploymentName);
        List<SoftwareComponent> list = ServiceDeployments.getServiceDeployments(mdStore, repositoryID, serviceDeploymentNames);
        int numItems = list.size();
        if (numItems > 0) {
            softwareComponent = list.get(0);
            if (numItems > 1) {
                LogManager.getLogger(ServiceDeployments.class).warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployments.getServiceDeployment.ex.fmt.txt", (Object)serviceDeploymentName, (Object)repositoryID));
            }
        }
        return softwareComponent;
    }

    public static final SoftwareComponent getServiceDeploymentForID(MdStore mdStore, String repositoryID, String serviceDeploymentID) throws ServiceException {
        HashSet<String> serviceDeploymentIDs = new HashSet<String>(1);
        serviceDeploymentIDs.add(serviceDeploymentID);
        List<SoftwareComponent> list = ServiceDeployments.getServiceDeploymentsUsingID(mdStore, repositoryID, serviceDeploymentIDs);
        return list.size() == 1 ? list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<SoftwareComponent> getServiceDeployments(MdStore mdStore, String repositoryID, Set<String> serviceDeploymentsToFind) throws ServiceException {
        List softwareComponentList;
        block8: {
            softwareComponentList = null;
            Throwable ex = null;
            try {
                String options = "<XMLSelect search=\"*" + ServiceDeployments.getSearchFilter(serviceDeploymentsToFind) + "\"/><Templates><SoftwareComponent Id=\"\" Name=\"\" /></Templates>";
                softwareComponentList = mdStore.getFactory().getOMIUtil().getMetadataObjectsSubset(mdStore, repositoryID, "SoftwareComponent", 396, options);
            }
            catch (MdException e) {
                ex = e;
                return ex;
            }
            catch (RemoteException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block8;
                String msg = RB.getStringResource("ServiceDeployments.getDeployments.ex.txt");
                LogManager.getLogger(ServiceDeployments.class).error(msg, ex);
                throw new ServiceException(ex, msg);
            }
        }
        if (null == softwareComponentList) {
            softwareComponentList = new ArrayList(0);
        }
        return softwareComponentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<SoftwareComponent> getServiceDeploymentsUsingID(MdStore mdStore, String repositoryID, Set<String> serviceDeploymentIDsToFind) throws ServiceException {
        List softwareComponentList;
        block8: {
            softwareComponentList = null;
            Throwable ex = null;
            try {
                String options = "<XMLSelect search=\"*" + ServiceDeployments.getSearchFilterForIDs(serviceDeploymentIDsToFind) + "\"/><Templates><SoftwareComponent Id=\"\" Name=\"\" /></Templates>";
                softwareComponentList = mdStore.getFactory().getOMIUtil().getMetadataObjectsSubset(mdStore, repositoryID, "SoftwareComponent", 396, options);
            }
            catch (MdException e) {
                ex = e;
                return ex;
            }
            catch (RemoteException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block8;
                String msg = RB.getStringResource("ServiceDeployments.getDeployments.ex.txt");
                LogManager.getLogger(ServiceDeployments.class).error(msg, ex);
                throw new ServiceException(ex, msg);
            }
        }
        if (null == softwareComponentList) {
            softwareComponentList = Collections.emptyList();
        }
        return softwareComponentList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ServiceComponent getServiceComponent(MdStore mdStore, String repositoryID, String softwareComponentName, String groupName, String serviceComponentName) throws ServiceException {
        ServiceComponent serviceComponent;
        block8: {
            serviceComponent = null;
            Throwable ex = null;
            try {
                HashSet<String> serviceDeploymentsToFind = new HashSet<String>(1);
                serviceDeploymentsToFind.add(softwareComponentName);
                String options = "<XMLSelect search=\"*" + ServiceDeployments.getSearchFilterForService(softwareComponentName, groupName, serviceComponentName) + "\"/><Templates><ServiceComponent Id=\"\" Name=\"\"><StoredConfigurations><TextStore StoredText=\"\"/></StoredConfigurations></ServiceComponent></Templates>";
                List list = mdStore.getFactory().getOMIUtil().getMetadataObjectsSubset(mdStore, repositoryID, "ServiceComponent", 396, options);
                if (list.size() > 0) {
                    serviceComponent = (ServiceComponent)list.get(0);
                }
            }
            catch (MdException e) {
                ex = e;
                return ex;
            }
            catch (RemoteException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block8;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployments.getService.ex.fmt.txt", (Object)serviceComponentName, (Object)groupName, (Object)softwareComponentName);
                LogManager.getLogger(ServiceDeployments.class).error(msg, ex);
                throw new ServiceException(ex, msg);
            }
        }
        return serviceComponent;
    }

    private static final String getSearchFilterForService(String softwareComponentName, String groupName, String serviceComponentName) {
        StringBuilder sb = new StringBuilder(150);
        sb.append("[@ClassIdentifier='");
        sb.append("ABC1212121212");
        sb.append("' and @Name='");
        sb.append(serviceComponentName);
        sb.append("'][Trees/*[@Name='");
        sb.append(groupName);
        sb.append("']/SoftwareComponents/*[@Name='");
        sb.append(softwareComponentName);
        sb.append("']]");
        return sb.toString();
    }

    private static final String getSearchFilter(Set<String> serviceDeploymentsToFind) {
        String search = "";
        String nextDeploymentName = null;
        try {
            StringBuilder sb = new StringBuilder(150);
            sb.append("[(");
            sb.append(CLASS_IDENTIFIER);
            sb.append("ABC1234567890");
            sb.append("' or ");
            sb.append(CLASS_IDENTIFIER);
            sb.append("abc7fd619d0dc4a3:2c1e6b:f6cd2758ff:-7ffb");
            sb.append("')");
            if (serviceDeploymentsToFind != null && serviceDeploymentsToFind.size() > 0) {
                Iterator<String> iter = serviceDeploymentsToFind.iterator();
                String serviceDeploymentName = null;
                sb.append(" and (");
                while (iter.hasNext()) {
                    nextDeploymentName = iter.next();
                    serviceDeploymentName = ServiceDeployments.validateServiceDeploymentName(nextDeploymentName);
                    if (serviceDeploymentName == null) continue;
                    sb.append("@Name='");
                    sb.append(serviceDeploymentName);
                    sb.append('\'');
                    if (!iter.hasNext()) continue;
                    sb.append(" or ");
                }
                sb.append(")]");
            } else {
                sb.append(']');
            }
            search = sb.toString();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployments.expectedDeploymentName.ex.fmt.txt", nextDeploymentName));
        }
        return search;
    }

    private static final String getSearchFilterForIDs(Set<String> serviceDeploymentIDsToFind) {
        String search = "";
        StringBuilder sb = new StringBuilder(150);
        sb.append("[(");
        sb.append(CLASS_IDENTIFIER);
        sb.append("ABC1234567890");
        sb.append("' or ");
        sb.append(CLASS_IDENTIFIER);
        sb.append("abc7fd619d0dc4a3:2c1e6b:f6cd2758ff:-7ffb");
        sb.append("')");
        if (serviceDeploymentIDsToFind != null && serviceDeploymentIDsToFind.size() > 0) {
            sb.append(" and (");
            Iterator<String> iter = serviceDeploymentIDsToFind.iterator();
            while (iter.hasNext()) {
                String serviceDeploymentID = iter.next();
                if (serviceDeploymentID == null) continue;
                sb.append("@Id='");
                sb.append(serviceDeploymentID);
                sb.append('\'');
                if (!iter.hasNext()) continue;
                sb.append(" or ");
            }
            sb.append(")]");
        } else {
            sb.append(']');
        }
        search = sb.toString();
        return search;
    }

    public static final String[] getNames(IOMI iomi, String repositoryID) throws ServiceException {
        if (iomi == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.IOMI.ex.txt"));
        }
        if (repositoryID == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.repositoryID.ex.txt"));
        }
        String inXML = Message.format((String)"<GetMetadataObjects><Reposid>{0}</Reposid><Type>SoftwareComponent</Type><Objects/><Ns>SAS</Ns><Flags>{1,number,integer}</Flags><Options>{2}<Templates>{3}</Templates></Options></GetMetadataObjects>", (Object)repositoryID, (Object)396, (Object)ServiceDeployments.getSearchFilter(null), (Object)ServiceDeployments.getSearchTemplate(false));
        Document doc = ServiceDeployments.doRequest(iomi, inXML);
        NodeList elements = doc.getElementsByTagName("SoftwareComponent");
        int numItems = elements.getLength();
        ArrayList<String> list = new ArrayList<String>(numItems);
        try {
            Element child = null;
            String name = null;
            for (int i = 0; i < numItems; ++i) {
                child = (Element)elements.item(i);
                name = child.getAttribute("Name");
                if (name == null || Strings.equal((String)name.trim(), (String)"", (boolean)false, (boolean)false)) continue;
                list.add(name);
            }
        }
        catch (ClassCastException e) {
            throw new ServiceException(e);
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    private static final Document doRequest(IOMI iomi, String inXML) throws ServiceException {
        Document document = null;
        try {
            StringHolder strholder = new StringHolder();
            int rv = iomi.DoRequest(inXML, strholder);
            if (rv != 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployments.doRequestReturnCode.ex.fmt.txt", (Object)inXML, (Object)rv));
            }
            document = XMLUtil.convertStringToDocument(strholder.value);
        }
        catch (GenericError e) {
            throw new ServiceException(e, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployments.doRequest.ex.fmt.txt", (Object)inXML, (Object)e.getMessage()));
        }
        return document;
    }

    private static final String getSearchTemplate(boolean isIncludingDeploymentGroups) {
        return isIncludingDeploymentGroups ? "<SoftwareComponent><SoftwareTrees><Tree/></SoftwareTrees></SoftwareComponent>" : "<SoftwareComponent/>";
    }

    static String validateServiceDeploymentName(String newServiceDeploymentName) throws IllegalArgumentException {
        if (newServiceDeploymentName == null) {
            throw new IllegalArgumentException(RB.getStringResource("ServiceDeployments.invalidSoftwareComponentName.ex.txt"));
        }
        String newName = newServiceDeploymentName.trim();
        int length = newName.length();
        if (length > 60) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.metadataNameTooLong.ex.fmt.txt", (Object)newName, (Object)60));
        }
        if (length == 0) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployments.expectedDeploymentName.ex.fmt.txt", (Object)newName));
        }
        return newName;
    }
}

