/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.CLIOptionsConfig;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.CLIOptionsServiceDeployment;
import com.sas.services.deployment.DeploymentGroupDeleter;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RootDeleter;
import com.sas.services.deployment.ServiceDeployments;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceDeploymentDeleter
extends RootDeleter {
    private static final String DELETE_TEMPLATE_SOFTWARECOMPONENT = "<SoftwareComponent><Properties/><SoftwareTrees/></SoftwareComponent>";

    public ServiceDeploymentDeleter(SoftwareComponent softwareComponent) {
        super((Root)softwareComponent);
    }

    @Override
    protected void addDeletionTemplates(Map<String, String> deletionTemplateMap) throws ServiceException {
        super.addDeletionTemplates(deletionTemplateMap);
        deletionTemplateMap.put("SoftwareComponent", DELETE_TEMPLATE_SOFTWARECOMPONENT);
        deletionTemplateMap.put("Property", RootDeleter.getDeleteTemplateProperty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteMetadataObjects(List<CMetadata> deletedObjects) throws ServiceException {
        block10: {
            Throwable exception = null;
            String name = null;
            try {
                SoftwareComponent softwareComponent = (SoftwareComponent)this.getRoot();
                name = softwareComponent.getName();
                AssociationList list = softwareComponent.getSoftwareTrees();
                int numTrees = list.size();
                Tree[] trees = new Tree[numTrees];
                trees = list.toArray(trees);
                Tree tree = null;
                for (int i = 0; i < numTrees; ++i) {
                    tree = trees[i];
                    if (tree == null) continue;
                    new DeploymentGroupDeleter(tree, false).delete();
                }
                super.deleteMetadataObjects(deletedObjects);
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (ClassCastException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block10;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentDeleter.delete.ex.fmt.txt", (Object)name);
                LogManager.getLogger(ServiceDeploymentDeleter.class).error(msg, exception);
                throw new ServiceException(exception, msg);
            }
        }
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtRuntimeExceptionHandler(true));
        ServiceException exception = null;
        try {
            ServiceDeploymentDeleter.deleteDeployment(args);
        }
        catch (ServiceException e) {
            exception = e;
            LogManager.getLogger(ServiceDeploymentDeleter.class).error("Unable to delete foundation services deployment.", (Throwable)((Object)e));
        }
        System.exit(exception == null ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDeployment(String[] args) throws ServiceException {
        Logger logger;
        block33: {
            logger = LogManager.getLogger(ServiceDeploymentDeleter.class);
            MdStore mdStore = null;
            CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
            Option cliOptionMetaServer = cliOptionsMeta.createOptionMetaServer();
            Option cliOptionMetaPort = cliOptionsMeta.createOptionPort();
            Option cliOptionMetaRepository = cliOptionsMeta.createOptionRepository();
            Option cliOptionIsPrompting = new CLIOptionsConfig().createOptionIsPrompting();
            CLIOptionsServiceDeployment cliDeployment = new CLIOptionsServiceDeployment();
            Option optionDeploymentID = cliDeployment.createOptionDeploymentID();
            Option optionDeploymentName = cliDeployment.createOptionDeploymentName();
            Option cliOptionMetaUser = cliOptionsMeta.createOptionUser();
            Option cliOptionMetaPassword = cliOptionsMeta.createOptionPassword();
            Option cliOptionMetaPasswordOnStdin = cliOptionsMeta.createOptionPasswordOnStdin();
            Option cliOptionSecPackageList = cliOptionsMeta.createOptionSecPackageList();
            Option cliOptionMetaSPN = cliOptionsMeta.createOptionSPN();
            String serviceDeploymentName = null;
            String serviceDeploymentID = null;
            String metaPass = null;
            ServiceException exception = null;
            try {
                Options options = new Options();
                options.addOption(cliOptionMetaServer);
                options.addOption(cliOptionMetaPort);
                options.addOption(cliOptionMetaRepository);
                options.addOption(cliOptionIsPrompting);
                OptionGroup optionGroupServiceDeployment = new OptionGroup();
                optionGroupServiceDeployment.setRequired(true);
                optionGroupServiceDeployment.addOption(optionDeploymentID);
                optionGroupServiceDeployment.addOption(optionDeploymentName);
                options.addOptionGroup(optionGroupServiceDeployment);
                OptionGroup optionGroupCx = new OptionGroup();
                optionGroupCx.setRequired(true);
                optionGroupCx.addOption(cliOptionMetaUser);
                optionGroupCx.addOption(cliOptionSecPackageList);
                options.addOptionGroup(optionGroupCx);
                options.addOption(cliOptionMetaPassword);
                options.addOption(cliOptionMetaPasswordOnStdin);
                options.addOption(cliOptionMetaSPN);
                boolean isValid = false;
                CommandLine cmdLine = null;
                try {
                    cmdLine = new DefaultParser().parse(options, args);
                    String metaHost = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionServer());
                    String metaPort = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPort());
                    String secPackageList = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSecPackageList());
                    String metaSPN = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionSPN());
                    String metaUser = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionUser());
                    boolean isPasswordOnStdin = Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPasswordOnStdin()));
                    metaPass = cmdLine.getOptionValue(cliOptionsMeta.getNameOfOptionPassword());
                    serviceDeploymentID = cmdLine.getOptionValue(optionDeploymentID.getOpt());
                    serviceDeploymentName = cmdLine.getOptionValue(optionDeploymentName.getOpt());
                    boolean bl = isValid = !(!cmdLine.hasOption(cliOptionsMeta.getNameOfOptionServer()) || !cmdLine.hasOption(cliOptionsMeta.getNameOfOptionPort()) || !cmdLine.hasOption(cliOptionsMeta.getNameOfOptionRepository()) || serviceDeploymentID == null && serviceDeploymentName == null || (metaUser == null || !isPasswordOnStdin && metaPass == null) && secPackageList == null);
                    if (isValid) {
                        HashMap<String, String> metaOptions = new HashMap<String, String>(7);
                        String optionName = cliOptionsMeta.getNameOfOptionServer();
                        metaOptions.put(optionName, metaHost);
                        optionName = cliOptionsMeta.getNameOfOptionPort();
                        metaOptions.put(optionName, metaPort);
                        optionName = cliOptionsMeta.getNameOfOptionRepository();
                        String repositoryName = cmdLine.getOptionValue(optionName);
                        metaOptions.put(optionName, repositoryName);
                        if (secPackageList != null) {
                            optionName = cliOptionsMeta.getNameOfOptionSecPackageList();
                            metaOptions.put(optionName, secPackageList);
                            optionName = cliOptionsMeta.getNameOfOptionSPN();
                            metaOptions.put(optionName, metaSPN);
                        } else {
                            String dashOptionName;
                            optionName = cliOptionsMeta.getNameOfOptionUser();
                            metaOptions.put(optionName, metaUser);
                            if (isPasswordOnStdin && (metaPass = CLIOptionsConfig.getOptionValueFromSystemIn(dashOptionName = '-' + cliOptionsMeta.getNameOfOptionPassword(), Boolean.parseBoolean(cmdLine.getOptionValue(cliOptionIsPrompting.getOpt())) ? Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.fmt.txt", (Object)dashOptionName) : null, null)) == null) {
                                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"CLIOptionsMeta.specifyMetaPass.ex.fmt.txt", (Object)cliOptionsMeta.getNameOfOptionPassword()));
                            }
                        }
                        if (metaPass != null) {
                            metaOptions.put(cliOptionsMeta.getNameOfOptionPassword(), metaPass);
                        }
                        mdStore = AbstractMetadataSource.createMdStore(false, metaOptions, new Environment());
                        if (null != serviceDeploymentID) {
                            ServiceDeploymentDeleter.deleteServiceDeploymentForID(mdStore, repositoryName, serviceDeploymentID);
                        } else if (null != serviceDeploymentName) {
                            ServiceDeploymentDeleter.deleteServiceDeployment(mdStore, repositoryName, serviceDeploymentName);
                        }
                    }
                }
                finally {
                    metaPass = null;
                    if (!isValid) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(ServiceDeploymentDeleter.class.getName());
                        sb.append(" -");
                        sb.append(cliOptionMetaServer.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaServer.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaPort.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPort.getArgName());
                        sb.append("> -");
                        sb.append(cliOptionMetaRepository.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaRepository.getArgName());
                        sb.append("> (-");
                        sb.append(optionDeploymentID.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentID.getArgName());
                        sb.append("> | -");
                        sb.append(optionDeploymentName.getOpt());
                        sb.append(" <");
                        sb.append(optionDeploymentName.getArgName());
                        sb.append(">) [-");
                        sb.append(cliOptionMetaUser.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaUser.getArgName());
                        sb.append("> [[-");
                        sb.append(cliOptionMetaPassword.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPassword.getArgName());
                        sb.append(">] | [-");
                        sb.append(cliOptionMetaPasswordOnStdin.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaPasswordOnStdin.getArgName());
                        sb.append(">]] | [-");
                        sb.append(cliOptionSecPackageList.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionSecPackageList.getArgName());
                        sb.append("> [-");
                        sb.append(cliOptionMetaSPN.getOpt());
                        sb.append(" <");
                        sb.append(cliOptionMetaSPN.getArgName());
                        sb.append(">]]");
                        new HelpFormatter().printHelp(sb.toString(), options);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                exception = new ServiceException(e);
            }
            catch (ParseException e) {
                exception = new ServiceException(e);
                logger.error("The command line arguments are invalid.", (Throwable)e);
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                if (mdStore != null) {
                    try {
                        mdStore.getFactory().dispose();
                    }
                    catch (RemoteException e) {
                        logger.error(RB.getStringResource("ServiceConfigurationFactory.disposeFactory.ex.log"), (Throwable)e);
                    }
                }
                if (exception == null) break block33;
                logger.error(RB.getStringResource("ServiceDeploymentDeleter.main.ex.txt"), (Throwable)((Object)exception));
                throw exception;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(RB.getStringResource("ServiceConfigInstaller.returningFromMain.log"));
        }
    }

    public static void deleteServiceDeployment(MdStore mdStore, String repositoryName, String serviceDeploymentName) throws ServiceException {
        try {
            MdFactory mdFactory = mdStore.getFactory();
            String metadataRepositoryID = AbstractServiceDeployment.getRepositoryID(mdFactory, repositoryName);
            if (metadataRepositoryID == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.repositoryName.ex.fmt.txt", (Object)repositoryName));
            }
            SoftwareComponent softwareComponent = ServiceDeployments.getServiceDeployment(mdStore, metadataRepositoryID, serviceDeploymentName);
            if (softwareComponent == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.setSoftwareComponent.ex.fmt.txt", (Object)serviceDeploymentName, (Object)repositoryName));
            }
            new ServiceDeploymentDeleter(softwareComponent).delete();
            Logger logger = LogManager.getLogger(ServiceDeploymentDeleter.class);
            if (logger.isInfoEnabled()) {
                logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentDeleter.delete.fmt.txt", (Object)serviceDeploymentName, (Object)repositoryName, (Object)metadataRepositoryID));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    public static void deleteServiceDeploymentForID(MdStore mdStore, String repositoryName, String serviceDeploymentID) throws ServiceException {
        try {
            MdFactory mdFactory = mdStore.getFactory();
            String metadataRepositoryID = AbstractServiceDeployment.getRepositoryID(mdFactory, repositoryName);
            if (metadataRepositoryID == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.repositoryName.ex.fmt.txt", (Object)repositoryName));
            }
            SoftwareComponent softwareComponent = ServiceDeployments.getServiceDeploymentForID(mdStore, metadataRepositoryID, serviceDeploymentID);
            if (softwareComponent == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.setSoftwareComponent.ex.fmt.txt", (Object)serviceDeploymentID, (Object)repositoryName));
            }
            new ServiceDeploymentDeleter(softwareComponent).delete();
            Logger logger = LogManager.getLogger(ServiceDeploymentDeleter.class);
            if (logger.isInfoEnabled()) {
                logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentDeleter.delete.fmt.txt", (Object)serviceDeploymentID, (Object)repositoryName, (Object)metadataRepositoryID));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }
}

