/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceAggregateConfig;
import com.sas.services.ServiceConfigDocument;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.ServiceFactoryInterface;
import com.sas.services.ServiceProfile;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerUsage;
import com.sas.services.deployment.MergePolicyAdd;
import com.sas.services.deployment.MergePolicyReplace;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentExporter;
import com.sas.services.deployment.ServiceDeployments;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceDeployment
extends AbstractServiceDeployment {
    private SoftwareComponent _softwareComponent;
    private Map<String, Data> _interfaceToServiceComponent;

    public ServiceDeployment(SoftwareComponent softwareComponent) throws ServiceException, RemoteException {
        super(softwareComponent.getName());
        this.setSoftwareComponent(softwareComponent);
    }

    public ServiceDeployment(String repositoryName, String softwareComponentName, MdStore mdStore) throws ServiceException {
        super(softwareComponentName);
        if (mdStore == null) {
            throw new IllegalArgumentException("IllegalArgument.specifyObjectStore.ex.txt");
        }
        this.setSoftwareComponent(mdStore, repositoryName, softwareComponentName);
    }

    private void setSoftwareComponent(MdStore mdStore, String repositoryName, String softwareComponentName) throws ServiceException {
        HashSet<String> softwareComponentNames = new HashSet<String>(1);
        softwareComponentNames.add(softwareComponentName);
        List<SoftwareComponent> list = ServiceDeployments.getServiceDeployments(mdStore, ServiceDeployment.getRepositoryID(mdStore, repositoryName), softwareComponentNames);
        if (list.size() == 0) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.setSoftwareComponent.ex.fmt.txt", (Object)softwareComponentName, (Object)repositoryName));
        }
        this._softwareComponent = list.get(0);
        this._interfaceToServiceComponent = this.determineServices(this._softwareComponent);
    }

    private void setSoftwareComponent(SoftwareComponent softwareComponent) throws ServiceException {
        this._interfaceToServiceComponent = this.determineServices(softwareComponent);
    }

    public Set<ServiceComponent> getServiceComponents() {
        HashSet<Data> set = new HashSet<Data>(this._interfaceToServiceComponent.values());
        HashSet<ServiceComponent> serviceComponentSet = new HashSet<ServiceComponent>(set.size());
        for (Data data : set) {
            serviceComponentSet.add(data.getServiceComponent());
        }
        return serviceComponentSet;
    }

    public ServiceComponent getServiceComponent(String serviceGroupName, String serviceName) throws ServiceException {
        ServiceComponent serviceComponent;
        block7: {
            if (serviceGroupName == null) {
                throw new IllegalArgumentException("IllegalArgument.specifyServiceGroupName.ex.txt");
            }
            if (serviceName == null) {
                throw new IllegalArgumentException("IllegalArgument.specifyServiceName.ex.txt");
            }
            serviceComponent = null;
            try {
                Tree tree2 = null;
                for (Tree tree2 : this._softwareComponent.getSoftwareTrees()) {
                    if (!serviceGroupName.equals(tree2.getName())) continue;
                    for (CMetadata cMetadata : tree2.getMembers()) {
                        if (!serviceName.equals(cMetadata.getName()) || !(cMetadata instanceof ServiceComponent)) continue;
                        serviceComponent = (ServiceComponent)cMetadata;
                        break block7;
                    }
                    break;
                }
            }
            catch (MdException e) {
                throw new ServiceException(e);
            }
            catch (RemoteException e) {
                throw new ServiceException(e);
            }
        }
        return serviceComponent;
    }

    public boolean isAccessibleToRemoteClients() throws ServiceException {
        boolean isRemotelyAccessible = false;
        try {
            ServiceComponent serviceComponent = null;
            Iterator<ServiceComponent> iter = this.getServiceComponents().iterator();
            while (iter.hasNext() && !(isRemotelyAccessible = (serviceComponent = iter.next()).getIsRemotelyAccessible() == 1)) {
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("ServiceDeployment.isRemotelyAccessible.ex.txt"));
        }
        return isRemotelyAccessible;
    }

    public ServiceComponent getServiceComponent(String serviceInterfaceClassName) throws ServiceException {
        ServiceComponent serviceComponent = null;
        Data data = this.getData(serviceInterfaceClassName);
        if (data != null) {
            serviceComponent = data.getServiceComponent();
        }
        return serviceComponent;
    }

    private Data getData(String serviceInterfaceClassName) throws ServiceException {
        Data data = this._interfaceToServiceComponent.get(serviceInterfaceClassName);
        if (data == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.getData.ex.fmt.txt", (Object)this.getSoftwareComponentName(), (Object)serviceInterfaceClassName));
        }
        return data;
    }

    public void exportServiceConfiguration(File file, ServiceComponent serviceComponent, boolean isExportingBaseConfig, List<String> appConfigNames) throws ServiceException {
        ServiceAggregateConfig serviceAggConfig = new ServiceAggregateConfig(serviceComponent);
        ServiceFactoryInterface serviceFactory = serviceAggConfig.getServiceFactory();
        AbstractServiceComponentConfig serviceConfig = null;
        ServiceConfigDocument serviceConfigDocument2 = null;
        ServiceProfile serviceProfile = serviceFactory.getServiceProfile();
        if (isExportingBaseConfig) {
            serviceConfigDocument2 = serviceAggConfig.getBaseServiceConfig();
            serviceConfig = serviceProfile.createConfig(serviceConfigDocument2.getConfigName(), serviceConfigDocument2.getDocument());
        }
        for (ServiceConfigDocument serviceConfigDocument2 : serviceAggConfig.getServiceConfigDocuments(appConfigNames)) {
            if (serviceConfig == null) {
                serviceConfig = serviceProfile.createConfig(serviceConfigDocument2.getConfigName(), serviceConfigDocument2.getDocument());
                continue;
            }
            serviceConfig.mergeConfiguration(serviceProfile.createConfig(serviceConfigDocument2.getConfigName(), serviceConfigDocument2.getDocument()));
        }
        serviceConfig.writeServiceConfigToFile(file);
    }

    public Property installServiceConfiguration(String configName, String configDesc, File configFile, ServiceComponent serviceComponent) throws ServiceException {
        return this.installServiceConfigurationUsingPolicy(configName, configFile, serviceComponent, new MergePolicyAdd());
    }

    public Property installServiceConfigurationUsingPolicy(String configName, File configFile, ServiceComponent serviceComponent, MergePolicy mergePolicy) throws ServiceException {
        if (mergePolicy == null) {
            throw new IllegalArgumentException("A merge policy must be specified.");
        }
        this.validateServiceComponent(serviceComponent);
        Property property = null;
        try {
            property = this.installServiceConfiguration(configName, configFile, serviceComponent, AbstractServiceDeployment.getServiceFactory(serviceComponent.getFactoryClassName()), mergePolicy);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return property;
    }

    @Override
    public boolean installServiceConfiguration(String configName, String configDesc, File configFile, String serviceInterfaceClassName) throws ServiceException {
        return this.installServiceConfig(configName, configDesc, configFile, serviceInterfaceClassName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property installServiceConfig(String configName, String configDesc, File configFile, String serviceInterfaceClassName) throws ServiceException {
        Property property;
        block12: {
            Data data = this.getData(serviceInterfaceClassName);
            property = null;
            Object serviceComponentName = null;
            FileNotFoundException exception = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(configFile);
                ServiceProfile serviceProfile = data.getServiceFactory().getServiceProfile();
                AbstractServiceComponentConfig config = serviceProfile.createConfig(configName, XMLUtil.convertStreamToDocument(fis));
                ServiceDeployment.addConsumerToServiceConfig(config, configName);
                property = this.installServiceConfiguration(serviceProfile, data.getServiceComponent(), config, new MergePolicyAdd());
            }
            catch (FileNotFoundException e) {
                exception = e;
                return exception;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(AbstractServiceComponentConfig.class).error(RB.getStringResource("IO.close.ex.txt"), (Throwable)e);
                    }
                }
                if (exception == null) break block12;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.installServiceConfigurationInterface.ex.fmt.txt", (Object)configName, serviceComponentName, (Object)serviceInterfaceClassName, (Object)this.getSoftwareComponentName()));
            }
        }
        return property;
    }

    public boolean isConfigInstalled(String configName, String serviceInterfaceClassName) throws ServiceException {
        ServiceComponent serviceComponent = this.getServiceComponent(serviceInterfaceClassName);
        if (serviceComponent == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.getServiceComponentForInterface.ex.fmt.txt", (Object)this.getSoftwareComponentName(), (Object)serviceInterfaceClassName));
        }
        return this.isConfigInstalled(configName, serviceComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigInstalled(String configName, ServiceComponent serviceComponent) throws ServiceException {
        boolean isInstalled;
        block9: {
            isInstalled = false;
            Throwable exception = null;
            String serviceComponentName = null;
            try {
                serviceComponentName = serviceComponent.getName();
                Property nextProperty = null;
                Iterator<Property> iter = ServiceDeployment.getServiceConfigProperties(serviceComponent).iterator();
                if (iter.hasNext()) {
                    nextProperty = iter.next();
                    ServiceFactoryInterface serviceFactory = AbstractServiceDeployment.getServiceFactory(serviceComponent.getFactoryClassName());
                    ServiceProfile serviceProfile = serviceFactory.getServiceProfile();
                    AbstractServiceComponentConfig serviceConfig = serviceProfile.createServiceConfigForProperty(nextProperty);
                    ConsumerUsage consumerUsage = serviceConfig.getConsumerUsage();
                    boolean bl = isInstalled = consumerUsage.getConsumerUsingName(configName) != null;
                    if (!isInstalled) {
                        MdOMIUtil mdOMIUtil = serviceComponent.getObjectStore().getFactory().getOMIUtil();
                        isInstalled = mdOMIUtil.doesObjectExist(mdOMIUtil.getReposIdFromMetadataObject((CMetadata)serviceComponent), "Property", this.getXMLSelectProperty(serviceComponent.getFQID(), configName)) > 0;
                    }
                }
            }
            catch (MdException e) {
                exception = e;
                return (boolean)exception;
            }
            catch (RemoteException e) {
                exception = e;
                return (boolean)exception;
            }
            finally {
                if (exception == null) break block9;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.isInstalled.ex.fmt.txt", (Object)configName, (Object)serviceComponentName, (Object)this.getSoftwareComponentName()));
            }
        }
        return isInstalled;
    }

    public void mergeServiceConfiguration(File configFile, ServiceComponent serviceComponent, Property property) throws ServiceException {
        try {
            this.mergeServiceConfiguration(configFile, serviceComponent, property, AbstractServiceDeployment.getServiceFactory(serviceComponent.getFactoryClassName()));
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeServiceConfiguration(File configFile, ServiceComponent serviceComponent, Property property, ServiceFactoryInterface serviceFactory) throws ServiceException {
        block28: {
            if (configFile == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyFile.ex.txt"));
            }
            this.validateServiceComponent(serviceComponent);
            if (property == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceConfigProperty.ex.txt"));
            }
            if (serviceFactory == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceFactory.ex.txt"));
            }
            String serviceComponentName = null;
            String propertyName = null;
            Throwable exception = null;
            FileInputStream fis = null;
            try {
                serviceComponentName = serviceComponent.getName();
                propertyName = property.getName();
                TextStore textStore = (TextStore)property.getStoredConfiguration();
                if (textStore == null) {
                    throw new IllegalArgumentException(RB.getStringResource("ServiceDeployment.propertyLacksTextStore.ex.txt"));
                }
                ServiceProfile serviceProfile = serviceFactory.getServiceProfile();
                fis = new FileInputStream(configFile);
                AbstractServiceComponentConfig newConfig = serviceProfile.createConfig("newConfig", XMLUtil.convertStreamToDocument(fis));
                this.installServiceConfiguration(serviceProfile, serviceComponent, newConfig, new MergePolicyAdd());
            }
            catch (FileNotFoundException e) {
                exception = e;
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(AbstractServiceComponentConfig.class).error(RB.getStringResource("IO.close.ex.txt"), (Throwable)e);
                    }
                }
                if (exception == null) break block28;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.mergeServiceConfig.ex.fmt.txt", (Object)configFile.getAbsolutePath(), (Object)serviceComponentName, (Object)propertyName, (Object)this.getSoftwareComponentName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property installServiceConfiguration(ServiceProfile serviceProfile, ServiceComponent serviceComponent, AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceException {
        Property property;
        block19: {
            property = null;
            if (newConfig == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceConfig.ex.txt"));
            }
            this.validateServiceComponent(serviceComponent);
            if (serviceProfile == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceProfile.ex.txt"));
            }
            String softwareComponentName = this.getSoftwareComponentName();
            String serviceComponentName = null;
            Throwable exception = null;
            try {
                serviceComponentName = serviceComponent.getName();
                Logger logger = LogManager.getLogger(ServiceDeployment.class);
                boolean isDebugLogEnabled = logger.isDebugEnabled();
                List<Property> properties = ServiceDeployment.getServiceConfigProperties(serviceComponent);
                if (properties.size() == 0) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyServiceConfigProperty.ex.fmt.txt", (Object)serviceComponentName, (Object)softwareComponentName));
                }
                Iterator<Property> iter = properties.iterator();
                property = iter.next();
                TextStore textStore = (TextStore)property.getStoredConfiguration();
                if (textStore == null) {
                    throw new IllegalArgumentException(RB.getStringResource("ServiceDeployment.propertyLacksTextStore.ex.txt"));
                }
                AbstractServiceComponentConfig targetConfig = serviceProfile.createServiceConfigForProperty(property);
                MergePolicyReplace mergePolicyLayeredConfigs = new MergePolicyReplace();
                ConsumerUsage consumerUsage = targetConfig.getConsumerUsage();
                AbstractServiceComponentConfig nextConfig = null;
                Property nextProperty = null;
                String nextName = null;
                Consumer consumer = null;
                while (iter.hasNext()) {
                    nextProperty = iter.next();
                    nextName = nextProperty.getName();
                    nextConfig = serviceProfile.createServiceConfigForProperty(nextProperty);
                    consumerUsage = nextConfig.getConsumerUsage();
                    consumer = consumerUsage.getConsumerUsingName(nextName);
                    if (consumer == null) {
                        consumer = new Consumer(nextName);
                        nextConfig.addConsumer(consumer, true);
                    } else {
                        nextConfig.setIsConsumer(consumer, true);
                    }
                    try {
                        targetConfig.mergeConfiguration(nextConfig, mergePolicyLayeredConfigs);
                        nextProperty.setPropertyRole("Application Configuration");
                        nextProperty.setPropertyName(nextProperty.getPropertyName() + "_913");
                        if (!isDebugLogEnabled) continue;
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.mergeAppConfig.fmt.log", (Object)nextName, (Object)serviceComponentName, (Object)softwareComponentName));
                    }
                    catch (ServiceConfigurationException e) {
                        logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.mergeAppConfig.ex.fmt.txt", (Object)nextName, (Object)serviceComponentName, (Object)this.getSoftwareComponentName()), (Throwable)((Object)e));
                    }
                }
                targetConfig.mergeConfiguration(newConfig, mergePolicy);
                textStore.setStoredText(targetConfig.toXMLString());
                if (isDebugLogEnabled) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.installedServiceConfig.fmt.log", (Object)newConfig.getConfigName(), (Object)serviceComponentName, (Object)softwareComponentName));
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (IllegalArgumentException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block19;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.installServiceConfig.ex.fmt.txt", (Object)serviceComponentName, (Object)softwareComponentName));
            }
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServiceComponent> renameConsumer(String oldConsumerName, String newConsumerName) throws ServiceException {
        HashSet<ServiceComponent> serviceComponentNames = new HashSet<ServiceComponent>(this._interfaceToServiceComponent.size());
        if (oldConsumerName == null) {
            throw new IllegalArgumentException("The name of the service configuration Consumer which is to be renamed must be specified.");
        }
        if (newConsumerName == null) {
            throw new IllegalArgumentException("The service configuration Consumer's new name must be specified.");
        }
        Throwable exception = null;
        try {
            for (Data data : this._interfaceToServiceComponent.values()) {
                if (!this.renameConsumer(oldConsumerName, newConsumerName, data)) continue;
                serviceComponentNames.add(data.getServiceComponent());
            }
        }
        finally {
            if (exception != null) {
                throw new ServiceException(exception, "Unable to rename service configuration consumer \"" + oldConsumerName + "\" in the SAS Foundation Services deployment \"" + this.getSoftwareComponentName() + "\".");
            }
        }
        return serviceComponentNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameConsumer(String oldConsumerName, String newConsumerName, Data data) throws ServiceException {
        boolean wasRenamed;
        block15: {
            wasRenamed = false;
            ServiceComponent serviceComponent = data.getServiceComponent();
            String softwareComponentName = this.getSoftwareComponentName();
            String serviceComponentName = null;
            Throwable exception = null;
            try {
                ServiceFactoryInterface serviceFactory = data.getServiceFactory();
                ServiceProfile serviceProfile = serviceFactory.getServiceProfile();
                serviceComponentName = serviceComponent.getName();
                Logger logger = LogManager.getLogger(ServiceDeployment.class);
                boolean isDebugLogEnabled = logger.isDebugEnabled();
                List<Property> properties = ServiceDeployment.getServiceConfigProperties(serviceComponent);
                if (properties.size() == 0) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyServiceConfigProperty.ex.fmt.txt", (Object)serviceComponentName, (Object)softwareComponentName));
                }
                Iterator<Property> iter = properties.iterator();
                Property property = iter.next();
                TextStore textStore = (TextStore)property.getStoredConfiguration();
                if (textStore == null) {
                    throw new ServiceException(RB.getStringResource("ServiceDeployment.propertyLacksTextStore.ex.txt"));
                }
                AbstractServiceComponentConfig serviceConfig = serviceProfile.createServiceConfigForProperty(property);
                if (serviceConfig != null) {
                    ConsumerUsage consumerUsage = serviceConfig.getConsumerUsage();
                    if (consumerUsage.getConsumerUsingName(newConsumerName) != null) {
                        throw new ServiceException("Unable to rename service configuration consumer from \"" + oldConsumerName + "\" to \"" + newConsumerName + "\" in service + \"" + serviceComponentName + "\" in the SAS Foundation Services deployment \"" + softwareComponentName + "\" because the new name is not unique.");
                    }
                    wasRenamed = consumerUsage.renameConsumer(oldConsumerName, newConsumerName);
                    if (wasRenamed) {
                        textStore.setStoredText(serviceConfig.toXMLString());
                        textStore.updateMetadataAll();
                        if (isDebugLogEnabled) {
                            logger.debug("The name of the consumer was changed from \"" + oldConsumerName + "\" to \"" + newConsumerName + "\" in service + \"" + serviceComponentName + "\" in the SAS Foundation Services deployment \"" + softwareComponentName + "\".");
                        }
                    }
                }
            }
            catch (MdException e) {
                exception = e;
                return (boolean)exception;
            }
            catch (RemoteException e) {
                exception = e;
                return (boolean)exception;
            }
            catch (IllegalArgumentException e) {
                exception = e;
                return (boolean)exception;
            }
            finally {
                if (exception == null) break block15;
                throw new ServiceException(exception, "Unable to change the name of the consumer from \"" + oldConsumerName + "\" to \"" + newConsumerName + "\" in service \"" + serviceComponentName + "\" in the SAS Foundation Services deployment \"" + softwareComponentName + "\".");
            }
        }
        return wasRenamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerUsage getConsumerUsage(Data data) throws ServiceException {
        ConsumerUsage consumerUsage = null;
        ServiceComponent serviceComponent = data.getServiceComponent();
        String softwareComponentName = this.getSoftwareComponentName();
        String serviceComponentName = null;
        Throwable exception = null;
        try {
            ServiceFactoryInterface serviceFactory = data.getServiceFactory();
            ServiceProfile serviceProfile = serviceFactory.getServiceProfile();
            serviceComponentName = serviceComponent.getName();
            List<Property> properties = ServiceDeployment.getServiceConfigProperties(serviceComponent);
            if (properties.size() == 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.specifyServiceConfigProperty.ex.fmt.txt", (Object)serviceComponentName, (Object)softwareComponentName));
            }
            Iterator<Property> iter = properties.iterator();
            Property property = iter.next();
            TextStore textStore = (TextStore)property.getStoredConfiguration();
            if (textStore == null) {
                throw new ServiceException(RB.getStringResource("ServiceDeployment.propertyLacksTextStore.ex.txt"));
            }
            AbstractServiceComponentConfig serviceConfig = serviceProfile.createServiceConfigForProperty(property);
            if (serviceConfig != null) {
                consumerUsage = serviceConfig.getConsumerUsage();
            }
        }
        catch (MdException e) {
            exception = e;
        }
        catch (RemoteException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                throw new ServiceException(exception, this.getConsumerUsageExceptionMsg(serviceComponentName, softwareComponentName));
            }
            if (consumerUsage == null) {
                consumerUsage = new ConsumerUsage();
            }
        }
        return consumerUsage;
    }

    private String getConsumerUsageExceptionMsg(String serviceComponentName, String softwareComponentName) {
        return "Unable to determine the consumers for service \"" + serviceComponentName + "\" in the SAS Foundation Services deployment \"" + softwareComponentName + "\".";
    }

    private Set<String> getServiceConsumerNames(Data data) throws ServiceException {
        ConsumerUsage consumerUsage = this.getConsumerUsage(data);
        Set<Consumer> consumers = consumerUsage.getConsumers();
        HashSet<String> consumerNames = new HashSet<String>(consumers.size());
        for (Consumer consumer : consumers) {
            consumerNames.add(consumer.getName());
        }
        return consumerNames;
    }

    public static List<Property> getServiceConfigProperties(ServiceComponent serviceComponent) throws ServiceException {
        return ServiceDeployment.getServiceConfigProperties(serviceComponent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Property> getServiceConfigProperties(ServiceComponent serviceComponent, boolean isIncludeAppConfigProperties) throws ServiceException {
        ArrayList<Property> list;
        block10: {
            list = null;
            Throwable exception = null;
            try {
                AssociationList properties = serviceComponent.getProperties();
                list = new ArrayList<Property>(properties.size());
                for (Property property : properties) {
                    if (!"INIT_DATA".equals(property.getPropertyName()) || !isIncludeAppConfigProperties && "Application Configuration".equals(property.getPropertyRole())) continue;
                    list.add(property);
                }
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (ClassCastException e) {
                exception = e;
                return exception;
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block10;
                throw new ServiceException(exception, RB.getStringResource("AbstractServiceComponentConfig.unableToGetServiceProperties.ex.txt"));
            }
        }
        return list;
    }

    public void uninstallServiceConfiguration(AbstractServiceComponentConfig serviceConfig, String configName, String serviceInterfaceClassName, boolean isRemoveUnusedResources) throws ServiceException {
        this.uninstallServiceConfiguration(this.getServiceComponent(serviceInterfaceClassName), serviceConfig, configName, isRemoveUnusedResources);
    }

    public void uninstallServiceConfiguration(ServiceComponent serviceComponent, AbstractServiceComponentConfig serviceConfig, String configName) throws ServiceException {
        this.uninstallServiceConfiguration(serviceComponent, serviceConfig, configName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallServiceConfiguration(ServiceComponent serviceComponent, AbstractServiceComponentConfig serviceConfig, String consumerName, boolean isRemoveUnusedResources) throws ServiceException {
        block12: {
            this.validateServiceComponent(serviceComponent);
            Throwable exception = null;
            String serviceComponentName = "";
            try {
                serviceComponentName = serviceComponent.getName();
                List<Property> properties = ServiceDeployment.getServiceConfigProperties(serviceComponent, true);
                if (properties.size() <= 0) break block12;
                Iterator<Property> iter = properties.iterator();
                Property baseProperty = iter.next();
                Consumer consumer = serviceConfig.getConsumerUsage().getConsumerUsingName(consumerName);
                if (consumer != null) {
                    serviceConfig.removeConsumer(consumer, isRemoveUnusedResources);
                    String xml = serviceConfig.toXMLString();
                    if (xml == null) {
                        xml = "";
                    }
                    ((TextStore)baseProperty.getStoredConfiguration()).setStoredText(xml);
                }
                Property property = null;
                while (iter.hasNext()) {
                    Text cMetadata;
                    property = iter.next();
                    if (!consumerName.equals(property.getName())) continue;
                    PropertyType propertyType = property.getOwningType();
                    if (propertyType != null && propertyType.getTypedProperties().size() == 1) {
                        propertyType.delete();
                    }
                    if ((cMetadata = property.getStoredConfiguration()) != null) {
                        cMetadata.delete();
                    }
                    property.delete();
                    break;
                }
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (MdException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block12;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.uninstallConfig.ex.fmt.txt", (Object)consumerName, (Object)serviceComponentName));
            }
        }
    }

    public void exportServiceConfigurations(File exportDirectory) throws IllegalArgumentException, ServiceException, RemoteException, MdException {
        this.exportServiceConfigurations(exportDirectory, ServiceDeployment.getDefaultConsumerConfigurationsPropertiesFile(exportDirectory));
    }

    public void exportServiceConfigurations(File exportDirectory, File propertiesFile) throws IllegalArgumentException, ServiceException, RemoteException, MdException {
        if (null == exportDirectory) {
            throw new IllegalArgumentException("An export directory must be specified.");
        }
        if (null == propertiesFile) {
            throw new IllegalArgumentException("A configuration properties file must be specified.");
        }
        Logger logger = LogManager.getLogger(ServiceDeployment.class);
        boolean isDebugLogEnabled = logger.isDebugEnabled();
        String serviceDeploymentName = this._softwareComponent.getName();
        File serviceDeploymentFile = new File(exportDirectory, "foundation_services.xml");
        if (serviceDeploymentFile.exists()) {
            serviceDeploymentFile.delete();
        }
        ServiceDeploymentExporter.exportServiceDeployment(this._softwareComponent, serviceDeploymentFile.getAbsolutePath(), true);
        boolean isExportingBaseConfig = false;
        HashMap<String, String> consumerNameMap = new HashMap<String, String>(5);
        Properties properties = new Properties();
        StringBuilder consumerIDs = new StringBuilder(10);
        StringBuilder serviceInterfaces = new StringBuilder(125);
        String svcGroupName = null;
        for (Map.Entry<String, Data> mapEntry : this._interfaceToServiceComponent.entrySet()) {
            String svcInterface = mapEntry.getKey();
            if (serviceInterfaces.length() > 0) {
                serviceInterfaces.append(',');
            }
            serviceInterfaces.append(svcInterface);
            Data data = mapEntry.getValue();
            ServiceComponent serviceComponent = data.getServiceComponent();
            AssociationList trees = serviceComponent.getTrees();
            if (trees.size() > 0) {
                svcGroupName = ((Tree)trees.get(0)).getName();
            }
            ServiceAggregateConfig serviceAggregateConfig = new ServiceAggregateConfig(serviceComponent);
            ServiceFactoryInterface svcFactory = data.getServiceFactory();
            ServiceProfile svcProfile = svcFactory.getServiceProfile();
            boolean hasConfig = true;
            hasConfig = svcProfile.isDeprecated() ? svcProfile.hasServiceConfig(serviceComponent) : svcProfile.hasServiceConfig();
            if (!hasConfig || !svcProfile.supportsAction(1)) continue;
            for (String consumerName : this.getServiceConsumerNames(data)) {
                String consumerID = (String)consumerNameMap.get(consumerName);
                if (consumerID == null) {
                    consumerID = Integer.toString(consumerNameMap.size() + 1);
                    consumerNameMap.put(consumerName, consumerID);
                    properties.put("consumer_ID_" + consumerID, consumerID);
                    properties.put("consumer_name_" + consumerID, consumerName);
                    if (consumerIDs.length() > 0) {
                        consumerIDs.append(',');
                    }
                    consumerIDs.append(consumerID);
                }
                File file = new File(exportDirectory, this.getServiceConfigConsumerFilename(svcInterface, consumerID));
                ArrayList<String> consumerNames = new ArrayList<String>(1);
                consumerNames.add(consumerName);
                svcProfile.exportServiceConfig(file, serviceAggregateConfig, isExportingBaseConfig, consumerNames);
                if (isDebugLogEnabled) {
                    logger.debug("Exported '" + consumerName + "' " + svcInterface + " configuration to " + file.getAbsolutePath());
                }
                if (!file.exists()) continue;
                properties.put(svcInterface + '_' + consumerID, file.getName());
                properties.put("software_component", serviceDeploymentName);
                properties.put(svcInterface + "_name", serviceComponent.getName());
                properties.put(svcInterface + "_group", svcGroupName);
            }
        }
        properties.put("consumer_IDs", consumerIDs.toString());
        properties.put("service_interfaces", serviceInterfaces.toString());
        if (properties.size() > 0) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(propertiesFile);
                boolean version = true;
                properties.put("version", Integer.toString(1));
                properties.store(fos, null);
                if (isDebugLogEnabled) {
                    logger.debug("Properties describing the exported SAS Foundation Service consumer configurations are defined in " + propertiesFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new ServiceException(e, "Unable to write foundation service configuration properties to file " + propertiesFile.getAbsolutePath());
            }
            finally {
                if (null != fos) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(ServiceDeployment.class).error("An error was encountered attempting to close the file output stream.", (Throwable)e);
                    }
                }
            }
        }
    }

    private String getServiceConfigConsumerFilename(String serviceFactoryClassName, String consumerNumber) {
        return serviceFactoryClassName + '_' + consumerNumber + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRepositoryID(MdStore mdStore, String repositoryName) throws ServiceException {
        String repositoryID;
        block9: {
            repositoryID = null;
            Throwable exception = null;
            try {
                CMetadata cMetadata2 = null;
                for (CMetadata cMetadata2 : mdStore.getFactory().getOMIUtil().getRepositories()) {
                    if (!repositoryName.equals(cMetadata2.getName())) continue;
                    repositoryID = cMetadata2.getFQID();
                    break;
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block9;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.getRepositoryID.ex.fmt.txt", (Object)repositoryName));
            }
        }
        if (repositoryID == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.getRepositoryID.ex.fmt.txt", (Object)repositoryName));
        }
        return repositoryID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Data> determineServices(SoftwareComponent softwareComponent) throws ServiceException {
        HashMap<String, Data> map;
        block10: {
            map = new HashMap<String, Data>(10);
            Throwable exception = null;
            String softwareComponentName = null;
            try {
                softwareComponentName = softwareComponent.getName();
                MdStore mdStore = softwareComponent.getObjectStore();
                MdOMIUtil mdOMIUtil = mdStore.getFactory().getOMIUtil();
                int flags = 396;
                ServiceComponent serviceComponent2 = null;
                ServiceFactoryInterface serviceFactory = null;
                String serviceFactoryClassName = null;
                for (ServiceComponent serviceComponent2 : mdOMIUtil.getMetadataObjectsSubset(mdStore, mdOMIUtil.getReposIdFromMetadataObject((CMetadata)softwareComponent), "ServiceComponent", 396, this.getSearchOptions(softwareComponent.getFQID()))) {
                    serviceFactoryClassName = serviceComponent2.getFactoryClassName();
                    try {
                        serviceFactory = AbstractServiceDeployment.getServiceFactory(serviceFactoryClassName);
                        map.put(serviceFactory.getServiceProfile().getServiceInterfaceClass(), new Data(serviceFactory, serviceComponent2));
                    }
                    catch (ServiceException e) {
                        LogManager.getLogger(ServiceDeployment.class).warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceFactory.get.ex.fmt.txt", (Object)serviceFactoryClassName), (Throwable)((Object)e));
                    }
                }
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block10;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.determineServices.ex.fmt.txt", (Object)softwareComponentName));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property installServiceConfiguration(String configName, File configFile, ServiceComponent serviceComponent, ServiceFactoryInterface serviceFactory, MergePolicy mergePolicy) throws ServiceException {
        Property property;
        block21: {
            property = null;
            Exception exception = null;
            FileInputStream fis = null;
            String serviceComponentName = "";
            try {
                serviceComponentName = serviceComponent.getName();
                fis = new FileInputStream(configFile);
                ServiceProfile serviceProfile = serviceFactory.getServiceProfile();
                Document serviceDocument = XMLUtil.convertStreamToDocument(fis);
                AbstractServiceComponentConfig config = serviceProfile.createConfig(configName, serviceDocument);
                if (config == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.serviceProfileCreateConfig.ex.fmt.txt", (Object)serviceProfile.getClass().getName()));
                }
                ServiceDeployment.addConsumerToServiceConfig(config, configName);
                property = this.installServiceConfiguration(serviceProfile, serviceComponent, config, mergePolicy);
            }
            catch (FileNotFoundException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (IllegalArgumentException e) {
                exception = e;
                return exception;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(AbstractServiceComponentConfig.class).error(RB.getStringResource("IO.close.ex.txt"), (Throwable)e);
                    }
                }
                if (exception == null) break block21;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeployment.installServiceConfiguration.ex.fmt.txt", (Object)configName, (Object)serviceComponentName, (Object)this.getSoftwareComponentName()));
            }
        }
        return property;
    }

    private void validateServiceComponent(ServiceComponent serviceComponent) throws ServiceException {
        if (serviceComponent == null) {
            throw new ServiceException(new IllegalArgumentException("IllegalArgument.specifyServiceComponent.ex.txt"));
        }
    }

    private static Consumer addConsumerToServiceConfig(AbstractServiceComponentConfig config, String consumerName) {
        Consumer consumer = null;
        if (config == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceConfig.ex.txt"));
        }
        if (consumerName != null && consumerName.length() > 0) {
            ConsumerUsage consumerUsage = config.getConsumerUsage();
            consumer = consumerUsage.getConsumerUsingName(consumerName);
            if (consumer == null) {
                consumer = new Consumer(consumerName);
                consumerUsage.addConsumer(consumer, true);
            } else {
                consumerUsage.setIsConsumer(consumer, true);
            }
        }
        return consumer;
    }

    private static File getDefaultConsumerConfigurationsPropertiesFile(File exportDirectory) {
        return new File(exportDirectory, "foundation_services.properties");
    }

    @SASScope
    private static final class Data {
        private ServiceComponent _serviceComponent;
        private ServiceFactoryInterface _serviceFactory;

        private Data(ServiceFactoryInterface serviceFactory, ServiceComponent serviceComponent) {
            this._serviceComponent = serviceComponent;
            this._serviceFactory = serviceFactory;
        }

        private ServiceFactoryInterface getServiceFactory() {
            return this._serviceFactory;
        }

        private ServiceComponent getServiceComponent() {
            return this._serviceComponent;
        }
    }
}

