/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.meta.SASOMI.IOMI;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.deployment.MetadataSourceProperties;
import com.sas.services.deployment.OMRServiceConfigFactory;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceConfigFactoryInterface;
import com.sas.services.deployment.URLServiceConfigFactory;
import com.sas.text.Message;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class ServiceConfigFactory {
    public static final String PROPERTYNAME_IOMI = IOMI.class.getName();
    public static final String PROPERTYNAME_CONNECTION = ConnectionInterface.class.getName();
    private Properties _properties;

    public ServiceConfigFactory() throws ServiceException {
    }

    public ServiceConfigFactory(Properties properties) throws ServiceException {
        this.setProperties(properties);
    }

    public void setMetadataSourceProperties(MetadataSourceProperties metadataSourceProperties) throws ServiceException {
        this.setProperties(metadataSourceProperties == null ? null : metadataSourceProperties.getProperties());
    }

    public void setProperties(Properties properties) throws ServiceException {
        if (properties != null && properties.size() > 0) {
            String mode = properties.getProperty("metadatasource_mode");
            boolean isOMR = false;
            if (mode == null) {
                if (properties.getProperty("omr_repository") != null) {
                    isOMR = true;
                } else {
                    ServiceConfigFactory.validatePropertiesForURL(properties);
                }
            } else if ("omr_repository".equals(mode)) {
                isOMR = true;
            } else if ("url".equals(mode)) {
                ServiceConfigFactory.validatePropertiesForURL(properties);
            } else {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.invalidMode.ex.fmt.txt", (Object)mode, (Object)"omr_repository", (Object)"url"));
            }
            if (isOMR) {
                String repositoryName = ServiceConfigFactory.getRepositoryName(properties);
                ConnectionInterface connection = ServiceConfigFactory.getConnection(properties);
                IOMI omi = null;
                if (connection == null) {
                    omi = ServiceConfigFactory.getOMI(properties);
                }
                if (repositoryName == null || connection == null && omi == null) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.specifyOMR.ex.fmt.txt", (Object)"metadatasource_mode", (Object)"omr_repository", (Object)PROPERTYNAME_CONNECTION, (Object)ConnectionInterface.class.getName(), (Object)PROPERTYNAME_IOMI, (Object)IOMI.class.getName()));
                }
            }
            this._properties = new Properties();
            this._properties.putAll((Map<?, ?>)properties);
        } else {
            if (this._properties != null) {
                this._properties.clear();
            }
            this._properties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validatePropertiesForURL(Map properties) throws ServiceException {
        block5: {
            boolean isValid = false;
            String propertyName = "url";
            try {
                String url = (String)properties.get("url");
                isValid = url != null;
            }
            catch (ClassCastException e) {
                isValid = false;
            }
            finally {
                if (isValid) break block5;
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.specifyURL.ex.fmt.txt", (Object)"metadatasource_mode", (Object)"url", (Object)String.class.getName()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceConfigFactoryInterface createFactory() throws ServiceException {
        ServiceConfigFactoryInterface serviceConfigFactory = null;
        Properties properties = this._properties;
        if (properties == null) {
            throw new ServiceException(RB.getStringResource("ServiceConfigFactory.specifyProperties.ex.txt"));
        }
        String mode = properties.getProperty("metadatasource_mode");
        if (mode != null) {
            if ("omr_repository".equals(mode)) {
                return ServiceConfigFactory.createFactoryForOMR(properties);
            }
            if (!"url".equals(mode)) throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.invalidMode.ex.fmt.txt", (Object)mode, (Object)"omr_repository", (Object)"url"));
            return ServiceConfigFactory.createFactoryForURL(properties);
        }
        if (properties.getProperty("url") == null) return ServiceConfigFactory.createFactoryForOMR(properties);
        return ServiceConfigFactory.createFactoryForURL(properties);
    }

    private static ServiceConfigFactoryInterface createFactoryForOMR(Map properties) throws ServiceException {
        String repositoryID = ServiceConfigFactory.getRepositoryName(properties);
        ConnectionInterface connection = ServiceConfigFactory.getConnection(properties);
        return connection == null ? new OMRServiceConfigFactory(repositoryID, ServiceConfigFactory.getOMI(properties)) : new OMRServiceConfigFactory(repositoryID, connection);
    }

    private static String getRepositoryName(Map properties) throws ServiceException {
        String repositoryName = null;
        Object value = properties.get("omr_repository");
        if (value != null) {
            try {
                repositoryName = (String)value;
            }
            catch (ClassCastException e) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.reposID.ex.fmt.txt", (Object)"omr_repository", value));
            }
        }
        return repositoryName;
    }

    private static ConnectionInterface getConnection(Map properties) throws ServiceException {
        ConnectionInterface connection = null;
        Object value = properties.get(PROPERTYNAME_CONNECTION);
        if (value != null) {
            try {
                connection = (ConnectionInterface)value;
            }
            catch (ClassCastException e) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.cx.ex.fmt.txt", (Object)PROPERTYNAME_CONNECTION, (Object)value.getClass().getName(), (Object)ConnectionInterface.class.getName()));
            }
        }
        return connection;
    }

    private static IOMI getOMI(Map properties) throws ServiceException {
        IOMI omi = null;
        String propertyName = PROPERTYNAME_IOMI;
        Object o = properties.get(propertyName);
        if (o != null) {
            try {
                omi = (IOMI)o;
            }
            catch (ClassCastException e) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.cx.ex.fmt.txt", (Object)propertyName, o, (Object)IOMI.class.getName()));
            }
        }
        return omi;
    }

    private static ServiceConfigFactoryInterface createFactoryForURL(Map properties) throws ServiceException {
        URLServiceConfigFactory factory = null;
        String propertyName = "url";
        Object o = properties.get("url");
        Exception ex = null;
        if (o != null) {
            try {
                factory = new URLServiceConfigFactory(new URL((String)o));
            }
            catch (MalformedURLException e) {
                ex = e;
            }
            catch (ClassCastException e) {
                ex = e;
            }
        }
        if (factory == null) {
            throw new ServiceException(ex, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigFactory.url.ex.fmt.txt", (Object)"url", o));
        }
        return factory;
    }

    public void destroy() {
        Logger logger = LogManager.getLogger(ServiceConfigFactory.class);
        if (logger.isDebugEnabled()) {
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"Common.destroy.fmt.log", (Object)ServiceConfigFactory.class.getName()));
        }
    }
}

