/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.deployment.DeployableService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServiceComparator
implements Comparator<DeployableService> {
    private final Map<String, Set<String>> _idMap = new HashMap<String, Set<String>>(10);

    @Override
    public final int compare(DeployableService ds1, DeployableService ds2) {
        int value = 0;
        if (null != ds1 && null != ds2) {
            Set<String> set2;
            String thisId = ds1.getId();
            String thatId = ds2.getId();
            Set<String> set1 = this._idMap.get(thisId);
            if (set1 == null) {
                set1 = new HashSet<String>(ds1.getDependencies());
                this._idMap.put(thisId, set1);
            }
            if ((set2 = this._idMap.get(thatId)) == null) {
                set2 = new HashSet<String>(ds2.getDependencies());
                this._idMap.put(thatId, set2);
            }
            if (thisId != null) {
                value = ServiceComparator.hasDependency(thisId, set2);
            }
            if (value != 0 && thatId != null) {
                value = ServiceComparator.hasDependency(thatId, set1);
            }
        }
        return value;
    }

    private static final int hasDependency(String thisId, Set<String> set) {
        int value = 0;
        for (String nextID : set) {
            if (!thisId.equals(nextID)) continue;
            value = -1;
            break;
        }
        return value;
    }
}

