/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentImportException;
import com.sas.text.Message;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class NameNotUniqueImportException
extends ServiceDeploymentImportException {
    private static final long serialVersionUID = -3162842159649379822L;
    private static final int MESSAGE_LENGTH = 50;

    NameNotUniqueImportException(String serviceDeploymentName) {
        super(NameNotUniqueImportException.getMessage(new String[]{serviceDeploymentName}));
    }

    public NameNotUniqueImportException(String[] serviceDeploymentNames) {
        super(NameNotUniqueImportException.getMessage(serviceDeploymentNames));
    }

    public static String getMessage(String[] serviceDeploymentNames) {
        String msg = null;
        if (serviceDeploymentNames != null) {
            int numNames = serviceDeploymentNames.length;
            Integer numItems = numNames;
            if (numNames == 1) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"NameNotUniqueException.theNonUniqueName.fmt.txt", (Object)serviceDeploymentNames[0]);
            } else if (numNames > 1) {
                StringBuilder buffer = new StringBuilder(50 * numNames);
                for (int i = 0; i < numNames; ++i) {
                    msg = i + 1 == numNames ? Message.format((ResourceBundle)RB.getResources(), (String)"NameNotUniqueImportException.duplicateName.fmt.txt", (Object)serviceDeploymentNames[i]) : Message.format((ResourceBundle)RB.getResources(), (String)"NameNotUniqueImportException.duplicateNameAnd.fmt.txt", (Object)serviceDeploymentNames[i]);
                    buffer.append(msg);
                }
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"NameNotUniqueException.nonUniqueName.fmt.txt", (Object)numItems, (Object)buffer.toString());
            } else {
                msg = RB.getStringResource("NameNotUniqueException.mustSpecifyName.ex.fmt.txt");
            }
        }
        return msg;
    }
}

