/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.deployment.MetadataSourceFactory;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ioc.DeploymentContextFactory;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class Configuration {
    private SoftwareComponent _softwareComponent;
    private final Set<String> _groupNames = new HashSet<String>(5);
    private final Properties _properties = new Properties();
    private static final Properties LOCALIZED_NAME_PROPERTIES = new Properties();
    private static final Properties LOCALIZED_DESC_PROPERTIES;

    public Configuration(SoftwareComponent softwareComponent) throws MdException {
        this.setSoftwareComponent(softwareComponent);
    }

    public SoftwareComponent getSoftwareComponent() {
        return this._softwareComponent;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setSoftwareComponent(SoftwareComponent softwareComponent) throws MdException {
        if (softwareComponent == null) {
            throw new IllegalArgumentException();
        }
        try {
            this._softwareComponent = softwareComponent;
            this._properties.put("software_component", softwareComponent.getName());
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }

    public void setContainerType(String containerType) throws IllegalArgumentException {
        if (!DeploymentContextFactory.isValidContainerType(containerType)) {
            throw new IllegalArgumentException();
        }
        this._properties.put("container", containerType);
    }

    public String getContainerType() {
        return this._properties.getProperty("container");
    }

    public void setRepository(String repository) {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this._properties.put("omr_repository", repository);
    }

    public void setSecuritySPN(String metaspn) {
        this.setProperty(MetadataSourceFactory.PROPERTY_SSO_SPN, metaspn);
    }

    public void setSecurityPackageList(String secpackagelist) {
        this.setProperty(MetadataSourceFactory.PROPERTY_SSO_SECPACKAGELIST, secpackagelist);
    }

    public void setUserId(String userId) {
        this.setProperty("omr_user", userId);
    }

    public void setUserPassword(String userPassword) {
        this.setProperty("omr_password", userPassword);
    }

    public void setHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException();
        }
        this._properties.put("omr_host", host);
    }

    public void setPort(String port) {
        if (port == null) {
            throw new IllegalArgumentException();
        }
        this._properties.put("omr_port", port);
    }

    public void setURL(String url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        this._properties.put("url", url);
    }

    public void setMode(String mode) {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        if (!mode.equals("url") && !mode.equals("omr_repository")) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Configuration.invalidMode.ex.fmt.txt", (Object)mode, (Object)"omr_repository", (Object)"url"));
        }
        this._properties.put("metadatasource_mode", mode);
    }

    public void setDeploymentGroups(Set<String> groupNames) {
        this._groupNames.clear();
        this._groupNames.addAll(groupNames);
        int maxNumGroups = MetadataSourceFactory.getMaxNumberOfGroups();
        for (int i = 1; i <= maxNumGroups && this._properties.remove(MetadataSourceFactory.getServiceGroupName(i)) != null; ++i) {
        }
        int index = 1;
        for (String groupName : groupNames) {
            this._properties.put(MetadataSourceFactory.getServiceGroupName(index++), groupName);
        }
    }

    public String localizePropertyName(String propertyName) {
        String localizedName = LOCALIZED_NAME_PROPERTIES.getProperty(propertyName);
        if (localizedName == null) {
            localizedName = propertyName;
        }
        return localizedName;
    }

    public String getDescForProperty(String propertyName) {
        String localizedName;
        String string = localizedName = propertyName.startsWith("deployment_group_") ? RB.getStringResource("Configuration.deployment_group.desc.txt") : LOCALIZED_DESC_PROPERTIES.getProperty(propertyName);
        if (localizedName == null) {
            localizedName = propertyName;
        }
        return localizedName;
    }

    public String localizePropertyGroupName(int groupIndex) {
        return Message.format((ResourceBundle)RB.getResources(), (String)"Configuration.groupProperty.fmt.txt", (Object)groupIndex);
    }

    public String localizePropertyMode(String mode) {
        String localizedValue = null;
        if ("omr_repository".equals(mode)) {
            localizedValue = RB.getStringResource("Configuration.modeRepository.txt");
        } else if ("url".equals(mode)) {
            localizedValue = RB.getStringResource("Configuration.url.txt");
        } else {
            throw new IllegalArgumentException();
        }
        return localizedValue;
    }

    private void setProperty(String propertyKey, String propertyValue) {
        if (propertyKey != null) {
            if (propertyValue == null) {
                this._properties.remove(propertyKey);
            } else {
                this._properties.put(propertyKey, propertyValue);
            }
        }
    }

    static {
        LOCALIZED_NAME_PROPERTIES.put("omr_host", RB.getStringResource("Configuration.omr_host.txt"));
        LOCALIZED_NAME_PROPERTIES.put("omr_port", RB.getStringResource("Configuration.omr_port.txt"));
        LOCALIZED_NAME_PROPERTIES.put("omr_repository", RB.getStringResource("Configuration.omr_repository.txt"));
        LOCALIZED_NAME_PROPERTIES.put("url", RB.getStringResource("Configuration.url.txt"));
        LOCALIZED_NAME_PROPERTIES.put("metadatasource_mode", RB.getStringResource("Configuration.metadatasource_mode.txt"));
        LOCALIZED_NAME_PROPERTIES.put("omr_user", RB.getStringResource("Configuration.omr_user.txt"));
        LOCALIZED_NAME_PROPERTIES.put("omr_password", RB.getStringResource("Configuration.omr_password.txt"));
        LOCALIZED_NAME_PROPERTIES.put("software_component", RB.getStringResource("Configuration.software_component.txt"));
        LOCALIZED_NAME_PROPERTIES.put(MetadataSourceFactory.PROPERTY_SSO_SPN, RB.getStringResource("Configuration.metaspn.txt"));
        LOCALIZED_NAME_PROPERTIES.put(MetadataSourceFactory.PROPERTY_SSO_SECPACKAGELIST, RB.getStringResource("Configuration.secpackagelist.txt"));
        LOCALIZED_DESC_PROPERTIES = new Properties();
        LOCALIZED_DESC_PROPERTIES.put("omr_host", RB.getStringResource("Configuration.omr_host.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put("omr_port", RB.getStringResource("Configuration.omr_port.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put("omr_repository", RB.getStringResource("Configuration.omr_repository.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put("url", RB.getStringResource("Configuration.url.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put("omr_user", RB.getStringResource("Configuration.omr_user.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put("metadatasource_mode", RB.getStringResource("Configuration.metadatasource_mode.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put("omr_password", RB.getStringResource("Configuration.omr_password.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put("software_component", RB.getStringResource("Configuration.software_component.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put(MetadataSourceFactory.PROPERTY_SSO_SPN, RB.getStringResource("Configuration.metaspn.desc.txt"));
        LOCALIZED_DESC_PROPERTIES.put(MetadataSourceFactory.PROPERTY_SSO_SECPACKAGELIST, RB.getStringResource("Configuration.secpackagelist.desc.txt"));
    }
}

