/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.text.Message;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationSystem;
import java.rmi.registry.Registry;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ActivatableWrapper {
    private static final String JAVA_SECURITY_POLICY = "java.security.policy";
    private final Properties _properties = new Properties();
    private String _location;
    private String _className;
    private String _bindName;
    private MarshalledObject _marshalledData;
    private RMIConfiguration _rmiConfiguration;

    public ActivatableWrapper(String securityPolicyFile, String location, String className, String bindName) throws IOException {
        this(securityPolicyFile, location, className, bindName, null, null);
    }

    public ActivatableWrapper(String securityPolicyFile, String location, String className, String bindName, Object marshalledDataObject, RMIConfiguration rmiConfiguration) throws IOException {
        this.setJavaSecurityPolicy(securityPolicyFile);
        this.setLocation(location);
        this.setClassName(className);
        this.setBindName(bindName);
        this.setMarshalledDataObject(marshalledDataObject);
        this._rmiConfiguration = rmiConfiguration;
    }

    private final void setJavaSecurityPolicy(String securityPolicyFile) {
        if (securityPolicyFile == null) {
            Logger logger = LogManager.getLogger(ActivatableWrapper.class);
            if (logger.isDebugEnabled()) {
                logger.debug(RB.getStringResource("ActivatableWrapper.noJavaSecurityFileWasSpecified.txt"));
            }
        } else {
            this._properties.put(JAVA_SECURITY_POLICY, securityPolicyFile);
        }
    }

    private final void setLocation(String location) {
        this._location = location;
    }

    private final void setClassName(String className) {
        this._className = className;
    }

    private final void setBindName(String bindName) {
        this._bindName = bindName;
    }

    public final void setMarshalledDataObject(Object data) throws IOException {
        this._marshalledData = new MarshalledObject<Object>(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getMarshalledDataObject() throws ServiceException {
        Object object;
        block7: {
            object = null;
            Exception exception = null;
            try {
                object = this._marshalledData.get();
            }
            catch (IOException e) {
                exception = e;
                return exception;
            }
            catch (ClassNotFoundException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block7;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ActivatableWrapper.getMarshalledData.ex.fmt.txt", (Object)exception.getLocalizedMessage()));
            }
        }
        return object;
    }

    public final MarshalledObject getMarshalledData() throws IOException {
        if (this._marshalledData == null) {
            this._marshalledData = new MarshalledObject<Object>(null);
        }
        return this._marshalledData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote deploy() throws ServiceException {
        Remote remote = null;
        Logger logger = LogManager.getLogger(ActivatableWrapper.class);
        try {
            block17: {
                if (System.getSecurityManager() == null) {
                    System.setSecurityManager(new SecurityManager());
                }
                ActivationGroupDesc.CommandEnvironment ace = null;
                ActivationGroupDesc activationGroup = new ActivationGroupDesc(this._properties, ace);
                ActivationSystem activationSystem = null;
                try {
                    activationSystem = ActivationGroup.getSystem();
                }
                catch (ActivationException e) {
                    logger.error(RB.getStringResource("ActivatableWrapper.exceptionUnableToObtainActivationGroup.ex.txt"), (Throwable)e);
                    throw e;
                }
                ActivationGroupID activationGroupId = activationSystem.registerGroup(activationGroup);
                try {
                    ActivationGroup.createGroup((ActivationGroupID)activationGroupId, (ActivationGroupDesc)activationGroup, (long)0L);
                }
                catch (ActivationException e) {
                    logger.error(RB.getStringResource("ActivatableWrapper.exceptionUnableToCreateActivationGroup.ex.txt"), (Throwable)e);
                }
                ActivationDesc activationDesc = new ActivationDesc(this._className, this._location, this.getMarshalledData());
                if (logger.isDebugEnabled()) {
                    logger.debug(RB.getStringResource("ActivatableWrapper.registeringWithRMID.txt"));
                }
                remote = Activatable.register((ActivationDesc)activationDesc);
                if (logger.isDebugEnabled()) {
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ActivatableWrapper.bindingStubToRMIRegistry.fmt.txt", (Object)this._bindName));
                }
                RemoteException exception = null;
                try {
                    Registry registry = this._rmiConfiguration.getRMIRegistry(true);
                    registry.rebind(this._bindName, remote);
                }
                catch (RemoteException e) {
                    exception = e;
                    return exception;
                }
                finally {
                    if (exception == null) break block17;
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ActivatableWrapper.exceptionUnableToBindService.fmt.txt", (Object)this._bindName);
                    logger.error(msg, (Throwable)exception);
                    throw new ServiceException(exception, msg);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ActivatableWrapper.exportedActivatableObject.fmt.txt", (Object)remote));
            }
        }
        catch (ActivationException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
        return remote;
    }
}

