/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services;

import com.sas.entities.EntityKeyInterface;
import com.sas.entities.GUID;
import com.sas.services.InitializationException;
import com.sas.services.RB;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceState;
import com.sas.services.deployment.AbstractMetadataSource;
import com.sas.services.deployment.MetadataSourceConfigurationInterface;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.IsRemotelyAccessibleAttribute;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.MetadataAttribute;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.discovery.ServiceTypes;
import com.sas.services.mgmt.ServiceEvent;
import com.sas.services.mgmt.ServiceRemoteObserverInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

public class ServiceProxy
implements RemoteServiceInterface,
Serializable {
    private static final long serialVersionUID = 4813222389500798364L;
    private static final String ID = GUID.newGUID();
    private static final int METADATA_ID_LENGTH = 17;
    private final String _id = ID;
    private RemoteServiceInterface _service;
    private transient RemoteServiceInterface _localService;
    private String _serviceId;
    private transient boolean _isProxyInitialized;
    private long _rmtServiceCreationTime;
    private ServiceConfigurationInterface _rmtServiceConfiguration;
    private MetadataSourceInterface _rmtMetadataSource;
    private boolean _isDestroyed;
    private ServiceTemplate _serviceTemplate;

    public ServiceProxy(RemoteServiceInterface service) throws InitializationException {
        this.setService(service);
    }

    protected final RemoteServiceInterface getService() throws IllegalStateException {
        RemoteServiceInterface service;
        RemoteServiceInterface remoteServiceInterface = service = this._localService == null ? this._service : this._localService;
        if (service == null) {
            throw new IllegalStateException(RB.getStringResource("AbstractRemoteService.serviceDestroyed.txt"));
        }
        return service;
    }

    @Override
    public final void configure(ServiceConfigurationInterface serviceConfiguration) throws ServiceException, RemoteException {
        if (!this._isProxyInitialized) {
            this.initialize();
        }
        if (this._localService == null) {
            throw new IllegalStateException(RB.getStringResource("ServiceProxy.remoteReconfigurationNotSupported.ex.txt"));
        }
        this._localService.configure(serviceConfiguration);
    }

    @Override
    public final void reconfigure(ServiceConfigurationInterface serviceConfiguration) throws ServiceException, RemoteException, IllegalStateException {
        if (!this._isProxyInitialized) {
            this.initialize();
        }
        if (this._localService == null) {
            throw new IllegalStateException(RB.getStringResource("ServiceProxy.remoteReconfigurationNotSupported.ex.txt"));
        }
        this._localService.reconfigure(serviceConfiguration);
    }

    @Override
    public boolean isExported() throws ServiceException {
        boolean isExported = false;
        RemoteServiceInterface service = this.getService();
        RemoteException remoteException = null;
        try {
            if (service != null) {
                isExported = service.isExported();
            }
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        catch (RemoteException e) {
            throw ServiceProxy.newServiceNotAvailableException(e);
        }
        finally {
            if (remoteException != null) {
                try {
                    service = this.findRemoteService();
                    if (service == null) {
                        throw remoteException;
                    }
                    isExported = service.isExported();
                }
                catch (RemoteException ex) {
                    throw ServiceProxy.newServiceNotAvailableException(ex);
                }
            }
        }
        return isExported;
    }

    @Override
    public boolean isAccessibleToRemoteClients() throws ServiceException {
        boolean isAccessibleToRemoteClients = false;
        RemoteServiceInterface service = this.getService();
        RemoteException remoteException = null;
        try {
            if (service != null) {
                isAccessibleToRemoteClients = service.isAccessibleToRemoteClients();
            }
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        catch (RemoteException e) {
            throw ServiceProxy.newServiceNotAvailableException(e);
        }
        finally {
            if (remoteException != null) {
                try {
                    service = this.findRemoteService();
                    if (service == null) {
                        throw remoteException;
                    }
                    isAccessibleToRemoteClients = service.isAccessibleToRemoteClients();
                }
                catch (RemoteException ex) {
                    throw ServiceProxy.newServiceNotAvailableException(ex);
                }
            }
        }
        return isAccessibleToRemoteClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getCreationTime() {
        long creationTime = 0L;
        Serializable exception = null;
        try {
            if (!this._isProxyInitialized) {
                this.initialize();
            }
            creationTime = this._localService == null ? this._rmtServiceCreationTime : this._localService.getCreationTime();
        }
        catch (ServiceException e) {
            exception = e;
        }
        catch (RemoteException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                creationTime = 0L;
            }
        }
        return creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final short getServiceState() throws RemoteException {
        int serviceState = 0;
        RemoteServiceInterface service = null;
        try {
            service = this.getService();
        }
        catch (IllegalStateException e) {
            serviceState = 2;
        }
        RemoteException remoteException = null;
        try {
            if (!this._isProxyInitialized) {
                this.initialize();
            }
            if (service != null) {
                try {
                    serviceState = service.getServiceState();
                }
                catch (IllegalStateException e) {
                    serviceState = 2;
                }
            }
        }
        catch (ServiceException e) {
            serviceState = 0;
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    service = this.findRemoteService();
                    if (service == null) {
                        throw remoteException;
                    }
                    try {
                        serviceState = service.getServiceState();
                    }
                    catch (IllegalStateException e) {
                        serviceState = 2;
                    }
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return (short)serviceState;
    }

    @Override
    public final void setServiceState(ServiceState serviceState) throws ServiceException {
        try {
            if (!this._isProxyInitialized) {
                this.initialize();
            }
            if (this._localService == null) {
                throw new ServiceException(RB.getStringResource("ServiceProxy.serviceStateNotUpdateableRemotely.ex.txt"));
            }
            this._localService.setServiceState(serviceState);
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("ServiceProxy.serviceStateNotUpdated.ex.txt"));
        }
    }

    @Override
    public final ServiceConfigurationInterface getServiceConfiguration() {
        ServiceConfigurationInterface serviceConfiguration = null;
        try {
            if (!this._isProxyInitialized) {
                this.initialize();
            }
            serviceConfiguration = this._localService == null ? this._rmtServiceConfiguration : this._localService.getServiceConfiguration();
        }
        catch (ServiceException e) {
            serviceConfiguration = null;
        }
        catch (RemoteException e) {
            serviceConfiguration = null;
        }
        return serviceConfiguration;
    }

    @Override
    public final ServiceConfigurationInterface getServiceConfiguration(Object key) {
        ServiceConfigurationInterface serviceConfiguration = null;
        try {
            if (!this._isProxyInitialized) {
                this.initialize();
            }
            ServiceConfigurationInterface serviceConfigurationInterface = serviceConfiguration = this._localService == null ? this._rmtServiceConfiguration : this._localService.getServiceConfiguration();
            if (serviceConfiguration != null) {
                serviceConfiguration = serviceConfiguration.getServiceConfiguration(key);
            }
        }
        catch (ServiceException e) {
            serviceConfiguration = null;
        }
        catch (RemoteException e) {
            serviceConfiguration = null;
        }
        return serviceConfiguration;
    }

    @Override
    public RemoteServiceInterface getServiceProxy() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private final void initialize() throws ServiceException {
        if (!this._isProxyInitialized) {
            if (this._service == null) {
                throw new InitializationException(RB.getStringResource("ServiceProxy.nonNullServiceRequired.ex.txt"));
            }
            if (this.isProxyToRemoteService()) {
                remoteException = null;
                try {
                    discoverySvc = DiscoveryService.defaultInstance();
                    iter = discoverySvc.getLocalServices();
                    this._serviceId = this._service.getEntityKey();
                    localService = null;
                    while (iter.hasNext()) {
                        localService = (RemoteServiceInterface)iter.next();
                        if (null == localService || !Strings.equal((String)localService.getEntityKey(), (String)this._serviceId, (boolean)false, (boolean)false)) continue;
                        this._localService = localService;
                        break;
                    }
                    if (this._localService != null) ** GOTO lbl43
                    this._rmtServiceCreationTime = this._service.getCreationTime();
                    this._rmtServiceConfiguration = this._service.getServiceConfiguration();
                    if (this._rmtServiceConfiguration == null) ** GOTO lbl43
                    metadataSourceConfig = (MetadataSourceConfigurationInterface)this._rmtServiceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_METADATA_SOURCE);
                    if (metadataSourceConfig != null) {
                        this._rmtMetadataSource = metadataSourceConfig.getMetadataSource();
                    }
                    if ((serviceDiscoveryConfig = (ServiceDiscoveryConfigurationInterface)this._rmtServiceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY)) == null) ** GOTO lbl43
                    this._serviceTemplate = new ServiceTemplate(serviceDiscoveryConfig.getServiceTypes(), serviceDiscoveryConfig.getServiceAttributes());
                }
                catch (ConnectException e) {
                    remoteException = e;
                }
                catch (NoSuchObjectException e) {
                    remoteException = e;
                }
                catch (RemoteException e) {
                    cause = e.getLocalizedMessage();
                    if (cause == null) {
                        cause = "";
                    }
                    throw new ServiceException(remoteException, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceProxy.unableToInitialize.ex.fmt.txt", (Object)cause));
                }
                finally {
                    if (remoteException == null) ** GOTO lbl43
                    throwable = remoteException.getCause();
                    cause = remoteException.getLocalizedMessage();
                    if (throwable != null) {
                        cause = throwable.getLocalizedMessage();
                    }
                    throw new ServiceException(remoteException, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceProxy.unableToConnectToRemoteService.ex.fmt.txt", (Object)this._service, (Object)cause));
                }
            } else {
                this._localService = this._service;
            }
lbl43:
            // 6 sources

            this._isProxyInitialized = true;
        }
    }

    @Override
    public final void addServiceObserver(ServiceRemoteObserverInterface serviceObserver) throws RemoteException {
        RemoteServiceInterface service = this.getService();
        if (service != null) {
            service.addServiceObserver(serviceObserver);
        }
    }

    @Override
    public final void removeServiceObserver(ServiceRemoteObserverInterface serviceObserver) throws RemoteException {
        RemoteServiceInterface service = this.getService();
        if (service != null) {
            service.removeServiceObserver(serviceObserver);
        }
    }

    @Override
    public final void removeAllServiceObservers() throws RemoteException {
        if (this._localService != null) {
            this._localService.removeAllServiceObservers();
        }
    }

    @Override
    public final void notifyServiceObservers(ServiceEvent serviceEvent) throws RemoteException {
        RemoteServiceInterface service = this.getService();
        if (service != null) {
            service.notifyServiceObservers(serviceEvent);
        }
    }

    @Override
    public final void destroy() {
        if (!this._isDestroyed) {
            this._isDestroyed = true;
            Serializable exception = null;
            try {
                if (this._localService != null && !this.isProxyToRemoteService()) {
                    this._localService.destroy();
                }
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (ServiceException e) {
                exception = e;
            }
            finally {
                this._localService = null;
                this._isProxyInitialized = false;
                this._rmtServiceConfiguration = null;
                this._service = null;
                if (exception != null) {
                    LogManager.getLogger(ServiceProxy.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceProxy.destroy.ex.fmt.txt", (Object)this.getClass().getName()), (Throwable)exception);
                }
            }
        }
    }

    public final String getEntityKey() {
        if (this._serviceId == null && this._service != null) {
            try {
                this._serviceId = this._service.getEntityKey();
            }
            catch (RemoteException e) {
                LogManager.getLogger(ServiceProxy.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceProxy.getEntityKey.ex.fmt.log", (Object)this.getClass().getName()), (Throwable)e);
                this._serviceId = null;
            }
        }
        return this._serviceId;
    }

    public final void setEntityKey(String entityKey) {
        if (!this._isProxyInitialized) {
            try {
                this.initialize();
            }
            catch (ServiceException e) {
                LogManager.getLogger(ServiceProxy.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceProxy.initialize.ex.fmt.txt", (Object)this.getClass().getName()), (Throwable)((Object)e));
            }
        }
        if (this._localService != null) {
            try {
                this._localService.setEntityKey(entityKey);
            }
            catch (RemoteException e) {
                LogManager.getLogger(ServiceProxy.class).error(RB.getStringResource("RemoteException.ex.log"), (Throwable)e);
            }
        }
    }

    public final boolean sameEntity(EntityKeyInterface entity) {
        boolean isSame;
        boolean bl = isSame = this == entity;
        if (!isSame && entity != null) {
            try {
                if (!this._isProxyInitialized) {
                    this.initialize();
                }
                RemoteServiceInterface service = (RemoteServiceInterface)entity;
                isSame = Strings.equal((String)this._serviceId, (String)service.getEntityKey(), (boolean)false, (boolean)false);
            }
            catch (ClassCastException e) {
                isSame = false;
            }
            catch (ServiceException e) {
                isSame = false;
            }
            catch (RemoteException e) {
                isSame = false;
            }
        }
        return isSame;
    }

    public final boolean sameEnitityKey(String entityKey) {
        boolean isSame = false;
        try {
            if (!this._isProxyInitialized) {
                this.initialize();
            }
            isSame = Strings.equal((String)this.getEntityKey(), (String)entityKey, (boolean)false, (boolean)false);
        }
        catch (ServiceException e) {
            isSame = false;
        }
        return isSame;
    }

    private final void setService(RemoteServiceInterface service) throws InitializationException, IllegalArgumentException {
        if (service == null) {
            throw new InitializationException(RB.getStringResource("ServiceProxy.nonNullServiceRequired.ex.txt"));
        }
        this._service = service;
        try {
            this.initialize();
        }
        catch (ServiceException e) {
            throw new InitializationException((Throwable)((Object)e), e.getLocalizedMessage());
        }
    }

    public final boolean isProxyToRemoteService() {
        return this._service != null && (this._service instanceof Proxy || this._service instanceof RemoteObject || this._service instanceof ServiceProxy && !ID.equals(((ServiceProxy)this._service).getID()));
    }

    private final String getID() {
        return this._id;
    }

    private static final ServiceNotAvailableException newServiceNotAvailableException(Exception cause) {
        ServiceNotAvailableException exception = new ServiceNotAvailableException();
        exception.initCause(cause);
        return exception;
    }

    public final boolean isLocalService() {
        return this._localService != null;
    }

    private final ServiceTemplate getServiceTemplate() {
        ServiceTemplate serviceTemplate = null;
        try {
            if (this._serviceTemplate != null) {
                ServiceTypes serviceTypes = this._serviceTemplate.getServiceTypes();
                Class[] serviceInterfaces = serviceTypes == null ? new Class[]{} : serviceTypes.getClasses();
                ServiceAttributeInterface[] origServiceAttributes = this._serviceTemplate.getServiceAttributes();
                int numItems = origServiceAttributes == null ? 0 : origServiceAttributes.length;
                ArrayList<ServiceAttributeInterface> attributes = new ArrayList<ServiceAttributeInterface>(numItems);
                ServiceAttributeInterface serviceAttribute = null;
                for (int i = 0; i < numItems; ++i) {
                    serviceAttribute = origServiceAttributes[i];
                    try {
                        MetadataAttribute attribute = (MetadataAttribute)serviceAttribute;
                        if ("ABC1212121212".equals(attribute.classIdentifier) && "ServiceComponent".equals(attribute.elementType) && attribute.id != null && attribute.id.length() == 17) {
                            attributes.add(attribute);
                            continue;
                        }
                        if (!"ABC1234567890".equals(attribute.classIdentifier) || !"SoftwareComponent".equals(attribute.elementType) || attribute.id == null || attribute.id.length() != 17) continue;
                        attributes.add(attribute);
                        continue;
                    }
                    catch (ClassCastException e) {
                        if (!(serviceAttribute instanceof IsRemotelyAccessibleAttribute)) continue;
                        attributes.add(serviceAttribute);
                    }
                }
                ServiceAttributeInterface[] serviceAttributes = new ServiceAttributeInterface[attributes.size()];
                serviceAttributes = attributes.toArray(serviceAttributes);
                serviceTemplate = new ServiceTemplate(serviceInterfaces, serviceAttributes);
            }
        }
        catch (InitializationException e) {
            serviceTemplate = null;
        }
        return serviceTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteServiceInterface findRemoteService() throws ServiceException, RemoteException {
        RemoteServiceInterface service = null;
        ServiceProxy serviceProxy = this;
        synchronized (serviceProxy) {
            ServiceTemplate serviceTemplate = null;
            LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
            if (this._rmtMetadataSource instanceof AbstractMetadataSource) {
                AbstractMetadataSource metadataSource = (AbstractMetadataSource)this._rmtMetadataSource;
                try {
                    discoveryService.removeService(this);
                }
                catch (RemoteException e) {
                    LogManager.getLogger(ServiceProxy.class).error(RB.getStringResource("RemoteException.ex.log"), (Throwable)e);
                }
                if (metadataSource.lookupServices(discoveryService).size() > 0 && (serviceTemplate = this.getServiceTemplate()) != null) {
                    ServiceAttributeInterface[] svcAttributes = serviceTemplate.getServiceAttributes();
                    int numAttrs = svcAttributes == null ? 0 : svcAttributes.length;
                    ServiceAttributeInterface svcAttribute = null;
                    for (int i = 0; i < numAttrs; ++i) {
                        svcAttribute = svcAttributes[i];
                        if (!(svcAttribute instanceof ServiceComponentAttribute)) continue;
                        ServiceComponentAttribute svcComponentAttr = (ServiceComponentAttribute)svcAttribute;
                        svcComponentAttr.runtimeId = null;
                        break;
                    }
                    if ((service = discoveryService.findService(serviceTemplate)) != null) {
                        this._isProxyInitialized = false;
                        this.setService(service);
                    }
                }
            }
            if (service == null) {
                throw new ServiceNotAvailableException(serviceTemplate);
            }
        }
        return service;
    }
}

