/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.spi;

import com.sas.services.information.FilterInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.svcs.deployment.ApplicationContextUtil;
import com.sas.svcs.deployment.DeploymentDiscoveryService;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.ConfigurableObjectExtractor;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.dao.FilterFactory;
import com.sas.svcs.deployment.data.ConfigurableObject;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASEnvironment;
import com.sas.svcs.deployment.data.SASHost;
import com.sas.svcs.deployment.data.SASTier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DeploymentDiscoveryService")
public class DeploymentDiscovery
implements DeploymentDiscoveryService {
    @Autowired
    private DeploymentDiscoveryDAO discoveryDAO;
    @Autowired
    private ApplicationContextUtil discoverer;
    @Autowired
    private FilterFactory filterFactory;
    private static final Logger logger = LogManager.getLogger(DeploymentDiscovery.class);

    @Override
    public SASEnvironment discover() throws DiscoveryException {
        DeploymentDiscoveryDAO.ComponentType sasTier = DeploymentDiscoveryDAO.ComponentType.SAS_TIER;
        ConfigurableObjectExtractor extractor = this.discoverer.getExtractor(sasTier);
        List<SASTier> sasTiers = extractor.getConfigurableObjects(sasTier);
        SASEnvironment environment = new SASEnvironment();
        environment.setSasTiers(sasTiers);
        return environment;
    }

    @Override
    public List<ConfigurableObject> getConfigurableObjects(DeploymentDiscoveryDAO.ComponentType componentType) throws DiscoveryException {
        return null;
    }

    @Override
    public List<ConfigurableObject> getConfigurableObjects(SASTier sasTier) throws DiscoveryException {
        return null;
    }

    @Override
    public SASTier getConfiguredOn(DeploymentDiscoveryDAO.ComponentType componentType) throws DiscoveryException {
        return null;
    }

    @Override
    public List<ConfigurableServer> getConfigurableServers(DeploymentDiscoveryDAO.ComponentType componentType) throws DiscoveryException {
        if (this.isServerType(componentType)) {
            ConfigurableObjectExtractor extractor = this.discoverer.getExtractor(componentType);
            return extractor.getConfigurableObjects(componentType);
        }
        throw new DiscoveryException();
    }

    private boolean isServerType(DeploymentDiscoveryDAO.ComponentType type) {
        return true;
    }

    @Override
    public List<ConfigurableServer> getConfigurableServers(DeploymentDiscoveryDAO.ComponentType componentType, SASTier sasTier) throws DiscoveryException {
        List<ConfigurableServer> configServers = this.getConfigurableServers(componentType);
        ArrayList<ConfigurableServer> filteredServers = null;
        if (configServers != null) {
            filteredServers = new ArrayList<ConfigurableServer>();
            for (ConfigurableServer server : configServers) {
                if (!sasTier.equals(server.getSasTier())) continue;
                filteredServers.add(server);
            }
        }
        return filteredServers;
    }

    @Override
    public List<ConfigurableServer> getDatabaseServers() throws DiscoveryException {
        return null;
    }

    @Override
    public SASTier getSASTier(String hostName, String configDir) throws DiscoveryException {
        DeploymentDiscoveryDAO.ComponentType sasTier = DeploymentDiscoveryDAO.ComponentType.SAS_TIER;
        ConfigurableObjectExtractor extractor = this.discoverer.getExtractor(sasTier);
        List sasTiers = extractor.getConfigurableObjects(sasTier);
        if (sasTiers != null) {
            SASTier tierTobeRetrived = this.createSASTierInstance(hostName + "|" + configDir);
            for (SASTier sasTierInstance : sasTiers) {
                if (!tierTobeRetrived.equals(sasTierInstance)) continue;
                return sasTierInstance;
            }
        }
        return null;
    }

    @Override
    public ServerComponentInterface getServerComponent(String id) {
        if (id != null) {
            HashMap<String, String> filter = new HashMap<String, String>(1);
            filter.put("id", id);
            FilterInterface filterC = this.filterFactory.getAnyofFilter("ServerComponent", filter);
            List<ServerComponentInterface> servers = this.discoveryDAO.getDeploymentComponents(filterC, ServerComponentInterface.class);
            if (servers != null && servers.size() > 0) {
                ServerComponentInterface server = servers.get(0);
                logger.debug("Found server component '" + server + "' for id '" + id + "'");
                return server;
            }
            logger.warn("No server component found by Id '" + id + "'");
        }
        return null;
    }

    private SASTier createSASTierInstance(String hostAndConfigDir) {
        SASTier sastier = new SASTier();
        String[] strArray = hostAndConfigDir.split(Pattern.quote("|"), 2);
        if (strArray != null && strArray.length > 0) {
            SASHost tierHost = new SASHost();
            tierHost.setHostName(strArray[0]);
            sastier.setTierHost(tierHost);
            if (strArray.length > 1) {
                sastier.setSasConfig(strArray[1]);
            }
        }
        return sastier;
    }
}

