/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="SAS_WIP_DATA_SERVERExtractor")
public class WIPDataServerFilter {
    @Autowired
    private DeploymentDiscoveryDAO discoveryDAO;

    public List<ServerComponentInterface> filter(List<ServerComponentInterface> dataServers, DeploymentDiscoveryDAO.ComponentType dbType) throws DiscoveryException {
        ArrayList<ServerComponentInterface> servers = null;
        if (dataServers != null) {
            servers = new ArrayList<ServerComponentInterface>();
            for (ServerComponentInterface server : dataServers) {
                boolean isDbServer = this.isWIPDB(server);
                if (isDbServer && dbType.equals((Object)DeploymentDiscoveryDAO.ComponentType.SAS_WIP_DATA_SERVER)) {
                    servers.add(server);
                    continue;
                }
                if (isDbServer || !dbType.equals((Object)DeploymentDiscoveryDAO.ComponentType.SAS_SOL_DATA_SERVER)) continue;
                servers.add(server);
            }
        }
        return servers;
    }

    private boolean isWIPDB(ServerComponentInterface server) {
        boolean wipdb;
        block4: {
            List dependents = null;
            wipdb = false;
            try {
                dependents = server.getDependentComponents();
                if (dependents == null) break block4;
                for (MetadataInterface component : dependents) {
                    String classId;
                    if (!(component instanceof SoftwareComponentInterface) || !"webappsrv".equals(classId = ((SoftwareComponentInterface)component).getClassIdentifier())) continue;
                    wipdb = true;
                    break;
                }
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return wipdb;
    }
}

