/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.deployment.ApplicationContextUtil;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.ConfigurableObjectExtractor;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.dao.WIPDataServerFilter;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DataServerExtractor")
public class SolutionDataServerExtractor
implements ConfigurableObjectExtractor<ConfigurableServer> {
    @Autowired
    private ApplicationContextUtil discoverer;
    @Autowired
    private DeploymentDiscoveryDAO discoveryDAO;
    @Autowired
    private WIPDataServerFilter dataserverFilter;
    private static final Logger logger = LogManager.getLogger(SolutionDataServerExtractor.class);

    @Override
    public List<ConfigurableServer> getConfigurableObjects(DeploymentDiscoveryDAO.ComponentType componentType) throws DiscoveryException {
        List<ServerComponentInterface> dataServers = this.discoveryDAO.getDeploymentComponents(componentType, ServerComponentInterface.class);
        List<ServerComponentInterface> solDataServers = this.dataserverFilter.filter(dataServers, componentType);
        ArrayList<ConfigurableServer> solConfigurable = null;
        if (solDataServers != null) {
            solConfigurable = new ArrayList<ConfigurableServer>();
            for (ServerComponentInterface server : solDataServers) {
                solConfigurable.add(this.convert((SoftwareComponentInterface)server));
            }
        }
        return solConfigurable;
    }

    @Override
    public ConfigurableServer convert(SoftwareComponentInterface configurable) throws DiscoveryException {
        boolean isConfigurable;
        ConfigurableServer dataServer = new ConfigurableServer();
        SASTier sasTier = this.discoveryDAO.getDeployedOn(configurable);
        Properties properties = this.discoveryDAO.getConfigurableProperties(configurable);
        boolean bl = isConfigurable = properties != null;
        if (isConfigurable) {
            dataServer.setProperties(properties);
            if (sasTier != null) {
                dataServer.setSasTier(sasTier);
                dataServer.setSasTierId(sasTier.getTierName());
            }
        }
        try {
            logger.debug("configurable.getIdentifier() = " + configurable.getIdentifier());
            dataServer.setEntityId(configurable.getIdentifier());
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        dataServer.setObjectName(this.discoveryDAO.getName(configurable));
        return dataServer;
    }
}

