/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.ConfigurableObjectExtractor;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="SAS_APP_SERVERExtractor")
public class SASAppServerExtractor
implements ConfigurableObjectExtractor<ConfigurableServer> {
    @Autowired
    private DeploymentDiscoveryDAO discoveryDAO;
    private static final Logger logger = LogManager.getLogger(SASAppServerExtractor.class);

    @Override
    public List<ConfigurableServer> getConfigurableObjects(DeploymentDiscoveryDAO.ComponentType componetType) throws DiscoveryException {
        List<ServerContextInterface> sasAppServers = this.discoveryDAO.getDeploymentComponents(DeploymentDiscoveryDAO.ComponentType.SAS_APP_SERVER, ServerContextInterface.class);
        ConfigurableServer cServer = null;
        ArrayList<ConfigurableServer> cServers = null;
        if (sasAppServers != null) {
            cServers = new ArrayList<ConfigurableServer>(sasAppServers.size());
            for (ServerContextInterface server : sasAppServers) {
                cServer = this.convert((SoftwareComponentInterface)server);
                if (cServer == null) continue;
                cServers.add(cServer);
            }
        }
        return cServers;
    }

    @Override
    public ConfigurableServer convert(SoftwareComponentInterface configurable) throws DiscoveryException {
        Properties properties = this.discoveryDAO.getConfigurableProperties(configurable);
        ConfigurableServer server = new ConfigurableServer();
        server.setProperties(properties);
        SASTier sasTier = this.discoveryDAO.getDeployedOn(configurable);
        if (sasTier != null) {
            server.setSasTier(sasTier);
            server.setSasTierId(sasTier.getTierName());
        }
        try {
            logger.debug("configurable.getIdentifier() = " + configurable.getIdentifier());
            server.setEntityId(configurable.getIdentifier());
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        server.setObjectName(this.discoveryDAO.getName(configurable));
        server.setConfigurablePath(properties.getProperty("config.lev.appservercontext.dir"));
        return server;
    }
}

