/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.deployment.ApplicationContextUtil;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.ConfigurableObjectExtractor;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="METADATA_SERVERExtractor")
public class MetadataServerExtractor
implements ConfigurableObjectExtractor<ConfigurableServer> {
    @Autowired
    DeploymentDiscoveryDAO discoverDao;
    @Autowired
    ApplicationContextUtil discoverer;
    Logger logger = LogManager.getLogger(MetadataServerExtractor.class);

    @Override
    public List<ConfigurableServer> getConfigurableObjects(DeploymentDiscoveryDAO.ComponentType componetType) throws DiscoveryException {
        List<ServerComponentInterface> metadataServers = this.discoverDao.getDeploymentComponents(DeploymentDiscoveryDAO.ComponentType.METADATA_SERVER, ServerComponentInterface.class);
        ArrayList<ConfigurableServer> mServers = null;
        ConfigurableServer cServer = null;
        this.logger.debug("Number of metadata server extracted from ServerComponentInterface: " + metadataServers.size());
        if (metadataServers != null) {
            mServers = new ArrayList<ConfigurableServer>(metadataServers.size());
            for (ServerComponentInterface server : metadataServers) {
                cServer = this.convert((SoftwareComponentInterface)server);
                if (cServer != null) {
                    mServers.add(cServer);
                    continue;
                }
                this.logger.debug("Unable to extract configurable properties for " + server + " from ServerComponent.So trying to find config property from LogicalServer Component");
                List<LogicalServerInterface> logicalServerComponent = this.discoverDao.getDeploymentComponents(DeploymentDiscoveryDAO.ComponentType.METADATA_SERVER1, LogicalServerInterface.class);
                if (logicalServerComponent == null) continue;
                for (LogicalServerInterface server1 : logicalServerComponent) {
                    cServer = this.convert((SoftwareComponentInterface)server1);
                    if (cServer != null) {
                        mServers.add(cServer);
                        continue;
                    }
                    this.logger.debug("Unable to extract configurable properties for " + server1 + "  . Skipping the server.");
                }
            }
        }
        return mServers;
    }

    @Override
    public ConfigurableServer convert(SoftwareComponentInterface configurable) throws DiscoveryException {
        ConfigurableServer metaServer = null;
        Properties properties = this.discoverDao.getConfigurableProperties(configurable);
        SASTier sasTier = this.discoverDao.getDeployedOn(configurable);
        if (sasTier != null && properties != null) {
            metaServer = new ConfigurableServer();
            metaServer.setSasTier(sasTier);
            metaServer.setSasTierId(sasTier.getTierName());
            metaServer.set_12Byte("metadatasrv");
            try {
                this.logger.debug("configurable.getIdentifier() = " + configurable.getIdentifier());
                metaServer.setEntityId(configurable.getIdentifier());
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            metaServer.setObjectName(this.discoverDao.getName(configurable));
            metaServer.setProperties(properties);
        }
        return metaServer;
    }
}

