/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.deployment.dao;

import com.sas.services.ServiceException;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.svcs.deployment.ApplicationContextUtil;
import com.sas.svcs.deployment.DiscoveryException;
import com.sas.svcs.deployment.dao.ConfigurableObjectExtractor;
import com.sas.svcs.deployment.dao.DeploymentDiscoveryDAO;
import com.sas.svcs.deployment.dao.FilterFactory;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASTier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CONTENT_SERVERExtractor")
public class ContentServerExtractor
implements ConfigurableObjectExtractor<ConfigurableServer> {
    @Autowired
    private ApplicationContextUtil discoverer;
    @Autowired
    private DeploymentDiscoveryDAO discoveryDAO;
    @Autowired
    private FilterFactory filterFactory;
    private static Logger logger = LogManager.getLogger(ContentServerExtractor.class);

    @Override
    public List<ConfigurableServer> getConfigurableObjects(DeploymentDiscoveryDAO.ComponentType componentType) throws DiscoveryException {
        SoftwareComponentInterface wipConfigurable = this.getWIPConfigurable();
        ArrayList<ConfigurableServer> content = null;
        if (wipConfigurable != null) {
            content = new ArrayList<ConfigurableServer>(1);
            content.add(this.convert(wipConfigurable));
        }
        return content;
    }

    @Override
    public ConfigurableServer convert(SoftwareComponentInterface configurable) throws DiscoveryException {
        ConfigurableServer contentServer = new ConfigurableServer();
        SASTier sasTier = this.discoveryDAO.getDeployedOn(configurable);
        if (sasTier != null) {
            contentServer.setSasTier(sasTier);
            contentServer.setSasTierId(sasTier.getTierName());
        }
        contentServer.set_12Byte("webinpltfm");
        ServerComponentInterface contentServerEntity = this.getContentServer();
        try {
            String id = contentServerEntity.getIdentifier();
            logger.debug("contentServerEntity.getIdentifier() = " + id);
            contentServer.setEntityId(id);
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        contentServer.setObjectName(this.discoveryDAO.getName((SoftwareComponentInterface)contentServerEntity));
        contentServer.setProperties(this.discoveryDAO.getConfigurableProperties(configurable));
        return contentServer;
    }

    private SoftwareComponentInterface getWIPConfigurable() {
        List<SoftwareComponentInterface> wipConfigurables = this.discoveryDAO.getDeploymentComponents(DeploymentDiscoveryDAO.ComponentType.CONTENT_SERVER, SoftwareComponentInterface.class);
        SoftwareComponentInterface wipConfigurable = null;
        if (wipConfigurables != null && wipConfigurables.size() > 0) {
            wipConfigurable = wipConfigurables.get(0);
        }
        return wipConfigurable;
    }

    private ServerComponentInterface getContentServer() {
        HashMap<String, String> filter = new HashMap<String, String>(1);
        filter.put("name", "SAS Content Server");
        FilterInterface filterC = this.filterFactory.getAnyofFilter("ServerComponent", filter);
        List<ServerComponentInterface> wipConfigurables = this.discoveryDAO.getDeploymentComponents(filterC, ServerComponentInterface.class);
        return wipConfigurables != null && wipConfigurables.size() > 0 ? wipConfigurables.get(0) : null;
    }
}

