/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.session;

import com.sas.vfabrictcsvr.session.SessionFixationSupport;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.context.ServletContextAware;

public class SessionFixationSupportListener
implements HttpSessionListener,
ServletContextAware {
    private static final Logger logger = LogManager.getLogger(SessionFixationSupportListener.class);

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        SessionFixationSupport.getInstance().unregisterHttpSession(session);
        logger.debug("Session " + session.getId() + " destroyed in context: " + session.getServletContext().getContextPath());
    }

    public void setServletContext(ServletContext servletContext) {
        servletContext.addListener(SessionFixationSupportListener.class);
    }
}

