/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.providers;

import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientAware;
import com.sas.svcs.security.authentication.web.RevokableAuthentication;
import com.sas.svcs.security.authentication.web.providers.AbstractAuthenticationClientProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.authentication.StatelessTicketCache;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class CasTgtAuthenticationProvider
extends AbstractAuthenticationClientProvider
implements AuthenticationProvider {
    private static final Logger logger = LogManager.getLogger(CasTgtAuthenticationProvider.class);
    public static final String CAS_TGT_PREFIX = "TGT-";
    protected StatelessTicketCache ticketCache;

    public void setTicketCache(StatelessTicketCache ticketCache) {
        this.ticketCache = ticketCache;
    }

    @Override
    protected boolean canAuthenticate(Authentication authentication) {
        return super.canAuthenticate(authentication) && authentication.getPrincipal().toString().startsWith(CAS_TGT_PREFIX);
    }

    @Override
    protected AuthenticationClient getAuthenticationClient(Authentication authentication) {
        AuthenticationClient authClient = new AuthenticationClient(this.getCasUrl(), authentication.getCredentials().toString());
        this.initialize(authClient);
        return authClient;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if ((authentication = super.authenticate(authentication)) instanceof RevokableAuthentication) {
            ((RevokableAuthentication)authentication).setStateless(false);
        }
        return authentication;
    }

    @Override
    protected Object getCredentialAfterAuthentication(Authentication originalAuthentication, String validTicket, Assertion assertion, UserDetails details) {
        return originalAuthentication.getCredentials();
    }

    @Override
    protected Authentication getCachedAuthentication(Authentication originalAuthentication) {
        if (null != this.ticketCache) {
            CasAuthenticationToken auth = this.ticketCache.getByTicketId(originalAuthentication.getCredentials().toString());
            if (auth instanceof AuthenticationClientAware) {
                AuthenticationClientAware clientAware;
                if (logger.isDebugEnabled()) {
                    logger.debug("Found instance of AuthenticationClientAware");
                }
                if (null == (clientAware = (AuthenticationClientAware)auth).getAuthenticationClient()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Authentication client was not set on AuthenticationClientAware instance. Creating new client");
                    }
                    clientAware.setAuthenticationClient(this.getAuthenticationClient((Authentication)auth));
                }
            }
            return auth;
        }
        return super.getCachedAuthentication(originalAuthentication);
    }

    @Override
    protected void cacheAuthentication(Authentication original, Authentication newAuthentication) {
        if (null != this.ticketCache && newAuthentication instanceof CasAuthenticationToken) {
            if (logger.isDebugEnabled()) {
                logger.debug("Caching CasAuthenticationToken");
            }
            this.ticketCache.putTicketInCache((CasAuthenticationToken)newAuthentication);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Could not cache authentication token of class " + newAuthentication.getClass().getName());
        }
    }
}

