/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class TgtKeepAliveFilter
extends OncePerRequestFilter {
    private static final String LAST_PROXY_TICKET_TIME = "LAST_PROXY_TICKET_TIME";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authToken = securityContext.getAuthentication();
        if (authToken instanceof CasAuthenticationToken) {
            CasAuthenticationToken casToken = (CasAuthenticationToken)authToken;
            AttributePrincipal casPrincipal = casToken.getAssertion().getPrincipal();
            HttpSession session = request.getSession(false);
            if (null != session) {
                long lastTouchedTime;
                long timeWithoutTouch;
                long currentTime = System.currentTimeMillis();
                Long lastTouchedTimeObj = (Long)session.getAttribute(LAST_PROXY_TICKET_TIME);
                if (null == lastTouchedTimeObj) {
                    lastTouchedTimeObj = currentTime;
                    session.setAttribute(LAST_PROXY_TICKET_TIME, (Object)lastTouchedTimeObj);
                }
                if ((timeWithoutTouch = currentTime - (lastTouchedTime = lastTouchedTimeObj.longValue())) > 600000L) {
                    casPrincipal.getProxyTicketFor("http://tgt.keepali.ve");
                    session.setAttribute(LAST_PROXY_TICKET_TIME, (Object)currentTime);
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

