/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.filter.OncePerRequestFilter;

public class BasicAuthSessionTimeoutFilter
extends OncePerRequestFilter {
    private static final Logger logger = LogManager.getLogger(BasicAuthSessionTimeoutFilter.class);
    private int inactiveTimeout = 60;

    public void setInactiveTimeout(int inactiveTimeout) {
        this.inactiveTimeout = inactiveTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String header = request.getHeader("Authorization");
            if (header != null && header.startsWith("Basic ")) {
                logger.debug("Found basic authentication header, looking for session");
                HttpSession session = request.getSession(false);
                if (null != session) {
                    logger.debug("Setting HTTP session timeout to " + this.inactiveTimeout + " seconds for session " + session.getId() + " with basic auth headers");
                    session.setMaxInactiveInterval(this.inactiveTimeout);
                }
            }
        }
        finally {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

