/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.web.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.util.StringUtils;

public class HttpSessionSecurityContextRepository
extends org.springframework.security.web.context.HttpSessionSecurityContextRepository {
    private static final String AUTHENTICATION_PROCESSED = "authentication_processed";
    String useridField = "_username";
    String passwordField = "_password";

    public void setUseridField(String useridField) {
        this.useridField = useridField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest request = requestResponseHolder.getRequest();
        String userid = this.getUserid(request);
        String password = this.getPassword(request);
        String authenticationProcessed = this.getAuthenticationProcessed(request);
        if (StringUtils.hasText((String)userid) && StringUtils.hasText((String)password) && !StringUtils.hasText((String)authenticationProcessed)) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            requestResponseHolder.setRequest((HttpServletRequest)new QueryStringHttpServletRequestWrapper(request, this.useridField, userid, this.passwordField, password));
        }
        return super.loadContext(requestResponseHolder);
    }

    private String getAuthenticationProcessed(HttpServletRequest request) {
        String authenticationProcessed = null;
        HttpSession session = request.getSession(false);
        if (null != session) {
            authenticationProcessed = (String)session.getAttribute(AUTHENTICATION_PROCESSED);
        }
        return authenticationProcessed;
    }

    private String getPassword(HttpServletRequest request) {
        String password = (String)request.getAttribute(this.passwordField);
        if (password == null) {
            password = request.getParameter(this.passwordField);
        }
        return password;
    }

    private String getUserid(HttpServletRequest request) {
        String userid = (String)request.getAttribute(this.useridField);
        if (userid == null) {
            userid = request.getParameter(this.useridField);
        }
        return userid;
    }

    static class QueryStringHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private String username;
        private String password;
        private String useridField;
        private String passwordField;

        public QueryStringHttpServletRequestWrapper(HttpServletRequest request, String useridField, String user, String passwordField, String pass) {
            super(request);
            this.username = user;
            this.password = pass;
            this.useridField = useridField;
            this.passwordField = passwordField;
        }

        public String getQueryString() {
            String queryString = super.getQueryString();
            this.getSession().setAttribute(HttpSessionSecurityContextRepository.AUTHENTICATION_PROCESSED, (Object)"true");
            return queryString;
        }

        public String getParameter(String name) {
            if (name.equalsIgnoreCase(this.useridField)) {
                return this.username;
            }
            if (name.equalsIgnoreCase(this.passwordField)) {
                return this.password;
            }
            return super.getParameter(name);
        }
    }
}

