/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.ticket.cache;

import com.sas.svcs.authentication.helper.UserSessionFactory;
import com.sas.svcs.security.authentication.ticket.cache.GemFireBasedTicketCache;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class TGTStatelessCacheListener
extends CacheListenerAdapter<Object, Object> {
    private static final Logger LOGGER = LogManager.getLogger(TGTStatelessCacheListener.class);
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 10, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
    private UserSessionFactory userSessionFactory;

    @Autowired(required=false)
    public void setUserSessionFactory(UserSessionFactory userSessionFactory) {
        this.userSessionFactory = userSessionFactory;
    }

    @Autowired
    public void setStatelessTicketCache(GemFireBasedTicketCache statelessTicketCache) {
        statelessTicketCache.getRegion().getAttributesMutator().addCacheListener((CacheListener)this);
    }

    public void afterDestroy(final EntryEvent<Object, Object> event) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                TGTStatelessCacheListener.this.userSessionFactory.removeTicket((String)event.getKey());
            }
        };
        try {
            if (this.userSessionFactory != null) {
                this.executor.execute(task);
            }
        }
        catch (RejectedExecutionException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executor is at capacity. Running UserSessionFactory cleanup on current thread.");
            }
            task.run();
        }
    }
}

