/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.ticket.cache;

import com.sas.svcs.data.caches.gemfire.ApplicationContextProvider;
import com.sas.svcs.security.authentication.ticket.cache.GemFireBasedTicketCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.springframework.context.ApplicationContext;

public class GemFireBasedPGTCache
implements ProxyGrantingTicketStorage {
    private static final String PROXY_GRANTING_TICKET_REGION = "proxy_granting_ticket_region";
    private static final Logger logger = LogManager.getLogger(GemFireBasedTicketCache.class);
    private volatile Region<Object, Object> region = null;
    private final Object regionLock = new Object();
    private long timeout = 60000L;

    public GemFireBasedPGTCache() {
    }

    public GemFireBasedPGTCache(long timeout) {
        this.timeout = timeout;
    }

    public void save(String proxyGrantingTicketIou, String proxyGrantingTicket) {
        if (logger.isDebugEnabled()) {
            logger.debug("Saving ProxyGrantingTicketIou and ProxyGrantingTicket combo: [" + proxyGrantingTicketIou + ", " + proxyGrantingTicket + "]");
        }
        HashMap<String, Long> ticketWithTime = new HashMap<String, Long>();
        ticketWithTime.put(proxyGrantingTicket, System.currentTimeMillis());
        this.getRegion().put((Object)proxyGrantingTicketIou, ticketWithTime);
    }

    public String retrieve(String proxyGrantingTicketIou) {
        Map ticketWithTime;
        Map map = ticketWithTime = null == proxyGrantingTicketIou ? null : (Map)this.getRegion().remove((Object)proxyGrantingTicketIou);
        if (null == ticketWithTime) {
            if (logger.isDebugEnabled()) {
                logger.debug("No ProxyGrantingTicket found for " + proxyGrantingTicketIou);
            }
            return null;
        }
        String ticket = ticketWithTime.keySet().toArray(new String[0])[0];
        if (logger.isDebugEnabled()) {
            logger.debug("Getting ProxyGrantingTicket with IOU: " + proxyGrantingTicketIou + " value: " + ticket);
        }
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Region<Object, Object> region;
        Region<Object, Object> region2 = region = this.getRegion();
        synchronized (region2) {
            Set keys = region.keySet();
            for (Object key : keys) {
                Map ticketWithTime = (Map)region.get(key);
                Long creationTime = ticketWithTime.values().toArray(new Long[0])[0];
                if (creationTime + this.timeout >= System.currentTimeMillis()) continue;
                region.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region<Object, Object> getRegion() {
        Region result = this.region;
        if (null == result) {
            Object object = this.regionLock;
            synchronized (object) {
                result = this.region;
                if (null == result) {
                    ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
                    if (null != applicationContext) {
                        String gemfireRegionName = ApplicationContextProvider.getGemfireRegionName();
                        Region parentRegion = (Region)applicationContext.getBean(gemfireRegionName);
                        this.region = result = parentRegion.getSubregion(PROXY_GRANTING_TICKET_REGION);
                        if (null == this.region) {
                            this.region = result = parentRegion.createSubregion(PROXY_GRANTING_TICKET_REGION, parentRegion.getAttributes());
                        }
                    }
                    if (null == result) {
                        throw new IllegalStateException("Could not find gemfire region");
                    }
                }
            }
        }
        return result;
    }
}

