/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.session.jasig;

import com.sas.svcs.security.authentication.session.jasig.TicketSessionMappingListener;
import java.io.StringReader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SingleSignOutHandler {
    private static final String TICKET_SESSION_LISTENER = "_TICKET_SESSION_LISTENER";
    private static Logger log = LogManager.getLogger(SingleSignOutHandler.class);
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String artifactParameterName = "ticket";
    private String logoutParameterName = "logoutRequest";
    boolean sessionMigrationEnabled = false;
    private final XmlReaderPool xmlReaderPool = new XmlReaderPool();

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.sessionMappingStorage = storage;
        SingleSignOutFilter filter = new SingleSignOutFilter();
        filter.setSessionMappingStorage(storage);
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public String getArtifactParameterName() {
        return this.artifactParameterName;
    }

    public void setArtifactParameterName(String name) {
        this.artifactParameterName = name;
    }

    public String getLogoutParameterName() {
        return this.logoutParameterName;
    }

    public void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    public void setSessionMigrationEnabled(boolean sessionMigrationEnabled) {
        this.sessionMigrationEnabled = sessionMigrationEnabled;
    }

    public void init() {
        CommonUtils.assertNotNull((Object)this.artifactParameterName, (String)"artifactParameterName cannot be null.");
        CommonUtils.assertNotNull((Object)this.logoutParameterName, (String)"logoutParameterName cannot be null.");
        CommonUtils.assertNotNull((Object)this.sessionMappingStorage, (String)"sessionMappingStorage cannot be null.");
    }

    public boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName));
    }

    public boolean isLogoutRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName));
    }

    public void recordSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String token = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName);
        if (log.isDebugEnabled()) {
            log.debug("Recording session for token " + token);
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding Session (" + session.getId() + ") to SessionMappingMapping storage");
        }
        if (!this.sessionMigrationEnabled) {
            this.sessionMappingStorage.addSessionById(token, session);
        } else if (null == session.getAttribute(TICKET_SESSION_LISTENER)) {
            session.setAttribute(TICKET_SESSION_LISTENER, (Object)new TicketSessionMappingListener(token, this.sessionMappingStorage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(HttpServletRequest request) {
        HttpSession session;
        String logoutMessage = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName);
        if (log.isTraceEnabled()) {
            log.trace("Logout request:\n" + logoutMessage);
        }
        XMLReader xmlReader = this.xmlReaderPool.getXmlReader();
        StringBuilder tokenBuilder = new StringBuilder();
        this.initSessionIndexHandler(xmlReader, tokenBuilder);
        String token = null;
        try {
            xmlReader.parse(new InputSource(new StringReader(logoutMessage)));
            token = tokenBuilder.toString();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            token = null;
        }
        finally {
            this.xmlReaderPool.release(xmlReader);
        }
        if (CommonUtils.isNotBlank((String)token) && (session = this.sessionMappingStorage.removeSessionByMappingId(token)) != null) {
            String sessionID = session.getId();
            if (log.isDebugEnabled()) {
                log.debug("Invalidating session [" + sessionID + "] for token [" + token + "]");
            }
            try {
                session.invalidate();
            }
            catch (IllegalStateException e) {
                log.debug("Error invalidating session.", (Throwable)e);
            }
        }
    }

    private void initSessionIndexHandler(XMLReader xmlReader, final StringBuilder tokenBuilder) {
        DefaultHandler sessionIndexHandler = new DefaultHandler(){
            private boolean foundElement = false;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals("SessionIndex")) {
                    this.foundElement = true;
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (localName.equals("SessionIndex")) {
                    this.foundElement = false;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.foundElement) {
                    tokenBuilder.append(ch, start, length);
                }
            }
        };
        xmlReader.setContentHandler(sessionIndexHandler);
        xmlReader.setErrorHandler(sessionIndexHandler);
    }

    private class XmlReaderPool {
        private BlockingQueue<XMLReader> readers = new ArrayBlockingQueue<XMLReader>(5);

        private XmlReaderPool() {
        }

        public synchronized XMLReader getXmlReader() {
            if (!this.readers.isEmpty()) {
                return (XMLReader)this.readers.remove();
            }
            return this.createReader();
        }

        public synchronized void release(XMLReader reader) {
            if (this.readers.remainingCapacity() > 0) {
                this.readers.add(reader);
            }
        }

        private XMLReader createReader() {
            XMLReader xmlReader;
            try {
                xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create XMLReader", e);
            }
            return xmlReader;
        }
    }
}

