/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.provider;

import com.sas.svcs.security.authentication.resolver.ServiceResolver;
import java.util.Collections;
import javax.servlet.ServletContext;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAssertionAuthenticationToken;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.authentication.StatelessTicketCache;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.context.ServletContextAware;

public class AuthenticationProvider
implements org.springframework.security.authentication.AuthenticationProvider,
ServletContextAware {
    CasAuthenticationProvider authProvider;
    String contextPath;
    UserDetailsService userDetailsService;
    StatelessTicketCache statelessTicketCache;
    ServiceResolver serviceResolver;
    String entryPoint = "login/cas";
    @Autowired
    TicketValidator ticketValidator;

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setStatelessTicketCache(StatelessTicketCache statelessTicketCache) {
        this.statelessTicketCache = statelessTicketCache;
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setServletContext(ServletContext servletContext) {
        this.contextPath = servletContext.getContextPath();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.getAuthProvider().authenticate(authentication);
    }

    public boolean supports(Class<?> klass) {
        return this.getAuthProvider().supports(klass);
    }

    private synchronized org.springframework.security.authentication.AuthenticationProvider getAuthProvider() {
        if (null == this.authProvider) {
            this.authProvider = new CasAuthenticationProvider();
            ServiceProperties serviceProperties = new ServiceProperties();
            serviceProperties.setService(this.serviceResolver.getService(this.entryPoint, true));
            this.authProvider.setServiceProperties(serviceProperties);
            this.authProvider.setKey(this.contextPath);
            this.authProvider.setTicketValidator(this.ticketValidator);
            if (null != this.statelessTicketCache) {
                this.authProvider.setStatelessTicketCache(this.statelessTicketCache);
            }
            this.authProvider.setAuthenticationUserDetailsService((AuthenticationUserDetailsService)new UserDetailsByNameServiceWrapper<CasAssertionAuthenticationToken>(this.userDetailsService){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public UserDetails loadUserDetails(CasAssertionAuthenticationToken authentication) throws UsernameNotFoundException {
                    UsernamePasswordAuthenticationToken preAuthToken = new UsernamePasswordAuthenticationToken((Object)authentication.getName(), (Object)"", Collections.emptySet());
                    Authentication authBefore = SecurityContextHolder.getContext().getAuthentication();
                    SecurityContextHolder.getContext().setAuthentication((Authentication)preAuthToken);
                    try {
                        UserDetails userDetails = super.loadUserDetails((Authentication)authentication);
                        return userDetails;
                    }
                    finally {
                        SecurityContextHolder.getContext().setAuthentication(authBefore);
                    }
                }
            });
        }
        return this.authProvider;
    }
}

