/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.requests;

import MITI.bridges.javabridgeinterface.AccessHistoryOptions;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.javabridgeinterface.MimbGenericKeyValueOptions;
import MITI.bridges.javabridgeinterface.MimbGenericOperationOptions;
import MITI.mimb.executable.requests.BridgeRunRequest;
import MITI.mimb.executable.requests.Request;
import MITI.mimb.message.XmlUtil;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericOperationRequest
extends Request {
    private static final String ID = "RunMimbGenericOperationRequest";
    private static final String XML_IMPORT = "Import";
    protected BridgeRunRequest importRequest;
    protected MimbGenericOperationOptions options;

    @Override
    public void parse(Element element) {
        Element element2;
        super.parse(element);
        Element element3 = MITI.util.XmlUtil.getFirstElement(element, XML_IMPORT);
        if (element3 != null) {
            this.importRequest = new BridgeRunRequest();
            this.importRequest.parse(element3);
        }
        if ((element2 = MITI.util.XmlUtil.getFirstElement(element, "GenericOperation")) != null) {
            String string = element2.getAttribute("path");
            String string2 = element2.getAttribute("name");
            this.options = "DataQuality".equals(string2) ? new DataQualityOptions() : ("AccessHistory".equals(string2) ? new AccessHistoryOptions() : new MimbGenericKeyValueOptions(string2));
            this.options.setOutputPath(string);
            this.options.valueOf(XmlUtil.getGenericOperationOptions((Element)element2));
        }
    }

    public BridgeRunRequest getImportRequest() {
        return this.importRequest;
    }

    public void setImportRequest(BridgeRunRequest bridgeRunRequest) {
        this.importRequest = bridgeRunRequest;
    }

    public MimbGenericOperationOptions getOptions() {
        return this.options;
    }

    public void setOptions(MimbGenericOperationOptions mimbGenericOperationOptions) {
        this.options = mimbGenericOperationOptions;
    }

    @Override
    public String toString() {
        Document document;
        try {
            document = MITI.util.XmlUtil.getDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return parserConfigurationException.toString();
        }
        Element element = document.createElement(GenericOperationRequest.getId());
        document.appendChild(element);
        this.serialize(document, element);
        String string = this.toString(document, element);
        return string;
    }

    protected void serialize(Document document, Element element) {
        Element element2;
        if (this.getLanguage() != null) {
            element.setAttribute("language", this.getLanguage());
        }
        if (this.getUserIdentity() != null) {
            element.setAttribute("userIdentity", this.getUserIdentity());
        }
        if (this.importRequest != null) {
            element2 = document.createElement(XML_IMPORT);
            element.appendChild(element2);
            this.importRequest.serialize(document, element2);
        }
        if (this.options != null) {
            element2 = document.createElement("GenericOperation");
            element.appendChild(element2);
            element2.setAttribute("path", this.options.getOutputDir().getAbsolutePath());
            element2.setAttribute("name", this.options.getName());
            XmlUtil.addGenericOperationOptions((Element)element2, (Collection)this.options.getOptions());
        }
    }

    static String getId() {
        return ID;
    }
}

