/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.requests;

import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.mimb.executable.requests.Request;
import MITI.util.XmlUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeRunRequest
extends Request {
    protected MimbOptions userOptions = new MimbOptions();
    protected String bridgeId = "";
    protected String bridgeDisplayName = "";
    protected boolean disableLog = false;
    protected HashMap<String, String> vaultOptions = new HashMap();

    @Override
    public void parse(Element element) {
        Node node;
        Object object;
        super.parse(element);
        this.bridgeId = element.getAttribute("bridgeIdentifier");
        this.bridgeDisplayName = element.getAttribute("bridgeDisplayName");
        if (this.bridgeDisplayName == null || this.bridgeDisplayName.isEmpty()) {
            this.bridgeDisplayName = this.bridgeId;
        }
        this.disableLog = element.getAttribute("disableLog").equals("true");
        Element element2 = XmlUtil.getFirstElement(element, "SecretVault");
        if (element2 != null && (object = element2.getAttributes()) != null) {
            for (int i = 0; i < object.getLength(); ++i) {
                node = object.item(i);
                this.vaultOptions.put(node.getNodeName(), node.getNodeValue());
            }
        }
        object = XmlUtil.getChildElements(element, "BridgeParameter");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            node = (Element)iterator.next();
            String string = node.getAttribute("bridgeParameterIdentifier");
            String string2 = XmlUtil.getElementValue(node);
            String string3 = node.getAttribute("clientSpecifiedText");
            if (string.equals("Worker Threads")) {
                string = "Multiple threads";
            }
            this.userOptions.addOption(string, string2, string3);
        }
    }

    protected void serialize(Document document, Element element) {
        element.setAttribute("userIdentity", this.userIdentity);
        element.setAttribute("bridgeIdentifier", this.bridgeId);
        element.setAttribute("bridgeDisplayName", this.bridgeDisplayName);
        element.setAttribute("disableLog", this.disableLog ? "true" : "false");
        for (MimbOption mimbOption : this.userOptions) {
            Element element2 = document.createElement("BridgeParameter");
            element.appendChild(element2);
            element2.setAttribute("bridgeParameterIdentifier", mimbOption.getName());
            element2.setAttribute("clientSpecifiedText", mimbOption.getClientSpecifiedText());
            XmlUtil.setElementValue(element2, mimbOption.getValue());
        }
    }

    public String getBridgeId() {
        return this.bridgeId;
    }

    public String getBridgeDisplayName() {
        return this.bridgeDisplayName;
    }

    public MimbOptions getUserOptions() {
        return this.userOptions;
    }

    public HashMap<String, String> getVaultOptions() {
        return this.vaultOptions;
    }

    public void setBridgeId(String string) {
        this.bridgeId = string;
    }

    public void setBridgeDisplayName(String string) {
        this.bridgeDisplayName = string;
    }

    public void setUserOptions(MimbOptions mimbOptions) {
        this.userOptions = mimbOptions;
    }

    public void setVaultOptions(Map<String, String> map) {
        if (map != null) {
            this.vaultOptions.putAll(map);
        }
    }

    public boolean getDisablelog() {
        return this.disableLog;
    }

    public void setDisableLog(boolean bl) {
        this.disableLog = bl;
    }

    @Override
    public String toString() {
        return null;
    }
}

