/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.executable.oem;

import MITI.mimb.executable.oem.OemBridgeFilter;
import MITI.util.text.BridgeSpecificationLiteral;

public enum OEMCode {
    OEM_ADAPTIVE("AdapativePete2004", OemBridgeFilter.MIMB_BRIDGES, new OemBridgeFilter("MITI")),
    OEM_BO_MM("BusinessObjectsMetadataManager", OemBridgeFilter.MIMB_BRIDGES, new OemBridgeFilter("MITI")),
    OEM_CA_ERWIN("CA 2015 #HrX4^owjyWk", new OemBridgeFilter("CaErwin*"), new OemBridgeFilter("CaErwin*", "MITI")),
    OEM_COMPOSITE(null, new OemBridgeFilter("MITI"), new OemBridgeFilter("MITI")),
    OEM_COGNOS_RNFRAMEWORKMANAGER("Cognos FrameworkManager_#t8s96&a2@1.g", new OemBridgeFilter("CognosRnFrameworkManager*"), new OemBridgeFilter("CognosRnFrameworkManager*", "MITI")),
    OEM_EMBARCADERO_ERSTUDIO("Emba 2015 #GiaD5^upZsx", new OemBridgeFilter("EmbarcaderoErStudio"), new OemBridgeFilter("CaErwin35Erx", "EmbarcaderoErStudioDM1", "MITI")),
    OEM_IBM_RATIONALDATAARCHITECT("IBM Infosphere DA_#19$8hDTj7,p*{", new OemBridgeFilter("IbmRationalDataArchitect"), new OemBridgeFilter("IbmRationalDataArchitect", "MITI")),
    OEM_IBM_WISCMXML("IBM InfoSphere Information Server", new OemBridgeFilter("IbmWisCm*"), new OemBridgeFilter("IbmWisCm*", "IbmImwMaps*", "IbmOpenIGC", "MITI")),
    OEM_INFORMATICA_DEVELOPER("INFA2010Developer", new OemBridgeFilter("InformaticaDeveloper"), new OemBridgeFilter("InformaticaDeveloper", "MITI")),
    OEM_INFORMATICA_METADATAMANAGER("InformaticaMetadataManager", OemBridgeFilter.MIMB_BRIDGES, new OemBridgeFilter("InformaticaSuperGlue", "MITI")),
    OEM_INFORMATICA_POWERCENTER("InformaticaPowerCenter_#i9spV3$0-<lfE)", new OemBridgeFilter("InformaticaPowerCenter"), new OemBridgeFilter("InformaticaPowerCenter", "MITI")),
    OEM_INFORMATICA_SUPERGLUE(null, OemBridgeFilter.MIMB_BRIDGES, new OemBridgeFilter("InformaticaSuperGlue", "MITI")),
    OEM_KALIDO_DIW(null, new OemBridgeFilter("KalidoDiw"), OemBridgeFilter.MIMB_BRIDGES),
    OEM_METAMATRIX_MODELER(null, OemBridgeFilter.MIMB_BRIDGES, OemBridgeFilter.MIMB_BRIDGES),
    OEM_POPKIN_SA(null, new OemBridgeFilter("PopkinSa*"), new OemBridgeFilter("PopkinSa*", "MITI")),
    OEM_SAS("SAS Web Services (temporary)", new OemBridgeFilter("OmgCwmXmi", "MITI"), new OemBridgeFilter("OmgCwmXmi", "MITI", "MetaIntegrationProfilingXml")),
    OEM_SYNCSORT_DMEXPRESS(null, new OemBridgeFilter("SyncsortDMExpress*", "MITI"), new OemBridgeFilter("SyncsortDMExpress*", "MITI")),
    OEM_SYPHERLINK("SypherlikHarvester5_20080919185625", new OemBridgeFilter("Sypherlink*"), OemBridgeFilter.MIMB_BRIDGES),
    OEM_TALEND("Talend 2015_#7u^MZLmEiuR", new OemBridgeFilter(new String[]{"Talend"}){

        @Override
        public boolean isValidBridge(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
            return !bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Data Integration") || bridgeSpecificationLiteral.getBridge_Id().equals("AscentialDataStage") || bridgeSpecificationLiteral.getBridge_Id().equals("InformaticaPowerCenter");
        }
    }, new OemBridgeFilter(new String[]{"Talend", "MITI"}){

        @Override
        public boolean isValidBridge(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
            return !bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Data Integration");
        }
    }),
    OEM_TALEND_MDM("Talend 2016_?5%6&*9@!AS.Jx", new OemBridgeFilter(new String[]{"TalendMdm"}){

        @Override
        public boolean isValidBridge(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
            return bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Data Modeling") || bridgeSpecificationLiteral.getBridge_Id().equals("MicrosoftExcel");
        }
    }, new OemBridgeFilter(new String[]{"TalendMdm", "MITI"}){

        @Override
        public boolean isValidBridge(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
            return bridgeSpecificationLiteral.getMethodology_ToolCategory().equals("Data Modeling") || bridgeSpecificationLiteral.getBridge_Id().equals("MicrosoftExcel");
        }
    }),
    OEM_MICROSOFT_DATACATALOG("MicrosoftDataCatalog2020_h^D$3-+=2#*", OemBridgeFilter.MIMB_BRIDGES, new OemBridgeFilter("ApacheAtlas", "MicrosoftAzureDataCatalog", "MITI")),
    OEM_PRECISELY("Precisely2024_k$(Esl@2=-71#Md3", OemBridgeFilter.MIMB_BRIDGES, new OemBridgeFilter("MetaIntegrationProfilingXml", "MITI")),
    MIR_WEB("Meta Integration Repository Management Web", OemBridgeFilter.ALL_BRIDGES, OemBridgeFilter.ALL_BRIDGES),
    UNKNOWN(null, OemBridgeFilter.NO_BRIDGES, OemBridgeFilter.NO_BRIDGES),
    NOT_OEM(null, OemBridgeFilter.ALL_BRIDGES, OemBridgeFilter.ALL_BRIDGES),
    MIMB_WEB("Meta Integration Model Bridge Web", OemBridgeFilter.ALL_BRIDGES, OemBridgeFilter.ALL_BRIDGES),
    MIMB_CLOUD_TEST("MIMB_CLOUD_TEST", OemBridgeFilter.MIMB_BRIDGES, new OemBridgeFilter("MITI"));

    private final String callerId;
    private OemBridgeFilter importBridges;
    private OemBridgeFilter exportBridges;

    private OEMCode(String string2, OemBridgeFilter oemBridgeFilter, OemBridgeFilter oemBridgeFilter2) {
        this.callerId = string2;
        this.importBridges = oemBridgeFilter;
        this.exportBridges = oemBridgeFilter2;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public boolean matches(String string) {
        return this.callerId != null && this.callerId.equals(string);
    }

    public boolean isOemBridge(String string, boolean bl) {
        return bl ? this.exportBridges.isOemBridge(string) : this.importBridges.isOemBridge(string);
    }

    public boolean isValidBridge(BridgeSpecificationLiteral bridgeSpecificationLiteral, boolean bl) {
        return bl ? this.exportBridges.isValidBridge(bridgeSpecificationLiteral) : this.importBridges.isValidBridge(bridgeSpecificationLiteral);
    }
}

